/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.dialogs;

import com.ezware.dialog.task.TaskDialog;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ExpandableDialog {
    private static final I18N _I18N = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");

    public static void showError(Component parentComponent, String title, String message, String details) {
        ExpandableDialog.show(parentComponent, title, message, null, details, Type.ERROR, false);
    }

    public static void showWarning(Component parentComponent, String title, String message, String details) {
        ExpandableDialog.show(parentComponent, title, message, null, details, Type.WARNING, false);
    }

    public static void showInfo(Component parentComponent, String title, String message, String details) {
        ExpandableDialog.show(parentComponent, title, message, null, details, Type.INFORMATION, false);
    }

    public static void showError(Component parentComponent, String message, String details) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-error"), message, null, details, Type.ERROR, false);
    }

    public static void showWarning(Component parentComponent, String message, String details) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-warning"), message, null, details, Type.WARNING, false);
    }

    public static void showInfo(Component parentComponent, String message, String details) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-information"), message, null, details, Type.INFORMATION, false);
    }

    public static void showError(Component parentComponent, String message, String details, boolean expanded) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-error"), message, null, details, Type.ERROR, expanded);
    }

    public static void showWarning(Component parentComponent, String message, String details, boolean expanded) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-warning"), message, null, details, Type.WARNING, expanded);
    }

    public static void showInfo(Component parentComponent, String message, String details, boolean expanded) {
        ExpandableDialog.show(parentComponent, _I18N.get("de.riwagis.util.gui.dialogs.ExpandableDialog.title-information"), message, null, details, Type.INFORMATION, expanded);
    }

    public static void show(Component parentComponent, String title, String message, String instruction, String details, Type type, boolean expanded) {
        Window parentWindow = parentComponent == null || parentComponent instanceof Window ? (Window)parentComponent : SwingUtilities.windowForComponent(parentComponent);
        switch (type) {
            case PLAIN: 
            case INFORMATION: {
                ExpandableDialog.showWithScrollableDetails(parentWindow, title, message, instruction, details, (Icon)TaskDialog.StandardIcon.INFO, expanded);
                break;
            }
            case WARNING: {
                ExpandableDialog.showWithScrollableDetails(parentWindow, title, message, instruction, details, (Icon)TaskDialog.StandardIcon.WARNING, expanded);
                break;
            }
            case ERROR: {
                ExpandableDialog.showWithScrollableDetails(parentWindow, title, message, instruction, details, (Icon)TaskDialog.StandardIcon.ERROR, expanded);
            }
        }
    }

    public static void showWithScrollableDetails(Window parent, String title, String message, String instruction, String detailText, Icon icon, boolean expanded) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> ExpandableDialog.showWithScrollableDetails(parent, title, message, instruction, detailText, icon, expanded));
            return;
        }
        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(message);
        dlg.setText(instruction);
        dlg.setIcon(icon);
        dlg.setCommands(new TaskDialog.Command[]{TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey((String)"Close"))});
        JComponent textComp = detailText.startsWith("<html>") ? ExpandableDialog.getHtmlTextArea(detailText) : ExpandableDialog.getPlainTextArea(detailText);
        JScrollPane scroller = new JScrollPane(textComp);
        scroller.setPreferredSize(new Dimension(400, 200));
        dlg.getDetails().setExpandableComponent((JComponent)scroller);
        dlg.getDetails().setExpanded(expanded);
        dlg.setResizable(true);
        dlg.setVisible(true);
    }

    private static JComponent getPlainTextArea(String plainText) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setText(plainText);
        textArea.setCaretPosition(0);
        return textArea;
    }

    private static JComponent getHtmlTextArea(String htmlText) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setFont(UIManager.getFont("Label.font"));
        editorPane.setText(htmlText);
        editorPane.setCaretPosition(0);
        return editorPane;
    }

    private ExpandableDialog() {
    }

    public static enum Type {
        ERROR,
        INFORMATION,
        WARNING,
        PLAIN;

    }
}

