/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.dialogs;

import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.dialogs.LookupJDBCDBMetaDialog;
import de.riwagis.util.jdbc.JDBCDBMeta;
import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import de.riwagis.util.jdbc.SavedJDBCDBConnectionEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLoginDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DBLoginDialog.class);
    private final List<SavedJDBCDBConnectionEntry> savedConnections;
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butLookup;
    private JButton butOK;
    private JComboBox<String> cmbDriver;
    private JComboBox<String> cmbURL;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JLabel lblDriver;
    private JLabel lblHeader;
    private JLabel lblPwd;
    private JLabel lblServicename;
    private JLabel lblURL;
    private JLabel lblUser;
    private JPasswordField txtPwd;
    private JTextField txtServicename;
    private JTextField txtUser;

    public static JDBCDBMetaInterface queryDBMeta(Frame _parent, JDBCDBMetaInterface _meta, List<SavedJDBCDBConnectionEntry> savedEntries) {
        return DBLoginDialog.queryDBMeta(_parent, "Datenbankverbindung", _meta, savedEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static JDBCDBMetaInterface queryDBMeta(Frame _parent, String title, JDBCDBMetaInterface _meta, List<SavedJDBCDBConnectionEntry> savedEntries) {
        DBLoginDialog dlg = new DBLoginDialog((Window)_parent, savedEntries);
        try {
            dlg.setHeader(title);
            dlg.setDBMeta(_meta);
            GUISupport.centreComponent(dlg, _parent);
            dlg.setVisible(true);
            if (dlg.isBolOKPressed()) {
                try {
                    JDBCDBMetaInterface jDBCDBMetaInterface = dlg.getDBMeta();
                    return jDBCDBMetaInterface;
                }
                catch (Exception ex) {
                    LOG.warn("Error retrieving DB-Meta", (Throwable)ex);
                    JDBCDBMetaInterface jDBCDBMetaInterface = null;
                    GUISupport.disposeQuietly(dlg);
                    return jDBCDBMetaInterface;
                }
            }
            JDBCDBMetaInterface jDBCDBMetaInterface = null;
            return jDBCDBMetaInterface;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            GUISupport.disposeQuietly(dlg);
        }
    }

    public DBLoginDialog(Window parent) {
        this(parent, (List<SavedJDBCDBConnectionEntry>)null);
    }

    public DBLoginDialog(Window parent, List<SavedJDBCDBConnectionEntry> savedEntries) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.setResizable(true);
        this.savedConnections = savedEntries;
        this.butLookup.setVisible(this.savedConnections != null);
        this.updateControls();
    }

    public void setHeader(String strHeader) {
        this.lblHeader.setText(strHeader);
    }

    public boolean wasOKPressed() {
        return this.isBolOKPressed();
    }

    public void setDBMeta(JDBCDBMetaInterface _dbMeta) {
        this.cmbDriver.setSelectedItem(StringUtils.defaultString((String)_dbMeta.getDBDriver()));
        this.cmbURL.setSelectedItem(StringUtils.defaultString((String)_dbMeta.getDBUrl()));
        this.txtUser.setText(StringUtils.defaultString((String)_dbMeta.getUsername()));
        this.txtPwd.setText(StringUtils.defaultString((String)_dbMeta.getPassword()));
        this.txtServicename.setText(StringUtils.defaultString((String)_dbMeta.getDBService()));
    }

    public JDBCDBMetaInterface getDBMeta() {
        JDBCDBMeta newDBMeta = new JDBCDBMeta(ObjectUtils.toString((Object)this.cmbDriver.getSelectedItem()), ObjectUtils.toString((Object)this.cmbURL.getSelectedItem()), ObjectUtils.toString((Object)this.txtUser.getText()), String.valueOf(this.txtPwd.getPassword()), ObjectUtils.toString((Object)this.txtServicename.getText()));
        return newDBMeta;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.lblHeader = new JLabel();
        this.butLookup = new JButton();
        this.lblDriver = new JLabel();
        this.cmbDriver = new JComboBox();
        this.lblURL = new JLabel();
        this.cmbURL = new JComboBox();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPwd = new JLabel();
        this.txtPwd = new JPasswordField();
        this.lblServicename = new JLabel();
        this.txtServicename = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Datenbankverbindung");
        this.setBackground(Color.white);
        this.setMinimumSize(new Dimension(200, 220));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(new Dimension(400, 260));
        this.jPanel3.setPreferredSize(new Dimension(400, 260));
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblHeader.setFont(this.lblHeader.getFont().deriveFont(this.lblHeader.getFont().getStyle() | 1, this.lblHeader.getFont().getSize() + 1));
        this.lblHeader.setText("Datenbankverbindung");
        this.lblHeader.setMaximumSize(new Dimension(65535, 65535));
        this.lblHeader.setPreferredSize(new Dimension(142, 21));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.lblHeader, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/util/i18n/i18n");
        this.butLookup.setText(bundle.getString("de.riwagis.DBLoginDialog.lookupSavedConnection"));
        this.butLookup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBLoginDialog.this.butLookup_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 15, 5);
        this.jPanel3.add((Component)this.butLookup, gridBagConstraints);
        this.lblDriver.setHorizontalAlignment(11);
        this.lblDriver.setLabelFor(this.cmbDriver);
        this.lblDriver.setText("Treiber:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblDriver, gridBagConstraints);
        this.cmbDriver.setEditable(true);
        this.cmbDriver.setModel(new DefaultComboBoxModel<String>(new String[]{"oracle.jdbc.driver.OracleDriver", "com.mysql.jdbc.Driver"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add(this.cmbDriver, gridBagConstraints);
        this.lblURL.setHorizontalAlignment(11);
        this.lblURL.setLabelFor(this.cmbURL);
        this.lblURL.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblURL, gridBagConstraints);
        this.cmbURL.setEditable(true);
        this.cmbURL.setModel(new DefaultComboBoxModel<String>(new String[]{"jdbc:oracle:thin:@host:port:sid", "jdbc:mysql://host:port/dbname", "jdbc:odbc:dsn_name;UID=uid;PWD=pwd"}));
        this.cmbURL.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add(this.cmbURL, gridBagConstraints);
        this.lblUser.setHorizontalAlignment(11);
        this.lblUser.setLabelFor(this.txtUser);
        this.lblUser.setText("Benutzername:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtUser, gridBagConstraints);
        this.lblPwd.setHorizontalAlignment(11);
        this.lblPwd.setLabelFor(this.txtPwd);
        this.lblPwd.setText("Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblPwd, gridBagConstraints);
        this.txtPwd.setText("avs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtPwd, gridBagConstraints);
        this.lblServicename.setHorizontalAlignment(11);
        this.lblServicename.setLabelFor(this.txtServicename);
        this.lblServicename.setText("Servicename:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel3.add((Component)this.lblServicename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.jPanel3.add((Component)this.txtServicename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(90, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBLoginDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("Abbruch");
        this.butCancel.setPreferredSize(new Dimension(90, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBLoginDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private void butLookup_onActionPerformed(ActionEvent evt) {
        SavedJDBCDBConnectionEntry tmpMeta = LookupJDBCDBMetaDialog.lookup(this, this.savedConnections, null);
        if (tmpMeta != null) {
            this.setDBMeta(tmpMeta.getDbMeta());
        }
        this.updateControls();
    }

    private void updateControls() {
    }

    public boolean isBolOKPressed() {
        return this.bolOKPressed;
    }
}

