/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components.filechooser;

import de.riwagis.util.gui.components.filechooser.DefaultFileChooserEventValidator;
import de.riwagis.util.gui.components.filechooser.FileChooserValidable;
import de.riwagis.util.gui.components.filechooser.FileChooserValidationEvent;
import de.riwagis.util.gui.components.filechooser.FileChooserValidator;
import de.riwagis.util.gui.components.filechooser.ValidationException;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationFileChooser
extends JFileChooser {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationFileChooser.class);
    private FileChooserValidable e;

    public ValidationFileChooser() {
        this((Map<ValidationDlgType, FileChooserValidator>)null);
    }

    public ValidationFileChooser(Map<ValidationDlgType, FileChooserValidator> map) {
        this.setValidatorsMapToEvent(map);
    }

    private void setValidatorsMapToEvent(Map<ValidationDlgType, FileChooserValidator> map) {
        Map<ValidationDlgType, FileChooserValidator> myMap;
        this.e = new FileChooserValidationEvent();
        if (map == null) {
            myMap = new EnumMap<ValidationDlgType, FileChooserValidator>(ValidationDlgType.class);
            DefaultFileChooserEventValidator v = new DefaultFileChooserEventValidator();
            myMap.put(ValidationDlgType.SAVE_DIALOG, v);
        } else {
            myMap = map;
        }
        this.e.setValidators(myMap);
    }

    @Override
    public void approveSelection() {
        this.e.setDialogType(ValidationDlgType.getValidationByType(this.getDialogType()));
        this.e.setSelectedFile(this.getSelectedFile());
        try {
            this.e.validate();
        }
        catch (ValidationException ex) {
            LOG.debug("validation exception: " + ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.e.getMessages().get(0));
            this.e.getMessages().clear();
            return;
        }
        super.approveSelection();
    }

    public static enum ValidationDlgType {
        ALWAYS(-1),
        OPEN_DIALOG(0),
        SAVE_DIALOG(1);

        private final int typeValue;

        private ValidationDlgType(int typeValue) {
            this.typeValue = typeValue;
        }

        public int getTypeValue() {
            return this.typeValue;
        }

        public static ValidationDlgType getValidationByType(int typeValue) {
            for (ValidationDlgType dlgType : ValidationDlgType.values()) {
                if (dlgType.getTypeValue() != typeValue) continue;
                return dlgType;
            }
            return null;
        }
    }
}

