/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components;

import de.riwagis.util.Config;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.thread.Cancelable;
import de.riwagis.util.thread.ThreadUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitDialog
extends JDialog
implements Cancelable,
StatusDisplayer {
    private static final Logger LOG = LoggerFactory.getLogger(WaitDialog.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    private static final int MIN_DIALOG_HEIGHT = 80;
    private static final int MIN_DIALOG_WIDTH = 200;
    private final Component parent;
    private final WorkerThread worker = new WorkerThread();
    private final Lock lockVisi = new ReentrantLock();
    private Exception err = null;
    private boolean bolCancelled = false;
    private JButton butCancel;
    private JLabel lblIcon;
    private JLabel lblMessage;

    public static WaitDialog createWaitDialog(Window parent, String strMessage) {
        return new WaitDialog(parent, strMessage);
    }

    public static WaitDialog createWaitDialog(Window parent, String strMessage, Callable<?> workToDo) {
        return new WaitDialog(parent, strMessage, workToDo);
    }

    public static WaitDialog createWaitDialog(Window parent, String strMessage, Runnable workToDo) {
        return new WaitDialog(parent, strMessage, workToDo);
    }

    public WaitDialog(Window _parent, String _strMessage) {
        super(_parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.parent = _parent;
        this.initComponents();
        this.setMessage(_strMessage);
        this.repaint();
        this.i18n();
        this.initGui();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent arg0) {
                if (!WaitDialog.this.worker.isStarted()) {
                    WaitDialog.this.worker.start();
                }
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                try {
                    WaitDialog.this.worker.interrupt();
                }
                catch (Exception e) {
                    LOG.warn("Interrupted", (Throwable)e);
                }
            }
        });
        this.setFocusable(false);
    }

    public WaitDialog(Window _parent, String _strMessage, Runnable _workToDo) {
        this(_parent, _strMessage);
        this.addWorkToDo(_workToDo);
    }

    public WaitDialog(Window _parent, String _strMessage, Callable<?> _workToDo) {
        this(_parent, _strMessage);
        this.addWorkToDo(_workToDo);
    }

    public void setCancelable(boolean bolValue) {
        this.butCancel.setVisible(bolValue);
    }

    public Exception getError() {
        return this.err;
    }

    public void setError(Exception e) {
        this.err = e;
    }

    public final void addWorkToDo(Runnable _workToDo) {
        this.worker.addWorkToDo(Executors.callable(_workToDo));
    }

    public final void addWorkToDo(Callable<?> _workToDo) {
        this.worker.addWorkToDo(_workToDo);
    }

    @Deprecated
    public void setWorkToDo(Runnable _workToDo) {
        this.worker.clear();
        this.addWorkToDo(_workToDo);
    }

    @Override
    public final void setMessage(String _strMessage) {
        this.lblMessage.setText(String.format("<html>%s<html>", StringUtils.replace((String)_strMessage, (String)"\n", (String)"<br>")));
        this.initGui();
    }

    private void i18n() {
        this.butCancel.setText(i18n.get("common.cancel"));
    }

    private void initGui() {
        this.pack();
        Dimension packedDim = this.getSize();
        this.setSize(Math.max(200, packedDim.width), Math.max(80, packedDim.height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(long time2wait) {
        if (this.parent != null && this.parent.isVisible()) {
            GUISupport.centreComponent(this, this.parent);
        } else {
            GUISupport.centreOnScreen(this);
        }
        long endtime = System.currentTimeMillis() + time2wait;
        this.worker.start();
        while (endtime > System.currentTimeMillis() && !this.worker.isFinished()) {
            ThreadUtils.sleepQuietly((long)10L);
        }
        this.lockVisi.lock();
        try {
            if (!this.worker.isFinished()) {
                this.setVisible(true);
            }
        }
        finally {
            try {
                this.lockVisi.unlock();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void setVisible(boolean bolVisi) {
        if (bolVisi) {
            if (this.parent != null && this.parent.isVisible()) {
                Window owner = this.getOwner();
                Dimension d = owner.getSize();
                Point p = owner.getLocation();
                this.setLocation((d.width - this.getWidth()) / 2 + p.x, (d.height - this.getHeight()) / 2 + p.y);
            } else {
                GUISupport.centreOnScreen(this);
            }
        }
        try {
            this.lockVisi.unlock();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.setVisible(bolVisi);
        if (!bolVisi && this.getDefaultCloseOperation() == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitDialog.this.dispose();
                }
            });
        }
    }

    public boolean wasCancelled() {
        return this.bolCancelled;
    }

    public boolean isCanceled() {
        return this.bolCancelled;
    }

    public void cancel() {
        this.bolCancelled = true;
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.lblMessage = new JLabel();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/riwagis/util/gui/components/wait.gif")));
        this.lblIcon.setLabelFor(this.lblMessage);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)this.lblIcon, gridBagConstraints);
        this.lblMessage.setText("Bitte warten...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 3, 5);
        this.getContentPane().add((Component)this.lblMessage, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolCancelled = true;
        this.setVisible(false);
    }

    private class WorkerThread
    extends Thread {
        private final AtomicBoolean bolStarted = new AtomicBoolean(false);
        private final AtomicBoolean bolFinished = new AtomicBoolean(false);
        private final Queue<Callable<?>> workToDoList = new LinkedList();

        public WorkerThread() {
            this.setName("WaitDialogThread");
        }

        public boolean isStarted() {
            return this.bolStarted.get();
        }

        public boolean isFinished() {
            return this.bolFinished.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.bolStarted.set(true);
            Callable<?> workToDo = null;
            do {
                Queue<Callable<?>> queue = this.workToDoList;
                synchronized (queue) {
                    workToDo = this.workToDoList.poll();
                }
                if (workToDo == null) continue;
                try {
                    workToDo.call();
                }
                catch (Exception x) {
                    WaitDialog.this.setError(x);
                }
            } while (this.getWorkToDoSize() > 0);
            this.bolFinished.set(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitDialog.this.lockVisi.lock();
                    try {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex) {
                            LOG.error("Wait interrupted", (Throwable)ex);
                        }
                        WaitDialog.this.setVisible(false);
                    }
                    finally {
                        try {
                            WaitDialog.this.lockVisi.unlock();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Queue<Callable<?>> queue = this.workToDoList;
            synchronized (queue) {
                this.workToDoList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addWorkToDo(Callable<?> _workToDo) {
            if (_workToDo != null) {
                Queue<Callable<?>> queue = this.workToDoList;
                synchronized (queue) {
                    this.workToDoList.add(_workToDo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getWorkToDoSize() {
            Queue<Callable<?>> queue = this.workToDoList;
            synchronized (queue) {
                return this.workToDoList.size();
            }
        }
    }
}

