/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components;

import de.riwagis.util.Config;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class TextFieldFileChooser
extends JPanel {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    public static final int MODE_OPEN_FILE = 0;
    public static final int MODE_SAVE_FILE = 1;
    private File fileSelected = null;
    private final String strWait = i18n.get("gui.components.TextFieldFileChooser.choose");
    private final JFileChooser fChoose = new JFileChooser();
    private final JFileChooser fChooseOvr = GUISupport.createJFileChooserOverwritePrompting();
    private int intMode = 0;
    private boolean bolOnlyDirectories = false;
    private final Collection<String> arrFileFilter = new LinkedHashSet<String>();
    private JButton butChoose;
    private JTextField txtPath;

    public TextFieldFileChooser() {
        this.initComponents();
        double dblHeight = Math.max(this.txtPath.getPreferredSize().getHeight(), this.butChoose.getPreferredSize().getHeight());
        double dblWidth = this.txtPath.getPreferredSize().getWidth() + this.butChoose.getPreferredSize().getWidth();
        this.setPreferredSize(new Dimension((int)dblWidth, (int)dblHeight));
        this.fChoose.setMultiSelectionEnabled(false);
        this.fChooseOvr.setMultiSelectionEnabled(false);
    }

    public File getFile() {
        return this.fileSelected;
    }

    public void setFile(File _fileSelected) {
        this.fileSelected = _fileSelected;
        this.txtPath.setText(this.fileSelected.getAbsolutePath());
    }

    public String getAbsolutePath() {
        if (this.fileSelected != null) {
            return this.fileSelected.getAbsolutePath();
        }
        return null;
    }

    public void setAbsolutePath(String strPath) {
        this.setFile(new File(strPath));
    }

    public void displayChoose(boolean bolDisplayChoose) {
        if (bolDisplayChoose) {
            this.butChoose.setText(this.strWait);
        } else {
            this.butChoose.setText("...");
        }
    }

    public void setMode(int _intMode) {
        this.intMode = _intMode;
    }

    public int getMode() {
        return this.intMode;
    }

    public void onlyDirectories(boolean _bolOnlyDirectories) {
        this.bolOnlyDirectories = _bolOnlyDirectories;
    }

    public void setFileTypes(String[] _arrFileTypes) {
        this.arrFileFilter.clear();
        this.arrFileFilter.addAll(Arrays.asList(_arrFileTypes));
    }

    private void initComponents() {
        this.txtPath = new JTextField();
        this.butChoose = new JButton();
        this.setLayout(new BorderLayout());
        this.txtPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TextFieldFileChooser.this.txtPathKeyReleased(evt);
            }
        });
        this.add((Component)this.txtPath, "Center");
        this.butChoose.setText("w\u00e4hlen");
        this.butChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFieldFileChooser.this.butChooseActionPerformed(evt);
            }
        });
        this.add((Component)this.butChoose, "After");
    }

    private void txtPathKeyReleased(KeyEvent evt) {
        String pathTxt = this.txtPath.getText();
        this.fileSelected = StringUtils.isBlank((CharSequence)pathTxt) ? null : new File(pathTxt);
    }

    private void butChooseActionPerformed(ActionEvent evt) {
        int intRetValue;
        JFileChooser fChooseCurrent = switch (this.intMode) {
            case 0 -> this.fChoose;
            case 1 -> this.fChooseOvr;
            default -> this.fChoose;
        };
        if (this.fileSelected != null) {
            fChooseCurrent.setSelectedFile(this.fileSelected);
        } else {
            fChooseCurrent.setSelectedFile(new File(System.getProperty("user.home")));
        }
        if (this.arrFileFilter.isEmpty()) {
            fChooseCurrent.setFileFilter(null);
            fChooseCurrent.setAcceptAllFileFilterUsed(true);
        } else {
            fChooseCurrent.setFileFilter(GUISupport.createFileFilter("", this.arrFileFilter.toArray(new String[0])));
            fChooseCurrent.setAcceptAllFileFilterUsed(false);
        }
        if (this.bolOnlyDirectories) {
            fChooseCurrent.setFileSelectionMode(1);
        }
        if ((intRetValue = this.intMode == 1 ? fChooseCurrent.showSaveDialog(this) : fChooseCurrent.showOpenDialog(this)) == 1) {
            return;
        }
        this.setFile(fChooseCurrent.getSelectedFile());
    }
}

