/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class SelfClosingMessageBox
extends JDialog {
    private JPanel jPanel1;
    private JLabel lblMessage;
    private JProgressBar prgRemaining;

    public static void showSelfClosingMessageBox(Window parent, String strMessage, int millis2wait) {
        SelfClosingMessageBox msgBox = new SelfClosingMessageBox(parent, strMessage, millis2wait);
        msgBox.setVisible(true);
    }

    public SelfClosingMessageBox(Window parent, String strMessage, final int millis2wait) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.initComponents();
        this.lblMessage.setText(strMessage);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent arg0) {
                SelfClosingMessageBox.this.prgRemaining.setMaximum(millis2wait);
                SelfClosingMessageBox.this.prgRemaining.setMinimum(0);
                final long start = System.currentTimeMillis();
                final Timer t = new Timer(10, null);
                t.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int timeElapsed = (int)(System.currentTimeMillis() - start);
                        if (timeElapsed > millis2wait) {
                            t.stop();
                            SelfClosingMessageBox.this.setVisible(false);
                            SelfClosingMessageBox.this.dispose();
                        }
                        SelfClosingMessageBox.this.prgRemaining.setValue(timeElapsed);
                    }
                });
                t.start();
            }
        });
        this.initGui();
    }

    public void setMessage(String _strMessage) {
        this.lblMessage.setText(_strMessage);
        this.initGui();
    }

    private void initGui() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblMessage = new JLabel();
        this.prgRemaining = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblMessage.setText("Message");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(13, 13, 13, 13);
        this.jPanel1.add((Component)this.lblMessage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.prgRemaining.setMinimumSize(new Dimension(10, 4));
        this.prgRemaining.setPreferredSize(new Dimension(150, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.prgRemaining, gridBagConstraints);
        this.pack();
    }

    public static void main(String[] args) {
        SelfClosingMessageBox.showSelfClosingMessageBox(null, "HI", 5000);
    }
}

