/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components;

import de.riwagis.util.Config;
import de.riwagis.util.gui.components.images.Icon;
import de.riwagis.util.gui.renderers.TableButtonColumnRenderer;
import de.riwagis.util.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FileListTable
extends JPanel {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    private ImageIcon icoRemove = Icon.icon("remove.png");
    private ImageIcon icoDocument = Icon.icon("doc.gif");
    private ImageIcon icoError = Icon.icon("docred.gif");
    private ImageIcon icoLink = Icon.icon("link.png");
    private ImageIcon icoFolder = Icon.icon("folder.png");
    private final List<FileContent> fc = new ArrayList<FileContent>();
    private final AbstractTableModel tblModel = new AbstractTableModel(){
        private final String[] headings = new String[]{"File", ""};
        private final Class<?>[] columnClasses = new Class[]{Object.class, ImageIcon.class};

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return FileListTable.this.icoRemove;
            }
            return FileListTable.this.fc.get(rowIndex);
        }

        @Override
        public String getColumnName(int column) {
            return this.headings[column];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FileListTable.this.fc.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    };
    private JScrollPane jScrollPane1;
    private JTable tblFiles;

    public FileListTable() {
        this.initComponents();
        this.init();
        this.i18n();
    }

    public void addFile(File newFile) {
        this.addFile(newFile.getName(), newFile);
    }

    public void addFile(String documentName, Object newFile) {
        if (!this.isEntryInList(newFile)) {
            this.fc.add(new FileContent(documentName, newFile));
            this.tblModel.fireTableDataChanged();
        }
    }

    public void insertFile(int rowIndex, String documentName, Object newFile) {
        if (!this.isEntryInList(newFile)) {
            this.fc.add(rowIndex, new FileContent(documentName, newFile));
            this.tblModel.fireTableDataChanged();
        }
    }

    public void removeFile(int rowIndex) {
        this.fc.remove(rowIndex);
        this.tblModel.fireTableDataChanged();
    }

    public boolean isEntryInList(Object newFile) {
        return this.indexOfFile(newFile) >= 0;
    }

    public int indexOfFile(Object newFile) {
        for (int i = 0; i < this.fc.size(); ++i) {
            FileContent currContent = this.fc.get(i);
            if (!currContent.getFullContent().equals(newFile)) continue;
            return i;
        }
        return -1;
    }

    public FileContent fileOfIndex(int row) {
        if (row >= 0 && row < this.fc.size()) {
            return this.fc.get(row);
        }
        return null;
    }

    public boolean removeFile(FileContent file2remove) {
        if (this.fc.remove(file2remove)) {
            this.tblModel.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public String getTooltip(int rowIndex) {
        return this.fc.get(rowIndex).getErrorMessage();
    }

    public void removeAllFiles() {
        this.fc.clear();
        this.tblModel.fireTableDataChanged();
    }

    public Collection<FileContent> getAllFiles() {
        return new ArrayList<FileContent>(this.fc);
    }

    public Collection<FileContent> getSelectedFiles() {
        ArrayList<FileContent> lstFiles = new ArrayList<FileContent>();
        for (int row : this.tblFiles.getSelectedRows()) {
            lstFiles.add(this.fc.get(row));
        }
        return lstFiles;
    }

    public Collection<FileContent> deleteSelectedFiles() {
        Collection<FileContent> selectedFiles = this.getSelectedFiles();
        if (!selectedFiles.isEmpty()) {
            for (FileContent currContent : selectedFiles) {
                this.fc.remove(currContent);
            }
        }
        this.tblModel.fireTableDataChanged();
        return selectedFiles;
    }

    private void init() {
        this.tblFiles.setRowHeight(25);
        this.tblFiles.getColumnModel().getColumn(1).setMaxWidth(50);
        this.tblFiles.getColumnModel().getColumn(1).setMinWidth(50);
        this.tblFiles.getColumnModel().getColumn(1).setWidth(50);
        TableButtonColumnRenderer.registerColumnRenderer(this.tblFiles, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                FileListTable.this.fc.remove(modelRow);
                FileListTable.this.tblModel.fireTableDataChanged();
            }
        }, 1);
        this.tblFiles.getColumnModel().getColumn(0).setCellRenderer(new FileTableCellRenderer());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListTable.this.deleteSelectedFiles();
            }
        };
        KeyStroke keystroke = KeyStroke.getKeyStroke(127, 0, false);
        this.tblFiles.registerKeyboardAction(actionListener, keystroke, 0);
    }

    private void i18n() {
        this.tblFiles.getColumnModel().getColumn(0).setHeaderValue(i18n.get("gui.components.FileListTable.file"));
        this.tblFiles.getTableHeader().resizeAndRepaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblFiles = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                if (rowIndex >= 0) {
                    tip = FileListTable.this.getTooltip(rowIndex);
                }
                return tip;
            }
        };
        this.setLayout(new GridBagLayout());
        this.tblFiles.setModel(this.tblModel);
        this.tblFiles.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblFiles);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public static void main(String ... args) {
        JDialog f = new JDialog(null, "test", Dialog.ModalityType.APPLICATION_MODAL);
        f.getContentPane().setLayout(new BorderLayout());
        FileListTable fileListTable = new FileListTable();
        fileListTable.addFile(new File("D:\\test.txt"));
        fileListTable.addFile("looooooooooooooooooooooooooooooooong_filename.txt", "file://E:\\temp\\xxx\\test.txt");
        fileListTable.addFile("filename.txt", "file://E:\\temp\\looooooooooooooooooooooooooooooooong_xxx\\test.txt");
        fileListTable.addFile(new File("E:\\temp\\pst\\test.txt"));
        fileListTable.addFile("buch.txt", "riwadms://xxx?name=buch.txt&id=304834");
        f.getContentPane().add((Component)fileListTable, "Center");
        fileListTable.fileOfIndex(1).setErrorMessage("bla bla bla");
        f.setSize(640, 480);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        f.dispose();
    }

    public ImageIcon getIcoRemove() {
        return this.icoRemove;
    }

    public void setIcoRemove(ImageIcon icoRemove) {
        this.icoRemove = icoRemove;
    }

    public ImageIcon getIcoDocument() {
        return this.icoDocument;
    }

    public void setIcoDocument(ImageIcon icoDocument) {
        this.icoDocument = icoDocument;
    }

    public ImageIcon getIcoError() {
        return this.icoError;
    }

    public void setIcoError(ImageIcon icoError) {
        this.icoError = icoError;
    }

    public ImageIcon getIcoLink() {
        return this.icoLink;
    }

    public void setIcoLink(ImageIcon icoLink) {
        this.icoLink = icoLink;
    }

    public ImageIcon getIcoFolder() {
        return this.icoFolder;
    }

    public void setIcoFolder(ImageIcon icoFolder) {
        this.icoFolder = icoFolder;
    }

    public static final class FileContent
    implements Serializable {
        private static final long serialVersionUID = -41689196711987133L;
        private final String documentName;
        private final Object fullContent;
        private String errorMessage = "";

        public FileContent(String documentName, Object fullContent) {
            this.documentName = documentName;
            this.fullContent = fullContent;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public Object getFullContent() {
            return this.fullContent;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    private class FileTableCellRenderer
    extends DefaultTableCellRenderer {
        private final JPanel pnlFile = new JPanel();
        private final JLabel lblFileName = new JLabel();
        private final JLabel lblFolder = new JLabel();
        private final JLabel lblErrorIcon = new JLabel();

        private FileTableCellRenderer() {
            this.pnlFile.setLayout(new BoxLayout(this.pnlFile, 0));
            this.pnlFile.setOpaque(true);
            this.lblErrorIcon.setIcon(FileListTable.this.icoError);
            this.pnlFile.add(this.lblErrorIcon);
            this.lblFileName.setIcon(FileListTable.this.icoDocument);
            this.pnlFile.add(this.lblFileName);
            this.lblFolder.setIcon(FileListTable.this.icoFolder);
            this.pnlFile.add(this.lblFolder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.lblErrorIcon.setIcon(FileListTable.this.icoError);
            this.lblFileName.setIcon(FileListTable.this.icoDocument);
            if (value == null) {
                value = "";
            }
            FileContent currFC = (FileContent)value;
            String errorMessage = currFC.getErrorMessage();
            Object fullContent = currFC.getFullContent();
            this.lblErrorIcon.setVisible(StringUtils.isNotBlank((CharSequence)errorMessage));
            if (fullContent instanceof File) {
                File file2display = (File)fullContent;
                this.lblFileName.setText(file2display.getName());
                if (file2display.getParentFile() != null) {
                    this.lblFolder.setIcon(FileListTable.this.icoFolder);
                    this.lblFolder.setText(file2display.getParentFile().getAbsolutePath());
                } else {
                    this.lblFolder.setIcon(null);
                    this.lblFolder.setText("");
                }
            } else {
                this.lblFileName.setText(currFC.getDocumentName());
                this.lblFolder.setIcon(FileListTable.this.icoLink);
                this.lblFolder.setVisible(true);
                this.lblFolder.setText(ObjectUtils.toString((Object)fullContent));
            }
            if (isSelected) {
                this.pnlFile.setBackground(table.getSelectionBackground());
                this.lblFileName.setForeground(table.getSelectionForeground());
                this.lblFolder.setForeground(table.getSelectionForeground());
            } else {
                this.pnlFile.setBackground(table.getBackground());
                this.lblFileName.setForeground(table.getForeground());
                this.lblFolder.setForeground(table.getForeground());
            }
            return this.pnlFile;
        }
    }
}

