/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.InsetsUIResource;

public class EditableNumberJComboBox<E>
extends JComboBox<E> {
    private Object oldValue = null;

    public EditableNumberJComboBox() {
        this.setEditor(new NumberComboBoxEditor());
        this.setRenderer(new NumberListCellRenderer());
    }

    private final class NumberComboBoxEditor
    implements ComboBoxEditor {
        private final JFormattedTextField editor;
        private final List<ActionListener> lstListeners = new ArrayList<ActionListener>();

        NumberComboBoxEditor() {
            this.editor = this.createEditorComponent();
        }

        public final JFormattedTextField createEditorComponent() {
            JFormattedTextField fmtTxt = new JFormattedTextField(DecimalFormat.getInstance());
            fmtTxt.setMargin(new InsetsUIResource(0, 0, 0, 0));
            fmtTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NumberComboBoxEditor.this.editor.setCaretPosition(NumberComboBoxEditor.this.editor.getText().length());
                        }
                    });
                }

                @Override
                public void focusLost(FocusEvent e) {
                    NumberComboBoxEditor.this.fireActionPerformed();
                }
            });
            fmtTxt.addActionListener(e -> this.fireActionPerformed());
            fmtTxt.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NumberComboBoxEditor.this.fireActionPerformed();
                }
            });
            return fmtTxt;
        }

        @Override
        public void setItem(Object anObject) {
            EditableNumberJComboBox.this.oldValue = anObject;
            if (anObject != null) {
                this.editor.setValue(anObject);
                this.editor.setCaretPosition(this.editor.getText().length());
            } else {
                this.editor.setText("");
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public Object getItem() {
            Number numEdit = (Number)this.editor.getValue();
            if (EditableNumberJComboBox.this.oldValue == null) {
                return numEdit;
            }
            if (EditableNumberJComboBox.this.oldValue instanceof Float) {
                return Float.valueOf(numEdit.floatValue());
            }
            if (EditableNumberJComboBox.this.oldValue instanceof Double) {
                return numEdit.doubleValue();
            }
            if (EditableNumberJComboBox.this.oldValue instanceof BigDecimal) {
                return new BigDecimal(numEdit.doubleValue());
            }
            if (EditableNumberJComboBox.this.oldValue instanceof Short) {
                return numEdit.shortValue();
            }
            if (EditableNumberJComboBox.this.oldValue instanceof Integer) {
                return numEdit.intValue();
            }
            if (EditableNumberJComboBox.this.oldValue instanceof Long) {
                return numEdit.longValue();
            }
            return numEdit;
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            if (this.lstListeners.contains(l)) {
                return;
            }
            this.lstListeners.add(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.lstListeners.remove(l);
        }

        private void fireActionPerformed() {
            this.commitFormattedTextEditIgnoringParseError();
            ActionEvent e = new ActionEvent(this.editor, 0, "editorChange");
            for (ActionListener lst : this.lstListeners) {
                lst.actionPerformed(e);
            }
        }

        private void commitFormattedTextEditIgnoringParseError() {
            try {
                this.editor.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private final class NumberListCellRenderer
    extends DefaultListCellRenderer {
        private NumberListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Number) {
                EditableNumberJComboBox.this.oldValue = value;
                value = DecimalFormat.getInstance().format(((Number)value).doubleValue());
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

