/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import de.riwagis.util.gui.GUISupport;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSFile {
    private static final Logger log = LoggerFactory.getLogger(OSFile.class);

    public static void showFile(File file, boolean showSaveOnError) {
        CompletableFuture.runAsync(() -> {
            block4: {
                try {
                    String os = Objects.requireNonNull(System.getProperty("os.name"), "Unknown");
                    if (os.equalsIgnoreCase("linux")) {
                        OSFile.executeOnLinux(file);
                        break block4;
                    }
                    if (os.toLowerCase().contains("windows")) {
                        OSFile.executeOnWindows(file);
                        break block4;
                    }
                    throw new UnsupportedOperationException("OS is not supported.");
                }
                catch (IOException ioex) {
                    throw new UncheckedIOException(ioex);
                }
            }
        }).exceptionally(ex -> {
            String message = Objects.requireNonNull(ex.getMessage(), "No further information");
            if (ex instanceof UnsupportedOperationException) {
                log.error("This operation is unsupported: " + message, ex);
                return null;
            }
            log.error("Could not show file to user ({}). Displaying save as dialog.", (Object)message, ex);
            if (showSaveOnError) {
                GUISupport.promptLocationAndMoveFile(file);
            }
            return null;
        });
    }

    private static void executeOnLinux(File file) throws IOException {
        Runtime.getRuntime().exec(new String[]{"xdg-open", file.toString()});
    }

    private static void executeOnWindows(File file) throws IllegalArgumentException, IOException {
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop not supported.");
        }
        String strExt = FilenameUtils.getExtension((String)file.toString());
        if (strExt.equalsIgnoreCase("exe")) {
            Runtime.getRuntime().exec(new String[]{file.toString()});
        } else {
            boolean fileWasOpenedSuccessfully = OSFile.openFileIfApplicationDefaultIsSet(file);
            if (!fileWasOpenedSuccessfully) {
                OSFile.openFileByCmd(file);
            }
        }
    }

    private static boolean openFileIfApplicationDefaultIsSet(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException | IllegalArgumentException ex) {
            log.error("Could not open file using AWT Desktop ({}): {}", (Object)file.getName(), (Object)ex);
            return false;
        }
        return true;
    }

    private static void openFileByCmd(File file) throws IOException {
        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "start", "Open file", file.toString()});
    }

    private OSFile() {
    }
}

