/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import de.riwagis.util.gui.FlatFileChooserUI_FasterIcons;
import de.riwagis.util.gui.highdpi.HighDpiSupport;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.util.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaFHelper {
    private static final Logger log = LoggerFactory.getLogger(LaFHelper.class);
    private static final Color LIGHT_GRAY = new Color(221, 221, 221);
    private static final Color VERY_LIGHT_GRAY = new Color(238, 238, 238);
    private static boolean INITIALIZED = false;

    public static void initLookAndFeel() {
        if (INITIALIZED) {
            return;
        }
        try {
            FlatLaf.registerCustomDefaultsSource((String)"de.riwagis.util.gui.themes");
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            if (SystemUtils.IS_OS_WINDOWS) {
                HighDpiSupport.fixInitialFontSizesForWindowsLookAndFeel();
                UIManager.put("TaskPaneContainer.backgroundPainter", new MattePainter((Paint)VERY_LIGHT_GRAY));
                UIManager.put("TaskPane.backgroundPainter", new MattePainter((Paint)LIGHT_GRAY));
                UIManager.put("TaskPaneContainer.background", VERY_LIGHT_GRAY);
                UIManager.put("TaskPane.titleBackgroundGradientStart", LIGHT_GRAY);
                UIManager.put("TaskPane.titleBackgroundGradientEnd", VERY_LIGHT_GRAY);
            }
            if (OS.isWindows()) {
                UIManager.put("FileChooserUI", FlatFileChooserUI_FasterIcons.class.getName());
            }
        }
        catch (Exception e) {
            log.error("Could not setup System Look&Feel", (Throwable)e);
        }
        finally {
            INITIALIZED = true;
        }
    }
}

