/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import de.riwagis.util.Config;
import de.riwagis.util.StringSupport;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.GUIException;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Dimension2D;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GUISupport {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");
    private static final Logger LOG = LoggerFactory.getLogger(GUISupport.class);
    private static final Point ZEROPOINT = new Point(0, 0);

    public static Point calcCentreOrigin(Dimension childDimension, Dimension parentDimension, Point parentOrigin) {
        return new Point(Math.max((parentDimension.width - childDimension.width) / 2 + parentOrigin.x, 0), Math.max((parentDimension.height - childDimension.height) / 2 + parentOrigin.y, 0));
    }

    public static File chooseDirectory(Component parentComponent, String title, File prevDirectory) {
        JFileChooser fChoose = new JFileChooser();
        fChoose.setCurrentDirectory(prevDirectory);
        fChoose.setDialogType(1);
        fChoose.setFileSelectionMode(1);
        if (!StringUtils.isBlank((CharSequence)title)) {
            fChoose.setDialogTitle(title);
        }
        fChoose.setAcceptAllFileFilterUsed(false);
        int intReturn = fChoose.showDialog(parentComponent, i18n.get("gui.GuiSupport.selectFolder"));
        if (intReturn == 0) {
            return fChoose.getSelectedFile();
        }
        return null;
    }

    public static void disposeQuietly(Window window) {
        if (window != null) {
            try {
                window.dispose();
            }
            catch (Throwable t) {
                LOG.warn(String.format("Error disposing frame '%s': %s", window.getName(), t.getMessage()), t);
            }
        }
    }

    public static final void setDefaultButton(final JButton defaultButton, int keyEventID) {
        defaultButton.getActionMap().put("ENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                defaultButton.doClick();
            }
        });
        defaultButton.getInputMap(2).put(KeyStroke.getKeyStroke(keyEventID, 0), "ENTER");
    }

    public static Window findParentWindow(Component aThis) {
        Component currComponent;
        for (currComponent = aThis; currComponent != null && !(currComponent instanceof Window); currComponent = currComponent.getParent()) {
        }
        return (Window)currComponent;
    }

    private GUISupport() {
    }

    public static void msgbox(Component parentComponent, String strMessage, String strTitle) {
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                if (parentComponent != null) {
                    parentComponent.requestFocus();
                }
                String strDisplMessage = GUISupport.buildWrappedMessage(strMessage, 150);
                JOptionPane.showMessageDialog(parentComponent, strDisplMessage, strTitle, -1);
            });
        }
        catch (GUIException e) {
            LOG.error(String.format("Error on showing messagebox: %s", e.getMessage()), (Throwable)e);
        }
    }

    public static String buildWrappedMessage(String strMessage, int lineLength) {
        Object strDisplMessage;
        String trimmedMessage = StringUtils.trimToEmpty((String)strMessage);
        boolean msgHasHTML = GUISupport.hasHTMLTag(trimmedMessage);
        if (trimmedMessage.indexOf(10) == -1) {
            strDisplMessage = msgHasHTML ? trimmedMessage : "<html>" + WordUtils.wrap((String)trimmedMessage, (int)lineLength, (String)"<br/>", (boolean)false) + "</html>";
        } else {
            ArrayList<String> lines = new ArrayList<String>();
            for (String strLine : trimmedMessage.split("\\n")) {
                lines.add(WordUtils.wrap((String)strLine, (int)lineLength, (String)"\n", (boolean)false));
            }
            strDisplMessage = StringUtils.join(lines, (String)"\n");
        }
        if (GUISupport.hasHTMLTag((String)strDisplMessage)) {
            return ((String)strDisplMessage).replaceAll("(?s)\\R", "<br/>");
        }
        return ((String)strDisplMessage).replaceAll("(<br>|<br/>)", "\n");
    }

    public static boolean hasHTMLTag(String trimmedMessage) {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)trimmedMessage), (CharSequence)"<html>");
    }

    public static void addKeyListenersRecursively(Component parentComponent, KeyListener keyListener) {
        parentComponent.addKeyListener(keyListener);
        if (parentComponent instanceof Container) {
            Container container = (Container)parentComponent;
            for (Component children1 : container.getComponents()) {
                GUISupport.addKeyListenersRecursively(children1, keyListener);
            }
        }
    }

    public static void toFront(Component component) {
        if (component instanceof Window) {
            Window window = (Window)component;
            window.toFront();
        }
    }

    public static boolean yesnobox(Component parentComponent, String strMessage, String strTitle) {
        boolean[] arrReturn = new boolean[1];
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                GUISupport.toFront(parentComponent);
                int intReturn = JOptionPane.showConfirmDialog(parentComponent, strMessage, strTitle, 0);
                arrReturn[0] = intReturn == 0;
            });
            return arrReturn[0];
        }
        catch (Exception e) {
            LOG.error("Error on showing inputbox", (Throwable)e);
            return false;
        }
    }

    public static boolean okcancelbox(Component parentComponent, String strMessage, String strTitle) {
        boolean[] arrReturn = new boolean[1];
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                GUISupport.toFront(parentComponent);
                int intReturn = JOptionPane.showConfirmDialog(parentComponent, strMessage, strTitle, 2, 2);
                arrReturn[0] = intReturn == 0;
            });
            return arrReturn[0];
        }
        catch (Exception e) {
            LOG.error("Error on showing okcancelbox", (Throwable)e);
            return false;
        }
    }

    public static String inputbox(Component parentComponent, String strMessage) {
        String[] arrReturn = new String[1];
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                String strReturn;
                GUISupport.toFront(parentComponent);
                arrReturn[0] = strReturn = JOptionPane.showInputDialog(parentComponent, strMessage, i18n.get("common.input"), 3);
            });
            return arrReturn[0];
        }
        catch (Exception e) {
            LOG.error("Error on showing inputbox", (Throwable)e);
            return null;
        }
    }

    public static String inputbox(Component parentComponent, String strMessage, String presetText) {
        return GUISupport.inputbox(parentComponent, strMessage, "Eingabe", presetText);
    }

    public static String inputbox(Component parentComponent, String strMessage, String title, String presetText) {
        String[] arrReturn = new String[1];
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                GUISupport.toFront(parentComponent);
                arrReturn[0] = (String)JOptionPane.showInputDialog(parentComponent, strMessage, title, 3, null, null, presetText);
            });
            return arrReturn[0];
        }
        catch (Exception e) {
            LOG.error("Error on showing inputbox", (Throwable)e);
            return null;
        }
    }

    public static Object inputbox(Component parentComponent, String strMessage, Object[] arrOptions) {
        return GUISupport.inputbox(parentComponent, strMessage, arrOptions, null);
    }

    public static Object inputbox(Component parentComponent, String strMessage, Object[] arrOptions, Object selectedOption) {
        Object[] arrReturn = new Object[]{null};
        try {
            GUISupport.executeSyncOnEventThread(() -> {
                GUISupport.toFront(parentComponent);
                arrReturn[0] = JOptionPane.showInputDialog(parentComponent, strMessage, i18n.get("gui.GuiSupport.inputbox-selection-title"), 3, null, arrOptions, selectedOption);
            });
        }
        catch (Exception e) {
            LOG.error("Error on showing inputbox", (Throwable)e);
        }
        return arrReturn[0];
    }

    public static void addCopyPopup(JTextComponent txtComp) {
        JPopupMenu pMenu = new JPopupMenu();
        JMenuItem menuItemCopy = new JMenuItem(i18n.get("common.copy"));
        menuItemCopy.addActionListener(e -> GUISupport.copyToClipboard(txtComp));
        pMenu.add(menuItemCopy);
        txtComp.setComponentPopupMenu(pMenu);
    }

    public static void addCopyInsertPopup(JTextComponent txtComp) {
        JPopupMenu pMenu = new JPopupMenu();
        JMenuItem menuItemCut = new JMenuItem(i18n.get("common.cut"));
        menuItemCut.setEnabled(txtComp.isEditable() && txtComp.isEnabled());
        menuItemCut.addActionListener(e -> {
            if (!txtComp.isEditable() || !txtComp.isEnabled()) {
                return;
            }
            try {
                StringSelection stringSelection = new StringSelection(txtComp.getSelectedText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, (aClipboard, aContents) -> {});
                StringBuilder sb = new StringBuilder(txtComp.getText());
                sb.replace(txtComp.getSelectionStart(), txtComp.getSelectionEnd(), "");
                txtComp.setText(sb.toString());
            }
            catch (Exception exp) {
                LOG.error("Could not cut from clipboard: " + exp.getMessage(), (Throwable)exp);
            }
        });
        pMenu.add(menuItemCut);
        JMenuItem menuItemCopy = new JMenuItem(i18n.get("common.copy"));
        menuItemCopy.addActionListener(e -> GUISupport.copyToClipboard(txtComp));
        pMenu.add(menuItemCopy);
        JMenuItem menuItemPaste = new JMenuItem(i18n.get("common.paste"));
        menuItemPaste.setEnabled(txtComp.isEditable() && txtComp.isEnabled());
        menuItemPaste.addActionListener(e -> {
            if (!txtComp.isEditable() || !txtComp.isEnabled()) {
                return;
            }
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                StringBuilder sb = new StringBuilder(txtComp.getText());
                int intCaretStart = txtComp.getSelectionStart();
                sb.replace(txtComp.getSelectionStart(), txtComp.getSelectionEnd(), s);
                txtComp.setText(sb.toString());
                txtComp.setCaretPosition(intCaretStart + s.length());
            }
            catch (HeadlessException | UnsupportedFlavorException | IOException exp) {
                LOG.error("Could not paste from clipboard: " + exp.getMessage(), (Throwable)exp);
            }
        });
        pMenu.add(menuItemPaste);
        pMenu.addSeparator();
        JMenuItem menuItemClear = new JMenuItem(i18n.get("common.clear"));
        menuItemClear.setEnabled(txtComp.isEditable() && txtComp.isEnabled());
        menuItemClear.addActionListener(e -> {
            if (!txtComp.isEditable() || !txtComp.isEnabled()) {
                return;
            }
            txtComp.setText("");
        });
        pMenu.add(menuItemClear);
        txtComp.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled")) {
                boolean state = txtComp.isEditable() && txtComp.isEnabled();
                menuItemClear.setEnabled(state);
                menuItemCut.setEnabled(state);
                menuItemPaste.setEnabled(state);
            }
        });
        txtComp.setComponentPopupMenu(pMenu);
    }

    private static void copyToClipboard(JTextComponent txtComp) {
        try {
            StringSelection stringSelection = txtComp.getSelectedText() == null || txtComp.getSelectedText().length() == 0 ? new StringSelection(txtComp.getText()) : new StringSelection(txtComp.getSelectedText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, (aClipboard, aContents) -> {});
        }
        catch (Exception exp) {
            LOG.error("Could not copy to clipboard: " + exp.getMessage(), (Throwable)exp);
        }
    }

    @Deprecated
    public static WaitDialog createWaitDialog(Window parentComponent, String strMessage) {
        return WaitDialog.createWaitDialog(parentComponent, strMessage);
    }

    @Deprecated
    public static WaitDialog createWaitDialog(Window parentComponent, String strMessage, Callable<?> workToDo) {
        return WaitDialog.createWaitDialog(parentComponent, strMessage, workToDo);
    }

    @Deprecated
    public static WaitDialog createWaitDialog(Window parentComponent, String strMessage, Runnable workToDo) {
        return WaitDialog.createWaitDialog(parentComponent, strMessage, workToDo);
    }

    public static File[] selectedFiles(JFileChooser chooser) {
        File[] fileArray;
        if (chooser.getSelectedFiles().length == 0 && chooser.getSelectedFile() != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = chooser.getSelectedFile();
        } else {
            fileArray = chooser.getSelectedFiles();
        }
        return fileArray;
    }

    public static JFileChooser createJFileChooser() {
        return GUISupport.createJFileChooser(false);
    }

    public static JFileChooser createJFileChooser(boolean bolOnlyExistingFiles) {
        if (!bolOnlyExistingFiles) {
            return new JFileChooser();
        }
        return new JFileChooser(){

            @Override
            public void approveSelection() {
                if (this.getSelectedFile().exists()) {
                    super.approveSelection();
                } else {
                    JOptionPane.showMessageDialog(this, i18n.get("gui.GuiSupport.file-not-exits"));
                }
            }
        };
    }

    public static JFileChooser createJFileChooserOverwritePrompting() {
        return new JFileChooser(){

            @Override
            public void approveSelection() {
                boolean bolYes;
                if (GUISupport.selectedFiles(this).length != 1) {
                    return;
                }
                File selectedFile = GUISupport.selectedFiles(this)[0];
                if (selectedFile.exists() && !selectedFile.isFile()) {
                    return;
                }
                if (selectedFile.exists() && !(bolYes = GUISupport.yesnobox(this, selectedFile.getName() + " " + i18n.get("gui.GuiSupport.overwrite-file"), i18n.get("common.attention")))) {
                    return;
                }
                super.approveSelection();
            }
        };
    }

    public static FileFilter createFileFilter(final String description, final String ... extensions) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String currExtension : extensions) {
                    if (!FilenameUtils.getExtension((String)f.getName()).equalsIgnoreCase(currExtension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                ArrayList<String> extensionStrings = new ArrayList<String>();
                for (String currExtension : extensions) {
                    extensionStrings.add(String.format("*.%s", currExtension));
                }
                return String.format("%s (%s)", description, StringSupport.toDelimitedString(extensionStrings, (String)";"));
            }
        };
    }

    public static void executeSyncOnEventThread(Runnable task) throws GUIException {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException ex) {
                throw new GUIException(String.format("thread was interrupted: %s", ex.getMessage()), ex);
            }
            catch (InvocationTargetException ex) {
                throw new GUIException(String.format("unable to execute task: %s", ex.getMessage()), ex);
            }
        }
    }

    public static void executeASyncOnEventThread(Runnable task) {
        if (!SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            Thread th = new Thread(task);
            th.start();
        }
    }

    public static final void centreComponent(Component componentToMove, Point parentOrigin, Dimension parentDimension) {
        if (componentToMove != null) {
            Point newOrigin = GUISupport.calcCentreOrigin(componentToMove.getSize(), parentDimension, parentOrigin);
            if (SwingUtilities.isEventDispatchThread()) {
                componentToMove.setLocation(newOrigin);
            } else {
                SwingUtilities.invokeLater(() -> componentToMove.setLocation(newOrigin));
            }
        }
    }

    public static final void centreComponent(Component componentToMove, Component parentComponent) {
        if (parentComponent == null) {
            GUISupport.centreOnScreen(componentToMove);
        } else {
            GUISupport.centreComponent(componentToMove, parentComponent.getLocation(), parentComponent.getSize());
        }
    }

    public static void centreOnScreen(Component componentToMove) {
        GUISupport.centreComponent(componentToMove, ZEROPOINT, Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static File[] chooseFile(Component parentComponent, String dialogTitle, String[] fileSuffixes, File preSelectedFile, boolean multpleFilesAllowed, boolean filesMustExist) {
        FileFilter fFilt = GUISupport.createFileFilter(StringSupport.toDelimitedString((Object[])fileSuffixes, (String)";") + " - File", fileSuffixes);
        return GUISupport.chooseFile(parentComponent, dialogTitle, new FileFilter[]{fFilt}, preSelectedFile, multpleFilesAllowed, filesMustExist);
    }

    public static final File chooseSingleFile(Component parentComponent, String dialogTitle, FileFilter[] fileFilter, File preSelectedFile, boolean filesMustExist) {
        String dlgTitle = (String)StringUtils.defaultIfEmpty((CharSequence)dialogTitle, (CharSequence)i18n.get("gui.GuiSupport.selectSingleFile"));
        File[] selectedFiles = GUISupport.chooseFile(parentComponent, dlgTitle, fileFilter, preSelectedFile, false, filesMustExist);
        return selectedFiles.length > 0 ? selectedFiles[0] : null;
    }

    public static File[] chooseFile(Component parentComponent, String dialogTitle, FileFilter[] fileFilters, File preSelectedFile, boolean multipleFilesAllowed, boolean filesMustExist) {
        LinkedHashSet<File> res = new LinkedHashSet<File>();
        JFileChooser fChoose = GUISupport.createJFileChooser();
        GUISupport.addFileFilter(fChoose, fileFilters);
        GUISupport.preselectFileFilter(fChoose, preSelectedFile);
        fChoose.setDialogTitle((String)StringUtils.defaultIfEmpty((CharSequence)dialogTitle, (CharSequence)i18n.get("gui.GuiSupport.selectMultipleFiles")));
        if (preSelectedFile != null) {
            if (preSelectedFile.isFile()) {
                fChoose.setSelectedFile(preSelectedFile);
            } else if (preSelectedFile.isDirectory()) {
                fChoose.setCurrentDirectory(preSelectedFile);
            } else {
                File parentDir = preSelectedFile.getParentFile();
                if (parentDir != null && parentDir.isDirectory()) {
                    fChoose.setCurrentDirectory(preSelectedFile.getParentFile());
                }
            }
        }
        fChoose.setFileSelectionMode(0);
        fChoose.setMultiSelectionEnabled(multipleFilesAllowed);
        ArrayList<String> nonExistingFiles = new ArrayList<String>();
        do {
            nonExistingFiles.clear();
            if (fChoose.showOpenDialog(parentComponent) == 0) {
                if (multipleFilesAllowed) {
                    Collections.addAll(res, fChoose.getSelectedFiles());
                } else {
                    res.add(fChoose.getSelectedFile());
                }
                if (filesMustExist) {
                    for (File file : res) {
                        if (file.exists()) continue;
                        nonExistingFiles.add(file.getAbsolutePath());
                    }
                }
            }
            if (nonExistingFiles.isEmpty()) continue;
            GUISupport.msgbox(parentComponent, i18n.fmt("gui.GuiSupport.followingFilesNotExists", new Object[]{StringUtils.join(nonExistingFiles, (String)"\n")}), i18n.get("common.error"));
        } while (!nonExistingFiles.isEmpty());
        return (File[])res.toArray(File[]::new);
    }

    public static void preselectFileFilter(JFileChooser fChoose, File preSelectedFile) {
        Collection<FileFilter> selectedFileFilter = GUISupport.findMatchingFileFilter(fChoose, preSelectedFile);
        if (selectedFileFilter != null && !selectedFileFilter.isEmpty()) {
            fChoose.setFileFilter(selectedFileFilter.iterator().next());
        } else {
            FileFilter first = null;
            for (FileFilter currFileFilter : fChoose.getChoosableFileFilters()) {
                if (GUISupport.isAllFileFileFilter(currFileFilter)) continue;
                first = currFileFilter;
                break;
            }
            if (first != null) {
                fChoose.setFileFilter(first);
            }
        }
    }

    public static Collection<FileFilter> findMatchingFileFilter(JFileChooser fChoose, File preSelectedFile) {
        LinkedHashSet<FileFilter> resFFCol = new LinkedHashSet<FileFilter>();
        if (preSelectedFile != null) {
            for (FileFilter currFileFilter : fChoose.getChoosableFileFilters()) {
                if (!currFileFilter.accept(preSelectedFile) || GUISupport.isAllFileFileFilter(currFileFilter)) continue;
                resFFCol.add(currFileFilter);
            }
        }
        return resFFCol;
    }

    public static boolean isAllFileFileFilter(FileFilter currFileFilter) {
        return StringUtils.containsIgnoreCase((CharSequence)currFileFilter.getClass().getName(), (CharSequence)"AllFile");
    }

    public static void addFileFilter(JFileChooser fChoose, FileFilter ... fileFilters) {
        for (FileFilter currFileFilter : fileFilters) {
            fChoose.addChoosableFileFilter(currFileFilter);
        }
    }

    public static File saveFile(Component parentComponent, String strTitle, Collection<FileFilter> fFilt, File preSelect, boolean bolOverwritePrompting) {
        int intReturn;
        JFileChooser fChoose = bolOverwritePrompting ? GUISupport.createJFileChooserOverwritePrompting() : GUISupport.createJFileChooser();
        if (strTitle != null && strTitle.length() > 0) {
            fChoose.setDialogTitle(strTitle);
        }
        if (fFilt != null) {
            for (FileFilter currFilter : fFilt) {
                fChoose.addChoosableFileFilter(currFilter);
            }
        }
        if (preSelect != null) {
            fChoose.setSelectedFile(preSelect);
        }
        if ((intReturn = fChoose.showSaveDialog(parentComponent)) == 1) {
            return null;
        }
        return fChoose.getSelectedFile();
    }

    public static File saveFile(Component parentComponent, String strTitle, String strSuffix, File preSelect, boolean bolOverwritePrompting) {
        List<FileFilter> fFilt = Arrays.asList(GUISupport.createFileFilter(strSuffix + " - File", strSuffix));
        File expFile = GUISupport.saveFile(parentComponent, strTitle, fFilt, preSelect, bolOverwritePrompting);
        if (expFile != null && !expFile.toString().toLowerCase().endsWith("." + strSuffix.toLowerCase())) {
            expFile = new File(expFile.toString() + "." + strSuffix);
        }
        return expFile;
    }

    public static ImageIcon icon(String strIcon) {
        try {
            return new ImageIcon(GUISupport.class.getResource(strIcon));
        }
        catch (Exception e) {
            return new ImageIcon(GUISupport.class.getResource("default.gif"));
        }
    }

    public static Image image(String strImage) {
        try {
            return new ImageIcon(GUISupport.class.getResource(strImage)).getImage();
        }
        catch (Exception e) {
            return new ImageIcon(GUISupport.class.getResource("default.gif")).getImage();
        }
    }

    public static Dimension2D detectDimension(File imageFile) throws IOException {
        return GUISupport.detectDimension(imageFile, 0);
    }

    public static Dimension2D detectDimension(File imageFile, int dim) throws IOException {
        return GUISupport.detectDimensions(imageFile)[dim];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension2D[] detectDimensions(File imageFile) throws IOException {
        Dimension2D[] d = null;
        ImageReader r = null;
        ImageInputStream inStream = null;
        try {
            inStream = ImageIO.createImageInputStream(imageFile);
            inStream.mark();
            Iterator<ImageReader> it = ImageIO.getImageReaders(inStream);
            if (it.hasNext()) {
                r = it.next();
                r.setInput(inStream);
                r.reset();
                try {
                    inStream.reset();
                }
                catch (IOException e) {
                    LOG.warn("error resetting image input", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)inStream);
                    inStream = ImageIO.createImageInputStream(inStream);
                }
                r.setInput(inStream);
            } else {
                LOG.error("Image not readable: " + imageFile);
            }
            if (r != null) {
                int numImages = r.getNumImages(true);
                d = new Dimension2D[numImages];
                for (int i = 0; i < numImages; ++i) {
                    d[i] = new Dimension(r.getWidth(i), r.getHeight(i));
                }
            }
        }
        finally {
            if (r != null) {
                r.dispose();
            }
            IOUtils.closeQuietly((Closeable)inStream);
        }
        return d;
    }

    public static boolean mergeMenu(JMenu topMenu, JMenu subMenu, boolean keepImages) {
        return GUISupport.mergeMenu(topMenu, subMenu, keepImages, false);
    }

    public static void cleanupSeparators(JMenu topMenu) {
        Component component;
        ArrayList<JSeparator> toRemoveList = new ArrayList<JSeparator>();
        for (Component currMenuItem : topMenu.getMenuComponents()) {
            if (!(currMenuItem instanceof JMenu)) continue;
            JMenu jMenu = (JMenu)currMenuItem;
            GUISupport.cleanupSeparators(jMenu);
        }
        for (int i_forward = 0; i_forward < topMenu.getMenuComponentCount() && (component = topMenu.getMenuComponent(i_forward)) instanceof JSeparator; ++i_forward) {
            JSeparator sep = (JSeparator)component;
            toRemoveList.add(sep);
        }
        for (JSeparator currRemoveSeparator : toRemoveList) {
            topMenu.remove(currRemoveSeparator);
        }
        toRemoveList.clear();
        for (int i_backward = topMenu.getMenuComponentCount(); i_backward > 0 && topMenu.getMenuComponent(i_backward - 1) instanceof JSeparator; --i_backward) {
            toRemoveList.add((JSeparator)topMenu.getMenuComponent(i_backward - 1));
        }
        for (JSeparator currRemoveSeparator : toRemoveList) {
            topMenu.remove(currRemoveSeparator);
        }
        toRemoveList.clear();
    }

    public static void removeEmptySubMenus(JMenu topMenu) {
        ArrayList<JMenu> toRemoveList = new ArrayList<JMenu>();
        for (Component currMenuItem : topMenu.getMenuComponents()) {
            if (!(currMenuItem instanceof JMenu)) continue;
            JMenu currSubMenu = (JMenu)currMenuItem;
            GUISupport.removeEmptySubMenus(currSubMenu);
            if (currSubMenu.getMenuComponentCount() != 0) continue;
            toRemoveList.add(currSubMenu);
        }
        for (JMenu currRemoveSubMenu : toRemoveList) {
            topMenu.remove(currRemoveSubMenu);
        }
    }

    public static boolean mergeMenu(JMenu topMenu, JMenu subMenu, boolean keepImages, boolean omitDuplicateMenuItems) {
        boolean bolMenuFound = false;
        for (Component compTree : topMenu.getMenuComponents()) {
            if (bolMenuFound || !(compTree instanceof JMenu)) continue;
            JMenu menTree = (JMenu)compTree;
            if (!StringUtils.equalsIgnoreCase((CharSequence)subMenu.getText(), (CharSequence)menTree.getText())) continue;
            for (Component subMenuComponent : subMenu.getMenuComponents()) {
                if (subMenuComponent instanceof JMenu) {
                    JMenu jMenu = (JMenu)subMenuComponent;
                    GUISupport.mergeMenu(menTree, jMenu, true);
                    continue;
                }
                if (subMenuComponent instanceof JSeparator) {
                    menTree.add(subMenuComponent);
                    continue;
                }
                if (subMenuComponent instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)subMenuComponent;
                    if (omitDuplicateMenuItems && GUISupport.containsMenuItem(menTree, jMenuItem)) continue;
                    menTree.add(subMenuComponent);
                    continue;
                }
                menTree.add(subMenuComponent);
            }
            bolMenuFound = true;
        }
        if (!bolMenuFound) {
            if (keepImages) {
                topMenu.add(subMenu);
            } else {
                JMenu x = new JMenu(subMenu.getText());
                for (Component c : subMenu.getMenuComponents()) {
                    x.add(c);
                }
                topMenu.add(x);
            }
        }
        return bolMenuFound;
    }

    public static boolean containsMenuItem(JMenu currMenu, JMenuItem currItem) {
        boolean res = false;
        for (Component c : currMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)c;
            res |= StringUtils.equals((CharSequence)jMenuItem.getText(), (CharSequence)currItem.getText());
        }
        return res;
    }

    public static boolean promptLocationAndMoveFile(File file) {
        if (!file.exists()) {
            LOG.debug("File {0} is missing. not showing save as dialog.", (Object)file);
            return false;
        }
        JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
        fChoose.setFileFilter(GUISupport.createFileFilter("File", FilenameUtils.getExtension((String)file.getName())));
        int intOption = fChoose.showSaveDialog(null);
        if (intOption == 1) {
            return false;
        }
        File newFile = fChoose.getSelectedFile();
        try {
            FileSupport.moveFile((File)file, (File)newFile);
            return true;
        }
        catch (IOException ex) {
            LOG.error("Could not move file: " + ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

