/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class FontSupport {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    private static Set<String> SYSTEM_FONT_NAMES = null;

    private static Set<String> getAvailableFonts() {
        if (SYSTEM_FONT_NAMES == null) {
            String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            SYSTEM_FONT_NAMES = new LinkedHashSet<String>();
            SYSTEM_FONT_NAMES.addAll(Arrays.asList(fonts));
        }
        return SYSTEM_FONT_NAMES;
    }

    public static boolean isFontAvailable(String fontName) {
        return FontSupport.getAvailableFonts().contains(fontName);
    }

    private FontSupport() {
    }
}

