/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import com.formdev.flatlaf.ui.FlatFileChooserUI;
import com.formdev.flatlaf.util.ScaledImageIcon;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileChooserUI_FasterIcons
extends FlatFileChooserUI {
    private static final Logger log = LoggerFactory.getLogger(FlatFileChooserUI_FasterIcons.class);
    private final CachingFlatFileView fileView = new CachingFlatFileView();

    public static ComponentUI createUI(JComponent c) {
        return new FlatFileChooserUI_FasterIcons((JFileChooser)c);
    }

    public FlatFileChooserUI_FasterIcons(JFileChooser filechooser) {
        super(filechooser);
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private class CachingFlatFileView
    extends BasicFileChooserUI.BasicFileView {
        private CachingFlatFileView() {
            super((BasicFileChooserUI)((Object)FlatFileChooserUI_FasterIcons.this));
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            String extension = this.getExtension(f);
            if (!f.isDirectory() && StringUtils.isNotBlank((CharSequence)extension) && !extension.equalsIgnoreCase("lnk")) {
                File fakeFile = new File("__EXT__" + (extension = extension.toLowerCase()));
                icon = this.getCachedIcon(fakeFile);
                if (icon != null) {
                    return icon;
                }
                icon = FlatFileChooserUI_FasterIcons.this.getFileChooser().getFileSystemView().getSystemIcon(f);
                if (icon != null) {
                    if (icon instanceof ImageIcon) {
                        ImageIcon imageIcon = (ImageIcon)icon;
                        icon = new ScaledImageIcon(imageIcon);
                    }
                    this.cacheIcon(fakeFile, icon);
                    return icon;
                }
            }
            if ((icon = super.getIcon(f)) instanceof ImageIcon) {
                icon = new ScaledImageIcon((ImageIcon)icon);
                this.cacheIcon(f, icon);
            }
            return icon;
        }

        private String getExtension(File f) {
            try {
                return FilenameUtils.getExtension((String)f.getName());
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

