/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import de.riwagis.util.gui.ErrorBox;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.LoggerFactory;

public class ExceptionDialog {
    public static final String ERROR_TITLE = "Fehler";

    public static void handleGuiException(Component parent, Throwable e, String strLoggerName) {
        String message = (String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)e.getClass().getName());
        Window parentWindow = parent == null || parent instanceof Window ? (Window)parent : SwingUtilities.windowForComponent(parent);
        ErrorBox.showException(parentWindow, ERROR_TITLE, WordUtils.wrap((String)e.getMessage(), (int)120), e);
        if (strLoggerName != null) {
            LoggerFactory.getLogger((String)strLoggerName).error(message, e);
        }
    }

    public static void handleGuiException(Component parent, Exception e, Class<?> clazz) {
        if (clazz == null) {
            ExceptionDialog.handleGuiException(parent, (Throwable)e, (String)null);
        } else {
            ExceptionDialog.handleGuiException(parent, (Throwable)e, clazz.getName());
        }
    }
}

