/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui;

import com.ezware.common.Markup;
import com.ezware.common.Strings;
import com.ezware.dialog.task.TaskDialog;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class ErrorBox {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.gui.i18n");

    public static final boolean showError(Window parent, String title, String description, String location, String details) {
        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(description);
        dlg.setText(location);
        dlg.setIcon((Icon)TaskDialog.StandardIcon.ERROR);
        dlg.getDetails().setExpandableComponent((JComponent)new JLabel(Markup.toHTML((String)details)));
        dlg.getDetails().setCollapsedLabel(i18n.get("gui.ErrorBox.show-details"));
        dlg.getDetails().setExpandedLabel(i18n.get("gui.ErrorBox.hide-details"));
        dlg.getDetails().setExpanded(false);
        dlg.getFooter().setText(null);
        dlg.getFooter().setCheckBoxText(null);
        dlg.getFooter().setCheckBoxSelected(false);
        dlg.show();
        return dlg.getResult() == TaskDialog.StandardCommand.OK;
    }

    public static final boolean showException(Window parent, String title, Throwable ex) {
        return ErrorBox.showException(parent, title, "", ex);
    }

    public static final boolean showException(Window parent, String title, String description, Throwable ex) {
        String msg = ex.getMessage();
        String className = ex.getClass().getName();
        boolean noMessage = Strings.isEmpty((String)msg);
        String fm = className + (String)(noMessage ? "" : ": " + WordUtils.abbreviate((String)msg, (int)30, (int)50, (String)"..."));
        String locDesc = StringUtils.isBlank((CharSequence)description) ? i18n.get("gui.ErrorBox.error_occured") : description;
        return ErrorBox.showError(parent, title, locDesc, fm, Strings.stackStraceAsString((Throwable)ex));
    }

    private ErrorBox() {
    }
}

