/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util.print;

import de.riwagis.util.gui.GUISupport;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public enum ExpFileType {
    DOCX("docx", "docx", "DOCX-File", false),
    ODT("odt", "odt", "ODT-File", false),
    JASPER("jasper", "pdf", "JASPER-File", true),
    RTF("rtf", "rtf", "RTF-File", false);

    private final String templateExtension;
    private final String exportExtension;
    private final String description;
    private final FileFilter filt;
    private final boolean determineMultiByReportData;

    private ExpFileType(String templateExtension, String exportExtension, String description, boolean determineMultiByReportData) {
        this.templateExtension = templateExtension;
        this.exportExtension = exportExtension;
        this.description = description;
        this.filt = GUISupport.createFileFilter((String)description, (String[])new String[]{templateExtension});
        this.determineMultiByReportData = determineMultiByReportData;
    }

    public String getTemplateExtension() {
        return this.templateExtension;
    }

    public String getExportExtension() {
        return this.exportExtension;
    }

    public String getDescription() {
        return this.description;
    }

    public FileFilter getFileFilter() {
        return this.filt;
    }

    public boolean isDetermineMultiByReportData() {
        return this.determineMultiByReportData;
    }

    public static FileFilter[] getAllFileFilters() {
        ExpFileType[] arrTypes = ExpFileType.values();
        FileFilter[] arrFilter = new FileFilter[arrTypes.length];
        for (int i = 0; i < arrTypes.length; ++i) {
            arrFilter[i] = arrTypes[i].getFileFilter();
        }
        return arrFilter;
    }

    public static ExpFileType getExpFileType4TemplateFile(File file) {
        String fileName2Check = file.getName().toLowerCase();
        for (ExpFileType type : ExpFileType.values()) {
            if (!FilenameUtils.isExtension((String)fileName2Check, (String)type.getTemplateExtension())) continue;
            return type;
        }
        return null;
    }

    public static ExpFileType getExpFileType4ExportFile(File file) {
        String fileName2Check = file.getName().toLowerCase();
        for (ExpFileType type : ExpFileType.values()) {
            if (!FilenameUtils.isExtension((String)fileName2Check, (String)type.getExportExtension())) continue;
            return type;
        }
        return null;
    }
}

