/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util.print;

import de.riwagis.gis.context.map.ReportFilePersist;
import de.riwagis.gis.context.map.ReportFilePersistException;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPrintSupprtJRLocalDBFilePersist
implements ReportFilePersist {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientPrintSupprtJRLocalDBFilePersist.class);
    public static final List<String> PHOTO_TABLE_COLUMNS = Arrays.asList("moduleKey".toUpperCase(), "dialogKey".toUpperCase(), "fieldKey".toUpperCase(), "filterID".toUpperCase(), "localfilename".toUpperCase());
    private final WebGisContext wgContext;
    private final Collection<File> generatedFiles = new LinkedHashSet<File>();
    private static final String PERSISTED_REPORT_FILE_PREFIX = "persistedReportFile.";
    private static final String PERSISTED_REPORT_FILE_SUFFIX = ".tmp";
    private static final int MAX_KEEP_TIME_HOURS = 4;
    private static final long MAX_KEEP_TIME_MILLIES = 14400000L;
    private static final FileFilter WILDCARD_FILE_FILTER = new WildcardFileFilter("persistedReportFile.*.tmp", IOCase.INSENSITIVE);

    public ClientPrintSupprtJRLocalDBFilePersist(WebGisContext wgContext) {
        this.wgContext = wgContext;
    }

    public Collection<File> persistReportFiles(Connection conn, File tempDir) throws ReportFilePersistException {
        if (!tempDir.isDirectory()) {
            throw new ReportFilePersistException(String.format("temp dir '%s' is not a directory", tempDir));
        }
        ClientPrintSupprtJRLocalDBFilePersist.cleanOldReportFiles(tempDir);
        LinkedHashSet<File> createdFiles = new LinkedHashSet<File>();
        try {
            Collection<String> tablenames = this.detectTablesWithDownloadableContent(conn);
            for (String currTablename : tablenames) {
                Collection<DownloadFieldDefinition> refColl = this.readDownloadFields(conn, currTablename);
                try (PreparedStatement pstmtUpdFile = conn.prepareStatement(String.format("UPDATE %s    SET localfilename=?  WHERE moduleKey=? AND dialogKey=? AND fieldKey=? AND filterID=?", currTablename));
                     PreparedStatement pstmtDelFile = conn.prepareStatement(String.format("DELETE   FROM %s  WHERE moduleKey=? AND dialogKey=? AND fieldKey=? AND filterID=?", currTablename));){
                    for (DownloadFieldDefinition currFieldDef : refColl) {
                        File expFile = this.downloadFileFromServer(currFieldDef, tempDir);
                        if (expFile != null && expFile.exists()) {
                            if (expFile.length() > 0L) {
                                pstmtUpdFile.setString(1, expFile.getAbsolutePath());
                                pstmtUpdFile.setInt(2, currFieldDef.getModuleKey());
                                pstmtUpdFile.setInt(3, currFieldDef.getDialogKey());
                                pstmtUpdFile.setInt(4, currFieldDef.getFieldKey());
                                pstmtUpdFile.setString(5, currFieldDef.getFilterID());
                                pstmtUpdFile.executeUpdate();
                                createdFiles.add(expFile);
                                continue;
                            }
                            expFile.delete();
                            continue;
                        }
                        pstmtDelFile.setInt(1, currFieldDef.getModuleKey());
                        pstmtDelFile.setInt(2, currFieldDef.getDialogKey());
                        pstmtDelFile.setInt(3, currFieldDef.getFieldKey());
                        pstmtDelFile.setString(4, currFieldDef.getFilterID());
                        pstmtDelFile.executeUpdate();
                    }
                }
                conn.commit();
            }
        }
        catch (SQLException sqlex) {
            throw new ReportFilePersistException("unable to query photo tables: " + sqlex.getMessage(), sqlex);
        }
        this.generatedFiles.addAll(createdFiles);
        return createdFiles;
    }

    public Collection<DownloadFieldDefinition> readDownloadFields(Connection conn, String currTablename) throws SQLException {
        LinkedHashSet<DownloadFieldDefinition> refColl = new LinkedHashSet<DownloadFieldDefinition>();
        try (PreparedStatement pstmt = conn.prepareStatement(String.format("SELECT DISTINCT *   FROM %s  WHERE localfilename IS NULL OR localfilename=''", currTablename));
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                DownloadFieldDefinition def = new DownloadFieldDefinition(this, rs.getInt("moduleKey"), rs.getInt("dialogKey"), rs.getInt("fieldKey"), rs.getString("filterID"));
                if (refColl.contains(def)) {
                    log.debug("duplicate download: " + String.valueOf(def));
                    continue;
                }
                refColl.add(def);
            }
        }
        return refColl;
    }

    public File downloadFileFromServer(DownloadFieldDefinition fieldDef, File tempDir) {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
        try {
            File currOutFile;
            try {
                currOutFile = File.createTempFile(PERSISTED_REPORT_FILE_PREFIX, PERSISTED_REPORT_FILE_SUFFIX, tempDir);
            }
            catch (IOException ioex) {
                throw new ServiceException(String.format("unable to create temp file in '%s': %s", tempDir, ioex.getMessage()), (Throwable)ioex);
            }
            String fname = this.checkSavedFile(fieldDef);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", fieldDef.getModuleKey());
            params.put("dialog_key", fieldDef.getDialogKey());
            params.put("field_key", fieldDef.getFieldKey());
            params.put("filter_id", fieldDef.getFilterID());
            ServiceRequest req = dlgFileService.createRequest("get_file", params);
            req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(currOutFile));
            return (File)this.wgContext.getServiceProvider().execRequest(req).getResult();
        }
        catch (ServiceException ex) {
            log.error(String.format("error downloading file from module %s, dialog %s, field %s, id: %s to '%s': %s", fieldDef.getModuleKey(), fieldDef.getDialogKey(), fieldDef.getFieldKey(), fieldDef.getFilterID(), tempDir, ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    public Collection<String> detectTablesWithDownloadableContent(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        Collection<String[]> tablesPotential = ClientPrintSupprtJRLocalDBFilePersist.detectPotentialTables(dbmd);
        Collection<String[]> tablesSanitized = ClientPrintSupprtJRLocalDBFilePersist.verifyPotentialTables(tablesPotential, dbmd);
        Collection tablenames = tablesSanitized.stream().map(a -> a[0]).collect(Collectors.toList());
        return tablenames;
    }

    public String checkSavedFile(DownloadFieldDefinition fieldDef) {
        try {
            WebGisModule wgMod = this.wgContext.getModule(fieldDef.getModuleKey());
            WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(fieldDef.getDialogKey());
            Map<String, ?> mapInfo = wgDlg.getUploadInfo(fieldDef.getFieldKey(), fieldDef.getFilterID());
            boolean bolExists = (Boolean)mapInfo.get("existing_file");
            if (!bolExists) {
                throw new IOException(String.format("file in module %d, dialog %d, field %d, key %s does not exist", fieldDef.getModuleKey(), fieldDef.getDialogKey(), fieldDef.getFieldKey(), fieldDef.getFilterID()));
            }
            return (String)mapInfo.get("filename");
        }
        catch (Exception ex) {
            log.error(String.format("error downloading image name: %s", ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private static Collection<String[]> detectPotentialTables(DatabaseMetaData dbmd) throws SQLException {
        LinkedHashSet<String[]> tablenamesPotential = new LinkedHashSet<String[]>();
        try (ResultSet rsTablename = dbmd.getTables(null, null, "PHOTO%", new String[]{"TABLE"});){
            while (rsTablename.next()) {
                String tableName = rsTablename.getString("TABLE_NAME");
                String tableCatalog = rsTablename.getString("TABLE_CAT");
                String tableSchema = rsTablename.getString("TABLE_SCHEM");
                tablenamesPotential.add(new String[]{tableName, tableCatalog, tableSchema});
            }
        }
        return tablenamesPotential;
    }

    private static Collection<String[]> verifyPotentialTables(Collection<String[]> tablenamesPotential, DatabaseMetaData dbmd) throws SQLException {
        LinkedHashSet<String[]> tablenamesVerified = new LinkedHashSet<String[]>();
        for (String[] currTableDef : tablenamesPotential) {
            ResultSet rsCurrTableCols = dbmd.getColumns(currTableDef[1], currTableDef[2], currTableDef[0], null);
            try {
                LinkedHashSet<String> requiredColumns = new LinkedHashSet<String>(PHOTO_TABLE_COLUMNS);
                while (rsCurrTableCols.next()) {
                    String colName = StringUtils.upperCase((String)rsCurrTableCols.getString("COLUMN_NAME"));
                    requiredColumns.remove(colName);
                }
                if (requiredColumns.isEmpty()) {
                    tablenamesVerified.add(currTableDef);
                    continue;
                }
                log.warn(String.format("photo table '%s' has missing columns: %s", currTableDef[0], requiredColumns));
            }
            finally {
                if (rsCurrTableCols == null) continue;
                rsCurrTableCols.close();
            }
        }
        return tablenamesVerified;
    }

    public static void cleanOldReportFiles(File tempDir) {
        long currTimestamp = System.currentTimeMillis();
        File[] createdFiles = tempDir.listFiles(WILDCARD_FILE_FILTER);
        if (createdFiles != null) {
            for (File currCreatedFile : createdFiles) {
                if (currTimestamp - currCreatedFile.lastModified() <= 14400000L || FileUtils.deleteQuietly((File)currCreatedFile)) continue;
                log.warn(String.format("unable to delete file '%s'", currCreatedFile));
            }
        }
    }

    public void close() throws Exception {
        for (File currGeneratedFile : this.generatedFiles) {
            if (FileUtils.deleteQuietly((File)currGeneratedFile)) continue;
            log.warn(String.format("unable to delete file '%s'", currGeneratedFile));
        }
    }

    public class DownloadFieldDefinition {
        final int moduleKey;
        final int dialogKey;
        final int fieldKey;
        final String filterID;

        @Generated
        public DownloadFieldDefinition(ClientPrintSupprtJRLocalDBFilePersist this$0, int moduleKey, int dialogKey, int fieldKey, String filterID) {
            this.moduleKey = moduleKey;
            this.dialogKey = dialogKey;
            this.fieldKey = fieldKey;
            this.filterID = filterID;
        }

        @Generated
        public int getModuleKey() {
            return this.moduleKey;
        }

        @Generated
        public int getDialogKey() {
            return this.dialogKey;
        }

        @Generated
        public int getFieldKey() {
            return this.fieldKey;
        }

        @Generated
        public String getFilterID() {
            return this.filterID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadFieldDefinition)) {
                return false;
            }
            DownloadFieldDefinition other = (DownloadFieldDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getModuleKey() != other.getModuleKey()) {
                return false;
            }
            if (this.getDialogKey() != other.getDialogKey()) {
                return false;
            }
            if (this.getFieldKey() != other.getFieldKey()) {
                return false;
            }
            String this$filterID = this.getFilterID();
            String other$filterID = other.getFilterID();
            return !(this$filterID == null ? other$filterID != null : !this$filterID.equals(other$filterID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DownloadFieldDefinition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getModuleKey();
            result = result * 59 + this.getDialogKey();
            result = result * 59 + this.getFieldKey();
            String $filterID = this.getFilterID();
            result = result * 59 + ($filterID == null ? 43 : $filterID.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientPrintSupprtJRLocalDBFilePersist.DownloadFieldDefinition(moduleKey=" + this.getModuleKey() + ", dialogKey=" + this.getDialogKey() + ", fieldKey=" + this.getFieldKey() + ", filterID=" + this.getFilterID() + ")";
        }
    }
}

