/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util.print;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.actions.ExpRTFTemplateAction;
import de.riwagis.webgiscli.util.ExpSupport;
import de.riwagis.webgiscli.util.print.ClientPrintExporter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.rtf.RTFTemplate;
import net.sourceforge.rtf.UnsupportedRTFTemplate;
import net.sourceforge.rtf.format.rtfcode.RTFCodeString;
import net.sourceforge.rtf.helper.RTFTemplateBuilder;
import net.sourceforge.rtf.template.velocity.VelocityTemplateEngineImpl;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;

public class ClientPrintSupportRTF
implements ClientPrintExporter {
    private static String getEncodedRTFString(String sourceStr, String charSet) throws UnsupportedEncodingException {
        return URLEncoder.encode(sourceStr, charSet).replaceAll("%", "\\\\'").replaceAll("\\+", " ");
    }

    private static RTFCodeString getRTFCodeString(Object objValue) throws UnsupportedEncodingException {
        return new RTFCodeString(ClientPrintSupportRTF.getEncodedRTFString(ObjectUtils.toString((Object)objValue), "ISO-8859-1"), true);
    }

    private static Map<String, Object> getEncodedRTFMap(Map<String, Object> mapReport) throws UnsupportedEncodingException {
        HashMap<String, Object> mapRtfReport = new HashMap<String, Object>();
        for (String strKey : mapReport.keySet()) {
            Object objValue = mapReport.get(strKey);
            if (objValue instanceof String) {
                mapRtfReport.put(strKey, ClientPrintSupportRTF.getRTFCodeString(objValue));
                continue;
            }
            if (objValue instanceof Collection) {
                Collection lstValue = (Collection)objValue;
                ArrayList<Map<String, Object>> lstNewValue = new ArrayList<Map<String, Object>>();
                for (Object objListValue : lstValue) {
                    if (objListValue instanceof Map) {
                        Map valueMap = (Map)objListValue;
                        lstNewValue.add(ClientPrintSupportRTF.getEncodedRTFMap(valueMap));
                        continue;
                    }
                    if (objListValue instanceof String) {
                        lstNewValue.add((Map<String, Object>)ClientPrintSupportRTF.getRTFCodeString(objListValue));
                        continue;
                    }
                    lstNewValue.add((Map<String, Object>)objListValue);
                }
                mapRtfReport.put(strKey, lstNewValue);
                continue;
            }
            if (objValue == null) {
                mapRtfReport.put(strKey, "");
                continue;
            }
            mapRtfReport.put(strKey, objValue);
        }
        return mapRtfReport;
    }

    @Override
    public File exportFile(Map<String, Object> reportData, File templateFileFinal) throws IOException, SystemException {
        RTFTemplate rtfTemplate = this.getTemplate(templateFileFinal);
        if (rtfTemplate.getTemplateEngine() instanceof VelocityTemplateEngineImpl) {
            Properties p = new Properties();
            p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
            p.setProperty("runtime.log.logsystem.log4j.logger", ExpRTFTemplateAction.class.getName());
            ((VelocityTemplateEngineImpl)rtfTemplate.getTemplateEngine()).getVelocityEngine().init(p);
        }
        File exportFileFin = ExpSupport.getExportFile(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), "export_", ".rtf");
        Map<String, Object> reportDataEncoded = ClientPrintSupportRTF.getEncodedRTFMap(reportData);
        rtfTemplate.setTemplate(templateFileFinal);
        for (String strKey : reportDataEncoded.keySet()) {
            Object objValue = reportDataEncoded.get(strKey);
            rtfTemplate.put(strKey, objValue);
        }
        try {
            rtfTemplate.merge(exportFileFin);
        }
        catch (Exception ex) {
            throw new SystemException(String.format("unable to merge '%s': %s", exportFileFin, ex.getMessage()), (Throwable)ex);
        }
        return exportFileFin;
    }

    public RTFTemplate getTemplate(File templateFileFinal) throws SystemException {
        RTFTemplate rtfTemplate;
        RTFTemplateBuilder builder = RTFTemplateBuilder.newRTFTemplateBuilder();
        try {
            rtfTemplate = builder.newRTFTemplate();
        }
        catch (UnsupportedRTFTemplate ex) {
            throw new SystemException(String.format("error reading template '%s': %s", templateFileFinal, ex.getMessage()), (Throwable)ex);
        }
        return rtfTemplate;
    }

    public static File saveRTFXML(WebGisContext wgContext, ServiceMData dlgService, File templateFileFinal, boolean isODTDOCX) throws ServiceException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (isODTDOCX) {
            parameters.put("reportxmltype", "docx");
        }
        ServiceRequest reqXml = dlgService.createRequest("get_report_xml", parameters);
        File xmlPath = templateFileFinal.getParentFile();
        File exportXmlFileFin = new File(xmlPath, String.format("%s.fields.xml", FilenameUtils.getBaseName((String)templateFileFinal.toString())));
        boolean bolExportXml = FileSupport.canWrite((File)exportXmlFileFin);
        reqXml.setStreamProcessor((StreamProcessor)new FileStreamProcessor(exportXmlFileFin));
        if (bolExportXml) {
            wgContext.getServiceProvider().execRequest(reqXml).getResult();
        }
        return exportXmlFileFin;
    }
}

