/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util.print;

import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.webgiscli.util.ExpSupport;
import de.riwagis.webgiscli.util.print.ClientPrintExporter;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.XDocReport;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ClientPrintSupportOffice
implements ClientPrintExporter {
    private final String extension;
    private final boolean fieldsXMLsavedFromServer;

    public ClientPrintSupportOffice(String extension, boolean fieldsXMLsavedFromServer) {
        this.fieldsXMLsavedFromServer = fieldsXMLsavedFromServer;
        this.extension = extension;
    }

    public static ClientPrintExporter buildExporterDOCX(boolean fieldsXMLsavedFromServer) {
        return new ClientPrintSupportOffice(".docx", fieldsXMLsavedFromServer);
    }

    public static ClientPrintExporter buildExporterODT(boolean fieldsXMLsavedFromServer) {
        return new ClientPrintSupportOffice(".odt", fieldsXMLsavedFromServer);
    }

    @Override
    public File exportFile(Map<String, Object> reportData, File templateFileFinal) throws IOException, SystemException {
        File exportFileFin = ExpSupport.getExportFile(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), "export_", this.extension);
        try {
            ClientPrintSupportOffice.exportFile(templateFileFinal, reportData, exportFileFin, this.fieldsXMLsavedFromServer);
        }
        catch (XDocReportException ex) {
            throw new SystemException(String.format("error exporting report '%s': %s", templateFileFinal, ex.getMessage()), (Throwable)ex);
        }
        return exportFileFin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(File templateFileFinal, Map<String, Object> reportData, File exportFileFin, boolean fieldsXMLsavedFromServer) throws XDocReportException, SystemException, FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(templateFileFinal);
        try {
            String templateEngineKind = TemplateEngineKind.Velocity.name();
            HashMap<String, Object> xdocReportData = new HashMap<String, Object>();
            ClientPrintSupportOffice.createXDocReportData(reportData, xdocReportData);
            FieldsMetadata fieldsMetadata = ClientPrintSupportOffice.buildFieldsMetadata(templateEngineKind, reportData);
            if (!fieldsXMLsavedFromServer) {
                ClientPrintSupportOffice.saveXDocXML(templateFileFinal, fieldsMetadata);
            }
            FileOutputStream out = new FileOutputStream(exportFileFin);
            try {
                XDocReport.generateReport((InputStream)in, (String)templateEngineKind, (FieldsMetadata)fieldsMetadata, xdocReportData, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXDocXML(File templateFileFinal, FieldsMetadata fieldsMetadata) throws SystemException, IOException {
        File xmlPath = templateFileFinal.getParentFile();
        File exportXmlFileFin = new File(xmlPath, String.format("%s.fields.xml", FilenameUtils.getBaseName((String)templateFileFinal.toString())));
        boolean bolExportXml = FileSupport.canWrite((File)exportXmlFileFin);
        if (bolExportXml) {
            FileOutputStream xmlOutStream = new FileOutputStream(exportXmlFileFin);
            try {
                fieldsMetadata.saveXML((OutputStream)xmlOutStream, true);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)xmlOutStream);
            }
        }
    }

    public static FieldsMetadata buildFieldsMetadata(String templateEngineKind, Map<String, Object> reportData) {
        FieldsMetadata fieldsMetadata = new FieldsMetadata();
        ArrayList<String> lstFields = new ArrayList<String>();
        ArrayList<String> lstLists = new ArrayList<String>();
        for (String strKey : reportData.keySet()) {
            Object repObj = reportData.get(strKey);
            if (repObj == null || repObj instanceof String || repObj instanceof String[]) {
                lstFields.add(strKey);
            }
            if (!(repObj instanceof Collection)) continue;
            lstLists.add(strKey);
        }
        Collections.sort(lstFields);
        Collections.sort(lstLists);
        for (String strKey : lstFields) {
            fieldsMetadata.addField(strKey, Boolean.valueOf(false), "", "", Boolean.valueOf(false));
        }
        for (String strKey : lstLists) {
            Collection list = (Collection)reportData.get(strKey);
            ClientPrintSupportOffice.addXDocList(fieldsMetadata, strKey, list);
        }
        return fieldsMetadata;
    }

    private static void addXDocList(FieldsMetadata fieldsMetadata, String strListPrefix, Collection<Map<String, Object>> list) {
        if (!list.isEmpty()) {
            String strFieldKey;
            Map<String, Object> reportData = list.iterator().next();
            TreeSet<String> lstFields = new TreeSet<String>();
            TreeSet<String> lstLists = new TreeSet<String>();
            for (Map.Entry<String, Object> reportDataEntry : reportData.entrySet()) {
                Object repObj = reportDataEntry.getValue();
                if (repObj == null || repObj instanceof String || repObj instanceof String[]) {
                    lstFields.add(reportDataEntry.getKey());
                }
                if (!(repObj instanceof Collection)) continue;
                lstLists.add(reportDataEntry.getKey());
            }
            for (String strKey : lstFields) {
                strFieldKey = ClientPrintSupportOffice.buildFieldKey(strListPrefix, strKey);
                fieldsMetadata.addField(strFieldKey, Boolean.valueOf(true), "", "", Boolean.valueOf(false));
            }
            for (String strKey : lstLists) {
                strFieldKey = ClientPrintSupportOffice.buildFieldKey(strListPrefix, strKey);
                Collection reportDataList = (Collection)reportData.get(strKey);
                ClientPrintSupportOffice.addXDocList(fieldsMetadata, strFieldKey, reportDataList);
            }
        }
    }

    public static String buildFieldKey(String strListPrefix, String strKey) {
        return String.format("%s.%s", strListPrefix, strKey);
    }

    private static void createXDocReportData(Map<String, Object> reportData, Map<String, Object> xdocReportData) {
        for (String strKey : reportData.keySet()) {
            Object obj = reportData.get(strKey);
            if (obj instanceof List) {
                List list = (List)obj;
                ArrayList<HashMap<String, Object>> xdocList = new ArrayList<HashMap<String, Object>>();
                xdocReportData.put(strKey, xdocList);
                for (Object objList : list) {
                    Map innerReportData = (Map)objList;
                    HashMap<String, Object> xdocInnerReportData = new HashMap<String, Object>();
                    ClientPrintSupportOffice.createXDocReportData(innerReportData, xdocInnerReportData);
                    xdocList.add(xdocInnerReportData);
                }
                continue;
            }
            if (obj == null) {
                xdocReportData.put(strKey, "");
                continue;
            }
            xdocReportData.put(strKey, obj);
        }
    }
}

