/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util.print;

import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.webgiscli.util.ExpSupport;
import de.riwagis.webgiscli.util.print.ExpFileType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPrintSupport {
    public static final int DEFAULT_ORIENTATION = 0;
    public static final float DEFAULT_DPI = 150.0f;
    private static final Logger LOG = LoggerFactory.getLogger(ClientPrintSupport.class);
    public static final Collection<Integer> DEFAULT_SCALES = Arrays.asList(250, 500, 1000, 2500, 5000, 10000, 25000, 50000, 100000, 250000, 500000);
    public static final String KEY_REPORT_DATA = "report_data";

    public static File determineExportFile(File expFile) {
        File exportFileFin = expFile == null ? ExpSupport.getExportFile(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), "export_", ".pdf") : ClientPrintSupport.swapExtension(expFile, ExpFileType.JASPER.getExportExtension());
        return exportFileFin;
    }

    public static File swapExtension(File expFile, String extension) {
        if (StringUtils.isBlank((String)extension)) {
            throw new IllegalArgumentException("extension must not be blank.");
        }
        return new File(FilenameUtils.removeExtension((String)expFile.getAbsolutePath()) + "." + extension);
    }

    private ClientPrintSupport() {
    }
}

