/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DangerousPathChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DangerousPathChecker.class);

    public boolean isDangerous(File file) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        file = file.getAbsoluteFile();
        String path = file.getPath();
        log.debug("Checking [" + path + "]");
        if (path.startsWith("//") || path.startsWith("\\\\")) {
            return true;
        }
        String driveLetter = path.substring(0, 1);
        String colon = path.substring(1, 2);
        if (!":".equals(colon)) {
            throw new IllegalArgumentException("Expected 'X:': " + path);
        }
        return this.isNetworkDrive(driveLetter);
    }

    private boolean isNetworkDrive(String driveLetter) {
        List<String> cmd = Arrays.asList("net", "use", driveLetter + ":");
        try {
            Process p = new ProcessBuilder(cmd).redirectErrorStream(true).start();
            p.getOutputStream().close();
            StringBuilder consoleOutput = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    consoleOutput.append(line).append("\r\n");
                }
            }
            int rc = p.waitFor();
            return rc == 0;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to run 'net use' on " + driveLetter, e);
        }
    }
}

