/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.util;

import de.riwagis.webgiscli.WebGisClient;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.FactoryException;

public class ActionSupport {
    private ActionSupport() {
    }

    public static int getProjectEPSG() {
        String crsCode = WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().getCrsCode();
        String crsNumber = crsCode.substring(crsCode.indexOf(58) + 1);
        if (StringUtils.isNumeric((CharSequence)crsNumber)) {
            return Integer.parseInt(crsNumber);
        }
        throw new NumberFormatException(String.format("non parsable crs code: %s", crsCode));
    }

    public static Geometry readWKT(Integer epsg, String wkt) throws ParseException, FactoryException {
        if (wkt != null && epsg != null) {
            GeometryFactory fact = new GeometryFactory(new PrecisionModel(), epsg.intValue());
            WKTReader wktr = new WKTReader(fact);
            Geometry geom = wktr.read(wkt);
            return geom;
        }
        return null;
    }
}

