/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions.config;

import de.riwagis.util.PropertiesSupport;
import de.riwagis.util.win32.Win32Path;
import de.riwagis.util.win32.Win32Utils;
import de.riwagis.webgiscli.WebGisClient;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExeFinder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExeFinder.class);
    public static final String DIRNAME_RIWAEXE = "riwaexe";
    public static final String FNAME_CONFIGINI = "config.ini";
    public static final String FNAME_RIWAINTERFACEEXE = "riwainterface.exe";
    public static final String FNAME_INTERFACEINI = "interface.ini";
    public static final String NAME_COMPANY = "Riwa GmbH";
    public static final String NAME_APPLICATION = "RiwaInterface";
    public static final FileFilter FILEFILTER_INI = FileFilterUtils.suffixFileFilter((String)".ini", (IOCase)IOCase.INSENSITIVE);

    public static File findExe(String moduleKey, File configPath, Properties config) {
        File riwaEXE;
        File configuredExe;
        String configuredExeName;
        File pathLocalAppData = Win32Utils.getFolderPath((Win32Path)Win32Path.CSIDL_LOCAL_APPDATA);
        File riwainterfaceexeINI = new File(new File(new File(pathLocalAppData, NAME_COMPANY), NAME_APPLICATION), FNAME_INTERFACEINI);
        File localEXE = ExeFinder.readExeFromINI(riwainterfaceexeINI, moduleKey);
        if (localEXE != null) {
            return localEXE;
        }
        File pathCommonAppData = Win32Utils.getFolderPath((Win32Path)Win32Path.CSIDL_COMMON_APPDATA);
        File commonEXE = ExeFinder.readExeFromINI(new File(new File(new File(pathCommonAppData, NAME_COMPANY), NAME_APPLICATION), FNAME_INTERFACEINI), moduleKey);
        if (commonEXE != null) {
            return commonEXE;
        }
        if (config != null && StringUtils.isNotBlank((CharSequence)(configuredExeName = config.getProperty("riwainterface_exe", ""))) && (configuredExe = new File(configuredExeName)).isFile()) {
            return configuredExe;
        }
        if (configPath != null && (riwaEXE = new File(configPath, FNAME_RIWAINTERFACEEXE)).isFile()) {
            return riwaEXE;
        }
        File riwaExeDir = new File(WebGisClient.INTERFACE_DIR, DIRNAME_RIWAEXE);
        File riwaExeModuleDir = new File(riwaExeDir, moduleKey);
        File riwaExeModuleEXE = new File(riwaExeModuleDir, FNAME_RIWAINTERFACEEXE);
        if (riwaExeModuleEXE.isFile()) {
            return riwaExeModuleEXE;
        }
        File riwaExeEXE = new File(riwaExeDir, FNAME_RIWAINTERFACEEXE);
        if (riwaExeEXE.isFile()) {
            return riwaExeEXE;
        }
        return null;
    }

    public static File readExeFromINI(File riwainterfaceexeINICommon, String moduleKey) {
        block5: {
            if (riwainterfaceexeINICommon.isFile() && moduleKey != null) {
                try {
                    Properties p = PropertiesSupport.loadProperties((File)riwainterfaceexeINICommon);
                    if (p.containsKey(moduleKey)) {
                        File configuredExe;
                        String configuredExeName = p.getProperty(moduleKey, "");
                        if (StringUtils.isNotBlank((CharSequence)configuredExeName) && (configuredExe = new File(configuredExeName)).isFile()) {
                            return configuredExe;
                        }
                        break block5;
                    }
                    throw new IOException(String.format("configuration for module '%s' not found in '%s'", moduleKey, riwainterfaceexeINICommon));
                }
                catch (IOException ioex) {
                    log.warn(String.format("unable to read file '%s': %s", riwainterfaceexeINICommon, ioex.getMessage()), (Throwable)ioex);
                }
            }
        }
        return null;
    }

    public static void writeUserSelectedEXE(String moduleKey, File riwainterfaceEXE) {
        File interfaceINI = new File(new File(new File(Win32Utils.getFolderPath((Win32Path)Win32Path.CSIDL_LOCAL_APPDATA), NAME_COMPANY), NAME_APPLICATION), FNAME_INTERFACEINI);
        Properties p = new Properties();
        if (interfaceINI.isFile()) {
            try {
                PropertiesSupport.loadProperties((Properties)p, (File)interfaceINI);
            }
            catch (IOException ioex) {
                log.warn(String.format("unable to read file '%s': %s", interfaceINI, ioex.getMessage()), (Throwable)ioex);
            }
        }
        p.setProperty(moduleKey, riwainterfaceEXE.getAbsolutePath());
        try {
            FileUtils.forceMkdir((File)interfaceINI.getParentFile());
            PropertiesSupport.storeProperties((Properties)p, (File)interfaceINI);
        }
        catch (IOException ioex) {
            log.warn(String.format("unable to write file '%s': %s", interfaceINI, ioex.getMessage()), (Throwable)ioex);
        }
    }

    public static File findConfig(String moduleKey) {
        File currEXEModuleCfg;
        File riwaExeDirModule;
        File interfaceINIInstallationPathConfig;
        File interfaceINIInstallationPath = WebGisClient.determineInterfaceINIExe(moduleKey);
        if (interfaceINIInstallationPath != null && (interfaceINIInstallationPathConfig = new File(interfaceINIInstallationPath, FNAME_CONFIGINI)).isFile()) {
            return interfaceINIInstallationPathConfig;
        }
        File x = new File(new File(Win32Utils.getFolderPath((Win32Path)Win32Path.CSIDL_COMMON_APPDATA), NAME_COMPANY), NAME_APPLICATION);
        if (x.isDirectory()) {
            for (File currINIFile : x.listFiles(FILEFILTER_INI)) {
                try {
                    Properties p = PropertiesSupport.loadProperties((File)currINIFile);
                    if (StringUtils.equalsIgnoreCase((CharSequence)p.getProperty("modkey"), (CharSequence)moduleKey)) {
                        return currINIFile;
                    }
                }
                catch (IOException ioex) {
                    log.warn(String.format("unable to read file '%s': %s", currINIFile, ioex.getMessage()), (Throwable)ioex);
                }
            }
        }
        File riwaExeDir = new File(WebGisClient.INTERFACE_DIR, DIRNAME_RIWAEXE);
        if (StringUtils.isNotBlank((CharSequence)moduleKey) && (riwaExeDirModule = new File(riwaExeDir, moduleKey)).exists() && riwaExeDirModule.isDirectory() && (currEXEModuleCfg = new File(riwaExeDirModule, FNAME_CONFIGINI)).isFile()) {
            return currEXEModuleCfg;
        }
        File riwaEXECfg = new File(riwaExeDir, FNAME_CONFIGINI);
        if (riwaEXECfg.isFile()) {
            return riwaEXECfg;
        }
        return null;
    }
}

