/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions.beans;

import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsMigrationFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MigrateDmsContext {
    private final File tempDirDownload;
    private final WaitDialog dlgWait;
    private final List<String> results = new ArrayList<String>();
    private final List<String> allPkValues = new ArrayList<String>();
    private final Collection<MigrateDmsMigrationFile> migratedFiles = new LinkedHashSet<MigrateDmsMigrationFile>();
    private final Collection<MigrateDmsMigrationFile> unmigratedFiles = new LinkedHashSet<MigrateDmsMigrationFile>();
    private final List<String> donePkValue = new ArrayList<String>();
    private final Collection<String> fileInfoPK = new ArrayList<String>();
    private final Collection<String> downloadedFilePK = new ArrayList<String>();
    private final Collection<String> errorPK = new ArrayList<String>();

    public MigrateDmsContext(WaitDialog dlgWait, File tempDirDownload) throws IOException {
        this.dlgWait = Objects.requireNonNull(dlgWait);
        this.tempDirDownload = Objects.requireNonNull(tempDirDownload);
        if (!tempDirDownload.isDirectory()) {
            throw new FileNotFoundException(String.format("not a directory: %s", tempDirDownload));
        }
    }

    public int getDonePkValueCount() {
        return this.donePkValue.size();
    }

    public void addDonePkValue(String currPkValue) {
        this.donePkValue.add(currPkValue);
    }

    public int getAllPkValuesCount() {
        return this.allPkValues.size();
    }

    public void addPkValues(Collection<String> pkValues) {
        this.allPkValues.addAll(pkValues);
    }

    public File getTempDirDownload() {
        return this.tempDirDownload;
    }

    public List<String> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public boolean isCanceled() {
        return this.dlgWait.isCanceled();
    }

    public void addResult(String fmt) {
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            this.results.add(fmt);
        }
    }

    public void setMessage(String fmt) {
        this.dlgWait.setMessage(Objects.toString(fmt, ""));
    }

    public void registerMigratedFile(MigrateDmsMigrationFile currFile) {
        this.migratedFiles.add(Objects.requireNonNull(currFile));
    }

    public void registerUnmigrated(MigrateDmsMigrationFile currFile) {
        this.unmigratedFiles.add(Objects.requireNonNull(currFile));
    }

    public int getUnmigratedCount() {
        return this.unmigratedFiles.size();
    }

    public int getMigratedCount() {
        return this.migratedFiles.size();
    }

    public void addFileInfoPK(String pkValue) {
        if (pkValue != null) {
            this.fileInfoPK.add(pkValue);
        }
    }

    public int getFileInfoAmount() {
        return this.fileInfoPK.size();
    }

    public void addDownloadedFilePK(String pkValue) {
        if (pkValue != null) {
            this.downloadedFilePK.add(pkValue);
        }
    }

    public int getDownloadedFileAmount() {
        return this.downloadedFilePK.size();
    }

    public void addErrorPK(String pkValue) {
        if (pkValue != null) {
            this.errorPK.add(pkValue);
        }
    }

    public int getErrorPKAmount() {
        return this.errorPK.size();
    }
}

