/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.excel.XlsExportSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserChooseExportDialog;
import de.riwagis.webgiscli.module.dialog.gui.DocExportDialog;
import de.riwagis.webgiscli.module.dialog.gui.XlsExportDialog;
import de.riwagis.webgiscli.service.http.streams.ServerFileStream;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.servlet.actions.ExpRTFTemplateAction;
import de.riwagis.webgiscli.servlet.actions.XlsExportServerCapabilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsExportAction
extends AbstractAsyncAction {
    public static final String EXT_XLSX = "xlsx";
    public static final String EXT_XLS = "xls";
    private static final Collection<FileFilter> FILTER_ANYXLS = Arrays.asList(GUISupport.createFileFilter((String)"Excel-Datei", (String[])new String[]{"xls", "xlsx"}));
    private static final Logger LOG = LoggerFactory.getLogger(XlsExportAction.class);
    private static final ExpRTFTemplateAction expRtfAction = new ExpRTFTemplateAction();
    public static final String KEY_FILE = XlsExportAction.class.getName() + "_File";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "XlsExport";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            Window parentWindow = this.getMainWindow();
            Object[] objAction = mapParam.get("action");
            String strAction = ((String[])objAction)[0];
            if (strAction.startsWith("dbparser")) {
                Object[] objDialogId = mapParam.get("dbparserid");
                Object[] objModuleId = mapParam.get("dbparsermodule");
                if (objDialogId == null || objModuleId == null) {
                    throw new Exception("Invalid Parameters");
                }
                int intDlgKey = Integer.parseInt(((String[])objDialogId)[0]);
                int intModKey = Integer.parseInt(((String[])objModuleId)[0]);
                WebGisContext wgContext = this.getWgContext();
                WebGisModule wgMod = wgContext.getModule(intModKey);
                WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(intDlgKey);
                DBParserChooseExportDialog dlgChooseExp = new DBParserChooseExportDialog(parentWindow);
                dlgChooseExp.setLocationRelativeTo(parentWindow);
                dlgChooseExp.setVisible(true);
                if (dlgChooseExp.getExportType() == 1) {
                    XlsExportDialog dlgCsv = new XlsExportDialog(parentWindow, Dialog.ModalityType.APPLICATION_MODAL, wgDlg);
                    dlgCsv.setLocationRelativeTo(parentWindow);
                    dlgCsv.setVisible(true);
                } else if (dlgChooseExp.getExportType() == 2) {
                    DocExportDialog dlgRtf = new DocExportDialog(parentWindow, wgDlg);
                    dlgRtf.setLocationRelativeTo(parentWindow);
                    dlgRtf.setVisible(true);
                    if (dlgRtf.getExportType() > 0) {
                        expRtfAction.executeInternal(mapParam);
                    }
                }
            }
            if (strAction.startsWith("module")) {
                Object[] objModuleId = mapParam.get("module_key");
                if (objModuleId == null) {
                    throw new Exception("Invalid Parameters");
                }
                int intModKey = Integer.parseInt(((String[])objModuleId)[0]);
                WebGisContext wgContext = this.getWgContext();
                XlsExportServerCapabilities caps = XlsExportAction.determineExcelExportCapabilities(wgContext);
                Whiteboard wb = wgContext.getPermWhiteboard();
                WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get("servlet.actions.XlsExportAction.wait"), (Runnable)new Runnable(this){

                    @Override
                    public void run() {
                    }
                });
                Runnable work = () -> {
                    try {
                        String strExpFile = ObjectUtils.toString((Object)wb.getAttribute(KEY_FILE));
                        String defaultExtension = caps.isAllowServerGeneratedExcel() ? (FilenameUtils.getExtension((String)strExpFile).equalsIgnoreCase(EXT_XLS) ? EXT_XLS : EXT_XLSX) : EXT_XLS;
                        File expFile = GUISupport.saveFile((Component)dlgWait, (String)"Excel-Datei speichern", FILTER_ANYXLS, (File)new File(strExpFile), (boolean)true);
                        if (expFile != null) {
                            File effExpFile = FilenameUtils.getExtension((String)expFile.getName()).matches("xls.*") ? expFile : FileSupport.addExtension((File)expFile, (String)defaultExtension);
                            wb.setAttribute(KEY_FILE, (Object)effExpFile.getAbsolutePath());
                            wgContext.writePermWhiteboard();
                            if (caps.isAllowServerGeneratedExcel()) {
                                if (caps.isSupportAsychronGeneration()) {
                                    String streamID = WebGisDialog.startServerExcelFile(wgContext, intModKey, null, null, -1, effExpFile);
                                    ServerFileStream.buildServerFileAsynchronous(wgContext, streamID, (StatusDisplayer)dlgWait, effExpFile);
                                    dlgWait.setMessage(i18n.get("servlet.actions.XlsExportAction.wait"));
                                } else {
                                    WebGisDialog.buildServerExcelFile(wgContext, intModKey, effExpFile);
                                }
                            } else {
                                HashMap<String, Integer> params = new HashMap<String, Integer>();
                                params.put("module_key", intModKey);
                                ServiceMData exportService = ServiceRegistry.getService((String)"export", (int)0);
                                String[][] arrResult = (String[][])wgContext.getServiceProvider().execRequest(exportService.createRequest("get_export_array", params)).getResult();
                                XlsExportSupport.exportStringArray2Excel((String[][])arrResult, (File)effExpFile, (boolean)true);
                            }
                            OSFile.showFile((File)effExpFile, (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                };
                dlgWait.addWorkToDo(work);
                dlgWait.setVisible(true);
                if (dlgWait.getError() != null) {
                    throw dlgWait.getError();
                }
            }
        }
        catch (Exception e) {
            LOG.error("can't export XLS-file", (Throwable)e);
            ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public static final XlsExportServerCapabilities determineExcelExportCapabilities(WebGisContext wgContext) {
        try {
            HashMap params = new HashMap();
            ServiceMData exportService = ServiceRegistry.getService((String)"export", (int)0);
            Map arrResult = (Map)wgContext.getServiceProvider().execRequest(exportService.createRequest("get_export_capabilities", params)).getResult();
            return XlsExportServerCapabilities.buildFromMap(arrResult);
        }
        catch (Throwable t) {
            LOG.error(String.format("Error checking server on servergeneratedExcel: %s", t.getMessage()));
            return new XlsExportServerCapabilities(false, false);
        }
    }
}

