/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceProvider;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserReloginAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(UserReloginAction.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "UserReloginAction";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            ServiceProvider serviceProvider = this.getWgContext().getServiceProvider();
            if (serviceProvider instanceof HttpServiceProvider) {
                Object[] newUser = mapParam.get("newuser");
                Object newUserName = newUser[0];
                LOG.info("Wechsele Benutzer: " + String.valueOf(newUserName));
                serviceProvider.setSubUser((String)newUser[0]);
                serviceProvider.doLogout();
                if (!serviceProvider.doLogin()) {
                    serviceProvider.setSubUser("");
                    serviceProvider.doLogin();
                }
            }
        }
        catch (ServiceException ex) {
            ErrorBox.showException(null, (String)i18n.get("common.error"), (String)WordUtils.wrap((String)ex.getMessage(), (int)120), (Throwable)ex);
            throw new SystemException(String.format("Error switching subuser: %s", ex.getMessage()), (Throwable)ex);
        }
    }
}

