/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShowDialogAction
extends AbstractAsyncAction {
    public static final String DEFAULT_PARAMFILTER = "(dbparser.*|localaction)";

    @Override
    public String getName() {
        return "ShowDialog";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            Object[] objDialogId = mapParam.get("dbparserid");
            Object[] objModuleId = mapParam.get("dbparsermodule");
            if (objDialogId == null || objModuleId == null) {
                throw new Exception("Invalid Parameters");
            }
            int intDlgKey = Integer.parseInt(((String[])objDialogId)[0]);
            int intModKey = Integer.parseInt(((String[])objModuleId)[0]);
            Map<String, String> mapFilter = ShowDialogAction.filterParameters(mapParam, DEFAULT_PARAMFILTER);
            WebGisContext wgContext = this.getWgContext();
            WebGisModule wgMod = wgContext.getModule(intModKey);
            if (wgMod == null) {
                throw new SystemException(String.format("Modul %d des Dialogs %d nicht zugewiesen.", intModKey, intDlgKey));
            }
            WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(intDlgKey);
            Object[] objDialogAction = mapParam.get("dbparseraction");
            if (objDialogAction != null) {
                String strDialogAction = ((String[])objDialogAction)[0];
                if (strDialogAction.startsWith("exec") || strDialogAction.equals("getdataupdate") || strDialogAction.equals("getdatatable")) {
                    wgDlg.setAction(strDialogAction, mapFilter);
                } else if (mapFilter.size() > 0) {
                    wgDlg.setFilter(mapFilter);
                } else {
                    wgDlg.setAction(strDialogAction, null);
                }
            } else if (mapFilter.size() > 0) {
                wgDlg.setFilter(mapFilter);
            }
            if (mapFilter.isEmpty() && objDialogAction == null) {
                wgDlg.show();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public static Map<String, String> filterParameters(Map<String, Object[]> mapParam, String filterRegex) {
        Objects.requireNonNull(mapParam, "parameters must not be null");
        Objects.requireNonNull(filterRegex, "regex must not be null");
        Pattern p = Pattern.compile(filterRegex, 2);
        HashMap<String, String> mapFilter = new HashMap<String, String>();
        for (Map.Entry<String, Object[]> currEntry : mapParam.entrySet()) {
            Object[] objArr;
            String strParam = currEntry.getKey();
            Matcher m = p.matcher(strParam);
            if (m.matches() || !((objArr = currEntry.getValue()) instanceof String[])) continue;
            String[] filterParamArray = (String[])objArr;
            mapFilter.put(strParam, filterParamArray != null && filterParamArray.length > 0 ? filterParamArray[0] : null);
        }
        return mapFilter;
    }
}

