/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.service.http.streams.ServerFileStream;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveServerStreamAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(SaveServerStreamAction.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "SaveServerStream";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strId = ActionParameterUtils.readFirstValueString(mapParam.get("id"), "");
            String extension = ActionParameterUtils.readFirstValueString(mapParam.get("extension"), "");
            String title = ActionParameterUtils.readFirstValueString(mapParam.get("title"), i18n.get("gui.fileexistsdialog.saveAs"));
            String defaultFile = ActionParameterUtils.readFirstValueString(mapParam.get("defaultFile"), "");
            Boolean autoOpen = ActionParameterUtils.readFirstValueBoolean(mapParam.get("open"), false);
            if (null != strId) {
                WebGisContext wgContext = this.getWgContext();
                Whiteboard wb = wgContext.getPermWhiteboard();
                Window parentWindow = this.getMainWindow();
                WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get("servlet.actions.XlsExportAction.wait"), () -> {});
                dlgWait.setVisible(true);
                String keyFileLastSaved = SaveServerStreamAction.class.getName() + "_" + extension + "_File";
                String strExpFile = defaultFile.isBlank() ? ObjectUtils.toString((Object)wb.getAttribute(keyFileLastSaved)) : defaultFile;
                File expFile = null;
                if (extension.contains(":")) {
                    String[] extensions;
                    String description = extension.split(":")[0];
                    List<FileFilter> filter = Arrays.asList(GUISupport.createFileFilter((String)description, (String[])(extensions = extension.split(":")[1].split(","))));
                    expFile = GUISupport.saveFile((Component)parentWindow, (String)title, filter, (File)new File(strExpFile), (boolean)true);
                    if (expFile != null && extensions.length > 0) {
                        boolean matches = false;
                        for (String ext : extensions) {
                            if (matches) continue;
                            matches = FilenameUtils.getExtension((String)expFile.getName()).equalsIgnoreCase(ext);
                        }
                        if (!matches) {
                            expFile = FileSupport.addExtension((File)expFile, (String)extensions[0]);
                        }
                    }
                } else {
                    expFile = GUISupport.saveFile((Component)parentWindow, (String)title, (String)extension, (File)new File(strExpFile), (boolean)true);
                    if (expFile != null) {
                        File file = expFile = FilenameUtils.getExtension((String)expFile.getName()).equalsIgnoreCase(extension) ? expFile : FileSupport.addExtension((File)expFile, (String)extension);
                    }
                }
                if (expFile != null) {
                    wb.setAttribute(keyFileLastSaved, (Object)expFile.getAbsolutePath());
                    wgContext.writePermWhiteboard();
                    ServerFileStream.buildServerFileAsynchronous(wgContext, strId, (StatusDisplayer)dlgWait, expFile);
                    if (autoOpen.booleanValue()) {
                        OSFile.showFile((File)expFile, (boolean)false);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
        }
    }
}

