/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import com.google.gson.Gson;
import de.riwagis.browser.WindowManager;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.AbstractHtmlSPWG;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportFileHandlingAction
extends AbstractAsyncAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportFileHandlingAction.class);
    private static final String CALLBACK_MESSAGING = "callbackMessaging";
    private static final String CALLBACK_URL = "callbackUrl";
    private static final String SERVLETACTIONS_EXP_J_REPORT_ACTIONWAIT = "servlet.actions.ExpJReportAction.wait";
    private static final String ACTION_REPORT_DOWNLOAD = "dbparser_downloadreport";
    private static final String ACTION_SAVEREPORT_SERVERSIDE = "dbparser_savereport_serverside";
    private static final String ACTION_CUSTOMUSE_REPORT = "dbparser_customuse_report";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_LASTSAVEFILE = String.valueOf(ReportFileHandlingAction.class) + "_LastSaveFileDir";
    private static final String HTTP_HEADER_DATASETID = "datasetId";

    @Override
    public String getName() {
        return "ReportFileHandling";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strAction = ReportFileHandlingAction.retrieveParameterString(mapParam, "action");
            WebGisContext wgContext = this.getWgContext();
            String objParameters = ReportFileHandlingAction.retrieveParameterString(mapParam, "parameters");
            String objUrl = ReportFileHandlingAction.retrieveParameterString(mapParam, "url");
            if (StringUtils.isBlank((CharSequence)objParameters) || StringUtils.isBlank((CharSequence)objUrl)) {
                throw new IllegalArgumentException("Parameters are not allowed to be null");
            }
            switch (strAction) {
                case "dbparser_downloadreport": {
                    this.doSaveReportClientside(mapParam, wgContext, objParameters, objUrl);
                    break;
                }
                case "dbparser_savereport_serverside": {
                    this.doSaveReportServerside(mapParam, wgContext, objParameters, objUrl);
                    break;
                }
                case "dbparser_customuse_report": {
                    this.doCreateReport4CustomUse(mapParam, wgContext, objParameters, objUrl);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown file action '" + strAction + "'");
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private void doSaveReportServerside(Map<String, Object[]> mapParam, WebGisContext wgContext, String objParameters, String objUrl) {
        String paramCallbackUrl = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_URL);
        String paramCallbackMessaging = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_MESSAGING);
        Boolean paramShowReport = Boolean.parseBoolean(ReportFileHandlingAction.retrieveParameterString(mapParam, "showreport"));
        Window parentWindow = this.getMainWindow();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get(SERVLETACTIONS_EXP_J_REPORT_ACTIONWAIT));
        Runnable work = () -> {
            try {
                CloseableHttpResponse response = this.downloadFile(wgContext, objUrl, objParameters);
                this.handleResponseStatus(response);
                String resultFileName = this.extractFileName((HttpResponse)response);
                Integer datasetId = this.extractDatasetId((HttpResponse)response);
                File expFile = this.extractFile(response, resultFileName);
                if (expFile != null && paramShowReport.booleanValue()) {
                    this.showReport(expFile);
                } else {
                    FileUtils.deleteQuietly((File)expFile);
                }
                this.executeCallback(paramCallbackUrl, paramCallbackMessaging, new File(resultFileName), datasetId);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setCancelable(false);
        dlgWait.setLocationRelativeTo((Component)parentWindow);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parentWindow, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void doCreateReport4CustomUse(Map<String, Object[]> mapParam, WebGisContext wgContext, String objParameters, String objUrl) {
        String paramCallbackUrl = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_URL);
        String paramCallbackMessaging = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_MESSAGING);
        Window parentWindow = this.getMainWindow();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get(SERVLETACTIONS_EXP_J_REPORT_ACTIONWAIT));
        Runnable work = () -> {
            try {
                CloseableHttpResponse response = this.downloadFile(wgContext, objUrl, objParameters);
                this.handleResponseStatus(response);
                this.executeCallback(paramCallbackUrl, paramCallbackMessaging);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setCancelable(false);
        dlgWait.setLocationRelativeTo((Component)parentWindow);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parentWindow, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void doSaveReportClientside(Map<String, Object[]> mapParam, WebGisContext wgContext, String objParameters, String objUrl) {
        String paramFileName = ReportFileHandlingAction.retrieveParameterString(mapParam, "filename");
        String paramFilePath = ReportFileHandlingAction.retrieveParameterString(mapParam, "filepath");
        String paramCallbackUrl = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_URL);
        String paramCallbackMessaging = ReportFileHandlingAction.retrieveParameterString(mapParam, CALLBACK_MESSAGING);
        Boolean paramShowReport = Boolean.parseBoolean(ReportFileHandlingAction.retrieveParameterString(mapParam, "showreport"));
        Window parentWindow = this.getMainWindow();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get(SERVLETACTIONS_EXP_J_REPORT_ACTIONWAIT));
        Runnable work = () -> {
            try {
                CloseableHttpResponse response = this.downloadFile(wgContext, objUrl, objParameters);
                this.handleResponseStatus(response);
                String downloadFileName = this.extractFileName((HttpResponse)response);
                String resultFileName = this.getReportResultFileName(downloadFileName, paramFileName);
                File fileSaved = this.saveFile(response, resultFileName, paramFilePath);
                if (fileSaved != null) {
                    if (paramShowReport.booleanValue()) {
                        this.showReport(fileSaved);
                    }
                    this.executeCallback(paramCallbackUrl, paramCallbackMessaging, fileSaved);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setCancelable(false);
        dlgWait.setLocationRelativeTo((Component)parentWindow);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parentWindow, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void handleResponseStatus(CloseableHttpResponse response) throws IOException, SystemException {
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            String strError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SystemException(strError);
        }
    }

    private CloseableHttpResponse downloadFile(WebGisContext wgContext, String url, String parameters) throws SystemException {
        HttpServiceProvider provider = (HttpServiceProvider)wgContext.getServiceProvider();
        HttpPost downloadFile = new HttpPost(String.format("%s%s", provider.getURL(), url));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).addTextBody("customMethodParameters", parameters, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
        downloadFile.setEntity(builder.build());
        return provider.execMethod((HttpUriRequest)downloadFile);
    }

    private File saveFile(CloseableHttpResponse response, String filename, String directory) throws IOException {
        File newFile;
        Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
        File expFile = this.extractFile(response, filename);
        if (StringUtils.isBlank((CharSequence)directory)) {
            JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
            fChoose.setDialogTitle(i18n.get("module.gui.FileLinkDialog.titleDownload"));
            fChoose.setApproveButtonText(i18n.get("common.save"));
            File lastSaveFileDir = new File(wb.getAttribute(KEY_LASTSAVEFILE, (Object)"").toString());
            FileFilter ff = GUISupport.createFileFilter((String)"File", (String[])new String[]{FilenameUtils.getExtension((String)expFile.toString())});
            fChoose.setFileFilter(ff);
            File preSelFile = lastSaveFileDir;
            if (!preSelFile.isDirectory()) {
                preSelFile = preSelFile.getParentFile();
            }
            fChoose.setSelectedFile(new File(preSelFile, filename));
            int intOption = fChoose.showSaveDialog(null);
            if (intOption == 1) {
                return null;
            }
            newFile = fChoose.getSelectedFile();
        } else {
            File dir = new File(directory);
            dir.mkdirs();
            newFile = new File(dir, filename);
        }
        try {
            FileSupport.moveFile((File)expFile, (File)newFile);
        }
        catch (Exception e1) {
            log.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        wb.setAttribute(KEY_LASTSAVEFILE, (Object)newFile.getParent());
        return newFile;
    }

    private File getExportFile(String strName, int intCount) {
        File expFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), (String)(intCount == 0 ? "" : intCount + "_") + strName);
        if (expFile.exists()) {
            return this.getExportFile(strName, intCount + 1);
        }
        return expFile;
    }

    private File extractFile(CloseableHttpResponse response, String fileName) throws IOException {
        File selectedFile = this.getExportFile(fileName, 0);
        FileStreamProcessor fproc = new FileStreamProcessor(selectedFile);
        return (File)fproc.processStream(response.getEntity().getContent());
    }

    private Integer extractDatasetId(HttpResponse response) {
        Header[] headers = response.getHeaders(HTTP_HEADER_DATASETID);
        if (headers.length > 0) {
            try {
                return Integer.parseInt(headers[0].getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractFileName(HttpResponse response) {
        Pattern p;
        Matcher m;
        Header[] headers = response.getHeaders("Content-Disposition");
        if (headers.length > 0 && (m = (p = Pattern.compile(".*filename=\"(.*)\"")).matcher(headers[0].getValue())).matches()) {
            return m.group(1);
        }
        return "";
    }

    private String getReportResultFileName(String downloadFileName, String paramExpFile) {
        if (StringUtils.isNotBlank((CharSequence)downloadFileName) && downloadFileName.endsWith(".zip")) {
            if (StringUtils.isNotBlank((CharSequence)paramExpFile)) {
                return String.format("%s.zip", FilenameUtils.removeExtension((String)paramExpFile));
            }
            return "export.zip";
        }
        if (StringUtils.isNotBlank((CharSequence)paramExpFile)) {
            return paramExpFile;
        }
        return downloadFileName;
    }

    private void showReport(File file) {
        OSFile.showFile((File)file, (boolean)false);
    }

    private void executeCallback(String callbackUrl, String callbackMessaging, File exportFile) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            this.executeUrlCallback(callbackUrl, exportFile.getCanonicalPath(), null);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callbackMessaging})) {
            this.executeMessagingCallback(callbackMessaging, exportFile.getCanonicalPath(), null);
        }
    }

    private void executeCallback(String callbackUrl, String callbackMessaging) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            this.executeUrlCallback(callbackUrl, null, null);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callbackMessaging})) {
            this.executeMessagingCallback(callbackMessaging, null, null);
        }
    }

    private void executeCallback(String callbackUrl, String callbackMessaging, File exportFile, Integer datasetId) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            this.executeUrlCallback(callbackUrl, exportFile.getName(), datasetId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callbackMessaging})) {
            this.executeMessagingCallback(callbackMessaging, exportFile.getName(), datasetId);
        }
    }

    private void executeUrlCallback(String callbackUrl, String fileName, Integer datasetId) throws IOException {
        if (fileName == null && datasetId == null) {
            WindowManager.getInstance().callServer(callbackUrl);
        } else {
            String strLink = callbackUrl.indexOf(63) > -1 ? "&" : "?";
            String dataSetIdParam = datasetId != null ? String.format("&datasetid=%d", datasetId) : "";
            WindowManager.getInstance().callServer(String.format("%s%sexpfile=%s%s", callbackUrl, strLink, URLEncoder.encode(fileName, StandardCharsets.UTF_8), dataSetIdParam));
        }
    }

    private void executeMessagingCallback(String callbackMessaging, String exportFile, Integer datasetId) throws SystemException {
        try {
            Gson gson = new Gson();
            MessagingCallbackParams messagingParams = (MessagingCallbackParams)gson.fromJson(callbackMessaging, MessagingCallbackParams.class);
            WebGisModule wgMod = this.getWgContext().getModule(messagingParams.getModuleKey());
            DialogContext wgDlg = wgMod.getDialog(messagingParams.getDialogId());
            if (!(wgDlg instanceof AbstractHtmlSPWG)) {
                throw new SystemException("Only HtmlSPWG Dialogs are supported for messaging callback!");
            }
            ArrayList<Object> params = new ArrayList<Object>();
            LinkedHashMap<String, Object> reportResult = new LinkedHashMap<String, Object>();
            reportResult.put("expfile", exportFile);
            reportResult.put("datasetid", datasetId);
            params.add(reportResult);
            if (messagingParams.getParams() != null) {
                params.add(messagingParams.getParams());
            }
            SPMessage message = new SPMessage(messagingParams.getDialogId().toString(), messagingParams.getFunction2Call(), gson.toJson(params));
            AbstractHtmlSPWG dialog = (AbstractHtmlSPWG)wgDlg;
            dialog.show();
            dialog.sendMessage(message);
        }
        catch (Exception ex) {
            throw new SystemException(String.format("Messaging callback was erroneous: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private class MessagingCallbackParams {
        Integer moduleKey;
        Integer dialogId;
        String function2Call;
        Object params;

        @Generated
        public MessagingCallbackParams(ReportFileHandlingAction reportFileHandlingAction) {
        }

        @Generated
        public Integer getModuleKey() {
            return this.moduleKey;
        }

        @Generated
        public Integer getDialogId() {
            return this.dialogId;
        }

        @Generated
        public String getFunction2Call() {
            return this.function2Call;
        }

        @Generated
        public Object getParams() {
            return this.params;
        }

        @Generated
        public void setModuleKey(Integer moduleKey) {
            this.moduleKey = moduleKey;
        }

        @Generated
        public void setDialogId(Integer dialogId) {
            this.dialogId = dialogId;
        }

        @Generated
        public void setFunction2Call(String function2Call) {
            this.function2Call = function2Call;
        }

        @Generated
        public void setParams(Object params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessagingCallbackParams)) {
                return false;
            }
            MessagingCallbackParams other = (MessagingCallbackParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$moduleKey = this.getModuleKey();
            Integer other$moduleKey = other.getModuleKey();
            if (this$moduleKey == null ? other$moduleKey != null : !((Object)this$moduleKey).equals(other$moduleKey)) {
                return false;
            }
            Integer this$dialogId = this.getDialogId();
            Integer other$dialogId = other.getDialogId();
            if (this$dialogId == null ? other$dialogId != null : !((Object)this$dialogId).equals(other$dialogId)) {
                return false;
            }
            String this$function2Call = this.getFunction2Call();
            String other$function2Call = other.getFunction2Call();
            if (this$function2Call == null ? other$function2Call != null : !this$function2Call.equals(other$function2Call)) {
                return false;
            }
            Object this$params = this.getParams();
            Object other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MessagingCallbackParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $moduleKey = this.getModuleKey();
            result = result * 59 + ($moduleKey == null ? 43 : ((Object)$moduleKey).hashCode());
            Integer $dialogId = this.getDialogId();
            result = result * 59 + ($dialogId == null ? 43 : ((Object)$dialogId).hashCode());
            String $function2Call = this.getFunction2Call();
            result = result * 59 + ($function2Call == null ? 43 : $function2Call.hashCode());
            Object $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReportFileHandlingAction.MessagingCallbackParams(moduleKey=" + this.getModuleKey() + ", dialogId=" + this.getDialogId() + ", function2Call=" + this.getFunction2Call() + ", params=" + String.valueOf(this.getParams()) + ")";
        }
    }
}

