/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoConcurrentActionLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoConcurrentActionLock.class);
    private final Semaphore semaphore = new Semaphore(1);

    NoConcurrentActionLock() {
    }

    public <T extends Throwable> void execute(ThrowingAction<T> action) throws T {
        if (!this.semaphore.tryAcquire()) {
            log.info("Could not invoke async action since there is already an invocation running.");
            return;
        }
        try {
            action.run();
        }
        finally {
            this.semaphore.release();
        }
    }

    public static interface ThrowingAction<T extends Throwable> {
        public void run() throws T;
    }
}

