/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import com.ezware.dialog.task.TaskDialog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.gis.context.map.selection.GuidedSelection;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.gis.context.module.quickinfo.QuickInfoList;
import de.riwagis.service.ServiceException;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.dms.DmsResponse;
import de.riwagis.webgiscli.dms.DmsService;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.bsh.BshMenuRuntime;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import de.riwagis.webgiscli.quickinfo.JacksonQuickInfoResponseMapper;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.servlet.actions.DialogShowCondition;
import de.riwagis.webgiscli.servlet.actions.FileOnServerAction;
import de.riwagis.webgiscli.servlet.actions.InterfaceGuidedSelection;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsContext;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsMasterDialogParam;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsMigrationFile;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsProcessDefinition;
import de.riwagis.webgiscli.servlet.actions.beans.MigrateDmsUploadFieldDefinition;
import de.riwagis.webgiscli.servlet.actions.config.ExeFinder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceAction
extends AbstractAsyncAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InterfaceAction.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final JacksonQuickInfoResponseMapper quickInfoResponseMapper;
    private final ObjectMapper dmsMapper = new ObjectMapper();
    private final TypeReference<HashMap<String, String>> dmsMetadataTypeReference = new TypeReference<HashMap<String, String>>(this){};
    private static final Collection<FieldFileStorageType> DMSTRANSFERABLE_STORAGE_TYPES = List.of(FieldFileStorageType.UT_LOCAL, FieldFileStorageType.UT_SERVER);

    public InterfaceAction() {
        this.quickInfoResponseMapper = new JacksonQuickInfoResponseMapper();
    }

    @Override
    public String getName() {
        return "Interface";
    }

    @Override
    public String execute(Map<String, Object[]> mapParam) {
        try {
            String strAction = InterfaceAction.retrieveParameterString(mapParam, "action");
            if (StringUtils.equals((CharSequence)strAction, (CharSequence)"getClientID")) {
                return this.getWgContext().getWebGisClient().getClientID().toString();
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"transferFileToDMS", (CharSequence[])new CharSequence[]{strAction})) {
                return this.dmsMigrateFile(mapParam);
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"transferProcessesToDMS", (CharSequence[])new CharSequence[]{strAction})) {
                return this.dmsTransferProcessesToDMS(mapParam);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            log.error("Error executing action", (Throwable)e);
        }
        return super.execute(mapParam);
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strAction = InterfaceAction.retrieveParameterString(mapParam, "action");
            log.debug("Interface Action: {}", (Object)strAction);
            if (strAction.startsWith("writefile")) {
                InterfaceAction.writeFileAction(mapParam);
            } else if (strAction.equals("actionWithSelection")) {
                String intAction = ActionParameterUtils.readFirstValueString(mapParam.get("intaction"), "");
                Integer dialogId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dbparserid"), null);
                Integer moduleId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dbparsermodule"), null);
                boolean currentItemOnly = 1 == ActionParameterUtils.readFirstValueInteger(mapParam.get("selection"), 2);
                this.externalActionWithSelection(intAction, currentItemOnly, dialogId, moduleId);
            } else if (strAction.equals("action")) {
                String intAction = ActionParameterUtils.readFirstValueString(mapParam.get("intaction"), "");
                String rawParameters = ActionParameterUtils.readFirstValueString(mapParam.get("parameters"), "");
                Map<String, String> parameters = this.splitParametersToMap(rawParameters);
                this.externalAction(intAction, parameters);
            } else if (strAction.equals("requestSelection")) {
                String displayMessage = ActionParameterUtils.readFirstValueString(mapParam.get("msg"), null);
                String displayTitle = ActionParameterUtils.readFirstValueString(mapParam.get("title"), null);
                String okAction = ActionParameterUtils.readFirstValueString(mapParam.get("ok-action"), null);
                String cancelAction = ActionParameterUtils.readFirstValueString(mapParam.get("cancel-action"), null);
                if (StringUtils.isBlank((CharSequence)okAction)) {
                    throw new IllegalStateException("Selection Request requires an interface action");
                }
                WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().startGuidedSelection((GuidedSelection)new InterfaceGuidedSelection(okAction, cancelAction, displayMessage, displayTitle));
            } else if (strAction.equals("supplyQuickInfos")) {
                String jsonData = ActionParameterUtils.readFirstValueString(mapParam.get("data"), "");
                QuickInfoList quickInfoList = this.quickInfoResponseMapper.mapJSONToList(jsonData);
                SwingUtilities.invokeLater(() -> WebGisClient.GIS_CONTEXT.getModuleApp().consumeQuickInfos(quickInfoList));
            } else if (strAction.equals("dmsCreateProcess")) {
                this.dmsCreateProcess(mapParam);
            } else if (strAction.equals("dmsShowProcess")) {
                this.dmsShowProcess(mapParam);
            } else if (strAction.equals("dmsResponse")) {
                String jsonData = ActionParameterUtils.readFirstValueString(mapParam.get("data"), "");
                DmsResponse dmsResponse = (DmsResponse)this.dmsMapper.readValue(jsonData, DmsResponse.class);
                this.getWgContext().getDmsService().consumeResponse(dmsResponse);
            } else if (strAction.equals("executeBeanShell")) {
                Integer moduleKey = ActionParameterUtils.readFirstValueInteger(mapParam.get("moduleKey"), null);
                String command = ActionParameterUtils.readFirstValueString(mapParam.get("command"), null);
                WaitDialog waitDialog = new WaitDialog((Window)WebGisContext.getWebGisClientFrame(), i18n.get("common.wait"));
                waitDialog.addWorkToDo(() -> {
                    try {
                        BshMenuRuntime.getInstance(command, this.getWgContext(), moduleKey).onClick();
                    }
                    catch (Exception e) {
                        waitDialog.setError(e);
                    }
                });
                waitDialog.setVisible(true);
            } else {
                log.warn("Called unknown interface action '{}'", (Object)strAction);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private String dmsMigrateFile(Map<String, Object[]> mapParam) throws Exception {
        String rawPkValue = ActionParameterUtils.readFirstValueString(mapParam.get("pkValue"), null);
        int moduleKey = ActionParameterUtils.readFirstValueInteger(mapParam.get("moduleKey"), null);
        Integer dialogId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dialogId"), null);
        Integer fileUploadId = ActionParameterUtils.readFirstValueInteger(mapParam.get("fileUploadId"), null);
        Integer dmsServiceId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dmsServiceId"), null);
        Integer targetFileUploadId = Objects.requireNonNullElse(ActionParameterUtils.readFirstValueInteger(mapParam.get("targetFileUploadId"), null), fileUploadId);
        List<String> pkValues = InterfaceAction.readPKValues(this.dmsMapper, rawPkValue);
        MigrateDmsMasterDialogParam mg = new MigrateDmsMasterDialogParam();
        mg.setModuleKey(moduleKey);
        mg.setMasterDialogId(null);
        mg.setDmsServiceId(dmsServiceId);
        MigrateDmsProcessDefinition currProc = new MigrateDmsProcessDefinition();
        currProc.setPkValueProcess(null);
        MigrateDmsUploadFieldDefinition uplFieldDef = new MigrateDmsUploadFieldDefinition();
        uplFieldDef.setDetailDialogId(dialogId);
        uplFieldDef.setUploadId(fileUploadId);
        uplFieldDef.setTargetFileUploadId(targetFileUploadId);
        uplFieldDef.setPkValues(pkValues);
        currProc.setUploads(List.of(uplFieldDef));
        List<MigrateDmsProcessDefinition> processes = List.of(currProc);
        mg.setProcesses((MigrateDmsProcessDefinition[])processes.toArray(MigrateDmsProcessDefinition[]::new));
        Collection<String> results = this.dmsMigrateFile(mg, DialogShowCondition.ALWAYS);
        return StringUtils.join(results, (String)"\n");
    }

    public Collection<String> dmsMigrateFile(MigrateDmsMasterDialogParam mg, DialogShowCondition showSummaryDialog) throws Exception {
        String waitMessage = i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.wait-create-process");
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getFocusedOrMainWindow(), (String)waitMessage);
        WebGisModule wgMod = this.getWgContext().getModule(mg.getModuleKey());
        File tempDir = FileSupport.createTempDir((String)"rgzdmsmigration.", (String)"");
        MigrateDmsContext migCtx = new MigrateDmsContext(dlgWait, tempDir);
        LinkedHashMap files = new LinkedHashMap();
        dlgWait.addWorkToDo(() -> {
            AtomicBoolean cancelled = new AtomicBoolean(false);
            File downloadDestDir = null;
            ArrayList<MigrateDmsMigrationFile> downloadedFiles = new ArrayList<MigrateDmsMigrationFile>();
            for (MigrateDmsProcessDefinition currProcess : mg.getProcesses()) {
                for (MigrateDmsUploadFieldDefinition currUpload : currProcess.getUploads()) {
                    if (cancelled.get()) continue;
                    List<String> currPkValues = currUpload.getPkValues();
                    if (!files.containsKey(currProcess)) {
                        files.put(currProcess, new ArrayList());
                    }
                    ((Collection)files.get(currProcess)).addAll(this.downloadMigrationFiles(migCtx, currPkValues, wgMod, currUpload));
                    downloadDestDir = InterfaceAction.storeDownloadedFilesToBackupDir(currPkValues, downloadedFiles, files, currProcess, downloadDestDir, migCtx, this.getFocusedOrMainWindow(), cancelled);
                }
            }
            if (!cancelled.get()) {
                for (MigrateDmsProcessDefinition currProcess : mg.getProcesses()) {
                    Collection currFiles = (Collection)files.get(currProcess);
                    if (currFiles.isEmpty()) {
                        if (currProcess.getDmsProcessUUID() == null && currProcess.getPkValueProcess() != null) {
                            DmsService dmsService = WebGisContext.getInstance().getDmsService();
                            dmsService.createProcess(wgMod.getKey(), mg.getDmsServiceId(), currProcess.getPkValueProcess(), null, null, null).join();
                            migCtx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_process_created", new Object[]{currProcess.getPkValueProcess()}));
                            log.debug("process created for id {}", currProcess.getPkValueProcess());
                            continue;
                        }
                        log.debug("process not created for id {}: already existant", currProcess.getPkValueProcess());
                        continue;
                    }
                    this.migrateFilesToDMS(currProcess, (Collection)files.get(currProcess), wgMod, migCtx);
                }
            }
            if (showSummaryDialog.isToBeShown(() -> migCtx.getMigratedCount() > 0)) {
                this.showSummaryDialog((Window)dlgWait, migCtx, downloadedFiles, downloadDestDir);
            }
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.getFocusedOrMainWindow(), (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
        dlgWait.dispose();
        return migCtx.getResults();
    }

    public static File storeDownloadedFilesToBackupDir(List<String> currPkValues, Collection<MigrateDmsMigrationFile> downloadedFiles, Map<MigrateDmsProcessDefinition, Collection<MigrateDmsMigrationFile>> files, MigrateDmsProcessDefinition currProcess, File downloadDestDir, MigrateDmsContext migCtx, Window parentWindow, AtomicBoolean cancelled) throws RuntimeException {
        if (!currPkValues.isEmpty()) {
            downloadedFiles.addAll(files.get(currProcess).stream().filter(a -> a.isLocalFileDownloaded()).toList());
            if (!downloadedFiles.isEmpty()) {
                if (downloadDestDir == null) {
                    downloadDestDir = GUISupport.chooseDirectory((Component)parentWindow, (String)i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_select_download_directory"), (File)migCtx.getTempDirDownload());
                    cancelled.set(downloadDestDir == null);
                }
                if (downloadDestDir == null) {
                    FileUtils.deleteQuietly((File)migCtx.getTempDirDownload());
                    JOptionPane.showMessageDialog(parentWindow, i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_no_backup_directory_select"), i18n.get("common.error"), 0);
                } else if (!Objects.equals(downloadDestDir, migCtx.getTempDirDownload())) {
                    for (MigrateDmsMigrationFile currDownloadFile : downloadedFiles) {
                        try {
                            FileUtils.copyFileToDirectory((File)currDownloadFile.getLocalFile(), (File)downloadDestDir, (boolean)true);
                        }
                        catch (IOException ioex) {
                            throw new RuntimeException(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_file_migrate_move_error", new Object[]{currDownloadFile.getLocalFile(), downloadDestDir, ioex.getMessage()}));
                        }
                    }
                }
            }
        }
        return downloadDestDir;
    }

    public void showSummaryDialog(Window parent, MigrateDmsContext migCtx, Collection<MigrateDmsMigrationFile> downloadedFiles, File downloadDestDir) {
        String dlgTitle = i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_title");
        String erronousFiles = migCtx.getErrorPKAmount() > 0 ? i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_text_error", new Object[]{migCtx.getErrorPKAmount()}) : "";
        String dlgTxt = !downloadedFiles.isEmpty() && downloadDestDir != null ? i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_text", new Object[]{migCtx.getMigratedCount(), migCtx.getUnmigratedCount(), migCtx.getAllPkValuesCount(), downloadDestDir.getAbsolutePath(), downloadedFiles.size(), erronousFiles}) : i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_text_withoutdownload", new Object[]{migCtx.getMigratedCount(), migCtx.getUnmigratedCount(), migCtx.getAllPkValuesCount(), erronousFiles});
        TaskDialog dlg = new TaskDialog(parent, dlgTitle);
        dlg.setInstruction(dlgTxt);
        dlg.setText("");
        dlg.setIcon((Icon)TaskDialog.StandardIcon.INFO);
        dlg.setCommands(new TaskDialog.Command[]{TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey((String)"Close"))});
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setText(StringUtils.join(migCtx.getResults(), (String)"\n"));
        textArea.setCaretPosition(0);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setPreferredSize(new Dimension(400, 200));
        dlg.getDetails().setExpandableComponent((JComponent)scroller);
        dlg.getDetails().setExpanded(false);
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setResizable(true);
        parent.requestFocusInWindow();
        dlg.show();
    }

    public static File downloadServerFile(WebGisModule wgMod, String fileName, Integer fileUploadId, String currPKValue, File tmpDownloadDir) throws IOException, SystemException {
        File ftmp = File.createTempFile("downloaded.", ".tmp");
        File downFile = wgMod.downloadFromServer(fileUploadId, currPKValue, ftmp);
        File localFile = new File(tmpDownloadDir, fileName);
        FileUtils.moveFile((File)downFile, (File)localFile);
        return localFile;
    }

    public String dmsTransferProcessesToDMS(Map<String, Object[]> mapParam) throws Exception {
        MigrateDmsMasterDialogParam mg = (MigrateDmsMasterDialogParam)this.dmsMapper.readValue((String)mapParam.get("migrateParams")[0], MigrateDmsMasterDialogParam.class);
        Collection<String> results = this.dmsMigrateFile(mg, DialogShowCondition.ALWAYS);
        return StringUtils.join(results, (String)"\n");
    }

    protected void migrateFilesToDMS(MigrateDmsProcessDefinition process, Collection<MigrateDmsMigrationFile> migrationFiles, WebGisModule wgMod, MigrateDmsContext ctx) {
        Integer firstDialogId = null;
        if (!ctx.isCanceled()) {
            try (DMSInterface dMSInterface = FileOnServerAction.createDmsInterface(this.getWgContext());){
                if (dMSInterface == null) {
                    throw new DMSException("no dms interface available");
                }
                for (MigrateDmsMigrationFile currMigrationFile : migrationFiles) {
                    Integer fileUploadId = currMigrationFile.getUploadFieldDef().getUploadId();
                    Integer detailDialogId = currMigrationFile.getUploadFieldDef().getDetailDialogId();
                    if (detailDialogId != null) {
                        firstDialogId = detailDialogId;
                    }
                    if (ctx.isCanceled()) {
                        ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_cancelled", new Object[0]));
                        break;
                    }
                    ctx.setMessage(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_wait_text", new Object[]{ctx.getDonePkValueCount(), ctx.getUnmigratedCount(), ctx.getAllPkValuesCount() - ctx.getUnmigratedCount()}));
                    String fileName = currMigrationFile.getFileName();
                    String currPKValue = currMigrationFile.getPkValue();
                    try {
                        Map<String, Object> currUploadInfo = currMigrationFile.getUploadInfo();
                        FieldFileStorageType currStorageType = currMigrationFile.getStorageType();
                        log.debug("file info: {}", (Object)currMigrationFile);
                        File f = currMigrationFile.getLocalFile();
                        String originKey = FileOnServerAction.computeOriginKey(dMSInterface, wgMod.getKey(), Objects.requireNonNullElse(detailDialogId, 0), fileUploadId);
                        Map<String, String> metaDataDMS = FileOnServerAction.readDMSMetaData(currUploadInfo, "dmsmetadata", "dmsmetadata.parent", "dmsmetadata.static");
                        DMSDocument dmsDocument = dMSInterface.insertToDMS(originKey, f, metaDataDMS, currUploadInfo, wgMod.getKey());
                        log.info("document:  {}  URI: {}", (Object)dmsDocument, (Object)dmsDocument.buildURI());
                        Integer targetFileUploadId = Objects.requireNonNullElse(currMigrationFile.getUploadFieldDef().getTargetFileUploadId(), fileUploadId);
                        if (currStorageType == FieldFileStorageType.UT_SERVER && Objects.equals(targetFileUploadId, fileUploadId)) {
                            try {
                                wgMod.deleteServerDocument(fileUploadId, currPKValue);
                            }
                            catch (ServiceException sex) {
                                log.warn(String.format("unable to delete file from server: %s", sex.getMessage()), (Throwable)sex);
                            }
                        }
                        try {
                            wgMod.updateDMSDocument(targetFileUploadId, currPKValue, dmsDocument);
                        }
                        catch (ServiceException sex) {
                            log.error(String.format("unable to update document: %s", sex.getMessage()), (Throwable)sex);
                            throw new DMSException(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_error_update", new Object[]{sex.getMessage()}), (Throwable)sex);
                        }
                        ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_file_migrated", new Object[]{fileName}));
                        ctx.registerMigratedFile(currMigrationFile);
                        ctx.addDonePkValue(currPKValue);
                    }
                    catch (DMSException dmsex) {
                        log.debug(String.format("error on migrate '%s' to dms: %s", fileName, dmsex.getMessage()), (Throwable)dmsex);
                        ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_error_migrate", new Object[]{fileName, currPKValue, dmsex.getMessage()}));
                        ctx.registerUnmigrated(currMigrationFile);
                        ctx.addErrorPK(currPKValue);
                    }
                }
            }
            catch (DMSException dmsex) {
                log.error(String.format("dms interface failed: %s", dmsex.getMessage()), (Throwable)dmsex);
            }
        }
        try {
            if (!ctx.getResults().isEmpty() && firstDialogId != null) {
                WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(firstDialogId);
                wgDlg.refresh();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not refresh dialog", ex);
        }
    }

    private Collection<MigrateDmsMigrationFile> downloadMigrationFiles(MigrateDmsContext ctx, List<String> pkValues, WebGisModule wgMod, MigrateDmsUploadFieldDefinition currUploadFieldDef) {
        Integer fileUploadId = currUploadFieldDef.getUploadId();
        ArrayList<MigrateDmsMigrationFile> migrationFiles = new ArrayList<MigrateDmsMigrationFile>();
        if (!ctx.isCanceled()) {
            for (String currPKValue : pkValues) {
                if (ctx.isCanceled()) {
                    ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_cancelled", new Object[0]));
                    break;
                }
                ctx.addFileInfoPK(currPKValue);
                ctx.setMessage(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_downloadinfo_text", new Object[]{ctx.getFileInfoAmount()}));
                try {
                    LinkedHashMap<String, Object> currUploadInfo = new LinkedHashMap<String, Object>(Objects.requireNonNullElseGet(wgMod.getUploadInfo(fileUploadId, currPKValue), LinkedHashMap::new));
                    if (!StringUtils.isNotBlank((CharSequence)currUploadInfo.getOrDefault("filename", ""))) continue;
                    MigrateDmsMigrationFile migrationFile = new MigrateDmsMigrationFile(currPKValue, currUploadInfo, currUploadFieldDef);
                    if (DMSTRANSFERABLE_STORAGE_TYPES.contains((Object)migrationFile.getStorageType())) {
                        currUploadInfo.put("fileUploadId", fileUploadId);
                        migrationFiles.add(migrationFile);
                    } else {
                        log.warn("file '{}' for id {} is already into DMS", (Object)migrationFile.getFileName(), (Object)currPKValue);
                        ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_file_already_dms", new Object[]{migrationFile.getFileName()}));
                        ctx.registerUnmigrated(migrationFile);
                    }
                    ctx.addPkValues(Collections.singletonList(currPKValue));
                }
                catch (SystemException sysex) {
                    log.error(String.format("error loading file info: %s", sysex.getMessage()), (Throwable)sysex);
                    ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_error_migrate_short", new Object[]{currPKValue, sysex.getMessage()}));
                }
            }
        }
        if (!ctx.isCanceled()) {
            for (MigrateDmsMigrationFile currMigrationFile : migrationFiles) {
                File f;
                ctx.addDownloadedFilePK(currMigrationFile.getPkValue());
                if (ctx.isCanceled()) {
                    ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_result_cancelled", new Object[0]));
                    break;
                }
                ctx.setMessage(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_downloadfiles_text", new Object[]{ctx.getDownloadedFileAmount()}));
                String fileName = currMigrationFile.getFileName();
                if (!StringUtils.isNotBlank((CharSequence)fileName)) continue;
                FieldFileStorageType currStorageType = currMigrationFile.getStorageType();
                if (currStorageType == FieldFileStorageType.UT_SERVER) {
                    try {
                        f = InterfaceAction.downloadServerFile(wgMod, fileName, fileUploadId, currMigrationFile.getPkValue(), ctx.getTempDirDownload());
                        currMigrationFile.setDownloadedFile(f);
                    }
                    catch (SystemException | IOException ioex) {
                        ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_error_download", new Object[]{ioex.getMessage()}));
                        ctx.addErrorPK(currMigrationFile.getPkValue());
                    }
                    continue;
                }
                if (currStorageType == FieldFileStorageType.UT_LOCAL) {
                    f = new File(StringUtils.removeStart((String)fileName, (String)"file://"));
                    currMigrationFile.setLocalFile(f);
                    continue;
                }
                log.warn("illegal type encountered: " + String.valueOf((Object)currStorageType));
                ctx.addErrorPK(currMigrationFile.getPkValue());
            }
        }
        List<MigrateDmsMigrationFile> removeMigFiles = migrationFiles.stream().filter(currMigFile -> currMigFile.getLocalFile() == null || !currMigFile.getLocalFile().isFile()).toList();
        migrationFiles.removeAll(removeMigFiles);
        removeMigFiles.forEach(currMigFile -> {
            log.debug("no file to transfer for id {}", (Object)currMigFile.getPkValue());
            ctx.addResult(i18n.fmt("de.riwagis.webgiscli.servlet.actions.InterfaceAction.dms_file_not_found", new Object[]{Objects.toString(currMigFile.getFileName(), "")}));
            ctx.addErrorPK(currMigFile.getPkValue());
        });
        return migrationFiles;
    }

    public static List<String> readPKValues(ObjectMapper dmsMapper, String rawPkValue) throws JsonProcessingException {
        return ((List)dmsMapper.readValue(rawPkValue, List.class)).stream().map(a -> a instanceof Number ? ((Number)a).toString() : Objects.toString(a)).filter(a -> a != null).collect(Collectors.toList());
    }

    private void dmsCreateProcess(Map<String, Object[]> mapParam) throws JsonProcessingException {
        Integer dmsServiceId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dmsServiceId"), null);
        String rawPkValue = ActionParameterUtils.readFirstValueString(mapParam.get("pkValue"), null);
        String rawDatatypeId = ActionParameterUtils.readFirstValueString(mapParam.get("datatypeId"), null);
        Integer moduleKey = ActionParameterUtils.readFirstValueInteger(mapParam.get("moduleKey"), null);
        Integer dialogId = ActionParameterUtils.readFirstValueInteger(mapParam.get("dialogId"), null);
        String rawProcessMetadata = ActionParameterUtils.readFirstValueString(mapParam.get("processMetadata"), "{}");
        boolean refresh = ActionParameterUtils.readFirstValueBoolean(mapParam.get("refresh"), true);
        Object pkValue = this.dmsMapper.readValue(rawPkValue, Object.class);
        String datatypeId = (String)this.dmsMapper.readValue(rawDatatypeId, String.class);
        Map processMetadata = (Map)this.dmsMapper.readValue(rawProcessMetadata, this.dmsMetadataTypeReference);
        Runnable afterCreateAction = () -> {
            try {
                if (refresh && dialogId != null && moduleKey != null) {
                    WebGisModule wgMod = this.getWgContext().getModule(moduleKey);
                    WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(dialogId);
                    wgDlg.refresh();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not refresh dialog: " + ex.getMessage(), ex);
            }
        };
        this.dmsCreateProcess(moduleKey, dmsServiceId, pkValue, processMetadata, datatypeId, afterCreateAction);
    }

    private void dmsCreateProcess(Integer moduleKey, Integer dmsServiceId, Object pkValue, Map<String, String> processMetadata, String datatypeId, Runnable afterCreateAction) {
        String waitMessage = i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.wait-create-process");
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getFocusedOrMainWindow(), (String)waitMessage, () -> {
            DmsService dmsService = WebGisContext.getInstance().getDmsService();
            dmsService.createProcess(moduleKey, dmsServiceId, pkValue, processMetadata, datatypeId, afterCreateAction).join();
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.getFocusedOrMainWindow(), (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void dmsShowProcess(Map<String, Object[]> unmodifiableMapParam) throws JsonProcessingException, Exception {
        MigrateDmsMasterDialogParam mg;
        LinkedHashMap<String, Object[]> mapParam = new LinkedHashMap<String, Object[]>(unmodifiableMapParam);
        int dmsServiceId = ActionParameterUtils.readFirstValueInteger((Object[])mapParam.get("dmsServiceId"), null);
        String rawPkValue = ActionParameterUtils.readFirstValueString((Object[])mapParam.get("pkValue"), null);
        String rawDatatypeId = ActionParameterUtils.readFirstValueString((Object[])mapParam.get("datatypeId"), null);
        int moduleKey = ActionParameterUtils.readFirstValueInteger((Object[])mapParam.get("moduleKey"), null);
        String rawProcessUuid = ActionParameterUtils.readFirstValueString((Object[])mapParam.get("processUuid"), null);
        String migrateParams = ActionParameterUtils.readFirstValueString((Object[])mapParam.get("migrateParams"), "");
        MigrateDmsMasterDialogParam migrateDmsMasterDialogParam = mg = StringUtils.isNotBlank((CharSequence)migrateParams) ? (MigrateDmsMasterDialogParam)this.dmsMapper.readValue(migrateParams, MigrateDmsMasterDialogParam.class) : null;
        if (mg != null) {
            mapParam.put("dialogId", new Integer[]{mg.getMasterDialogId()});
        }
        if (mg != null) {
            Collection<String> results = this.dmsMigrateFile(mg, DialogShowCondition.CONDITIONAL);
            log.debug("result of migration: {}", (Object)StringUtils.join(results, (String)", "));
        } else {
            if (rawProcessUuid == null || "null".equals(rawProcessUuid)) {
                this.dmsCreateProcess(mapParam);
            }
            log.debug("do not execute migration, because migrateParams not given");
        }
        Object pkValue = this.dmsMapper.readValue(rawPkValue, Object.class);
        String datatypeId = (String)this.dmsMapper.readValue(rawDatatypeId, String.class);
        String waitMessage = i18n.get("de.riwagis.webgiscli.servlet.actions.InterfaceAction.wait-show-process");
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getFocusedOrMainWindow(), (String)waitMessage, () -> {
            DmsService dmsService = WebGisContext.getInstance().getDmsService();
            try {
                UUID processUuid = dmsService.getProcessUUID(moduleKey, null, dmsServiceId, pkValue);
                dmsService.showProcess(moduleKey, dmsServiceId, pkValue, datatypeId, processUuid).join();
            }
            catch (SystemException sex) {
                throw new RuntimeException(String.format("unable to retrieve process uuid: %s", sex.getMessage()), sex);
            }
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.getFocusedOrMainWindow(), (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void externalActionWithSelection(String intAction, boolean currentItemOnly, Integer dialogId, Integer moduleId) throws Exception {
        log.debug("Executing actionWithSelection");
        if (StringUtils.isBlank((CharSequence)intAction)) {
            throw new Exception("Missing interface action");
        }
        if (dialogId == null || moduleId == null) {
            throw new Exception("Invalid Parameters");
        }
        WebGisContext wgContext = this.getWgContext();
        WebGisModule wgMod = wgContext.getModule(moduleId);
        WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(dialogId);
        ModuleAppContext mapApp = WebGisClient.GIS_CONTEXT.getModuleApp();
        List<String> filter = currentItemOnly ? Collections.singletonList(wgDlg.getSelectedInFilter()) : List.of(wgDlg.getFilter());
        mapApp.invokeExternalCall(intAction, filter);
    }

    private void externalAction(String intAction, Map<String, String> parameters) throws Exception {
        log.debug("Executing action");
        if (StringUtils.isBlank((CharSequence)intAction)) {
            throw new Exception("Missing interface action");
        }
        ModuleAppContext mapApp = WebGisClient.GIS_CONTEXT.getModuleApp();
        mapApp.invokeExternalCall(intAction, parameters);
    }

    private static void writeFileAction(Map<String, Object[]> mapParam) throws Exception {
        String outputFile = InterfaceAction.retrieveParameterString(mapParam, "file");
        String outputText = InterfaceAction.retrieveParameterString(mapParam, "text");
        String moduleKey = InterfaceAction.retrieveParameterString(mapParam, "moduleid");
        boolean callerWantsEXEStart = Boolean.parseBoolean(InterfaceAction.retrieveParameterString(mapParam, "startexe", "true"));
        if (StringUtils.isBlank((CharSequence)outputFile) || StringUtils.isBlank((CharSequence)outputText)) {
            throw new Exception(String.format("Invalid Parameters: File: '%s', Text: '%s'", outputFile, outputText));
        }
        InterfaceAction.writeInterfaceFile(outputFile, outputText, moduleKey);
        if (callerWantsEXEStart) {
            File fileConfigINI = ExeFinder.findConfig(moduleKey);
            Properties exeProps = new Properties();
            try {
                if (fileConfigINI != null) {
                    Wini ini = new Wini(fileConfigINI);
                    for (Map.Entry e : ((Profile.Section)ini.get((Object)"global")).entrySet()) {
                        exeProps.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                }
            }
            catch (Throwable ioex) {
                log.warn(String.format("Error loading properties from '%s': %s", fileConfigINI, ioex.getMessage()), ioex);
            }
            boolean isListen = "1".equals(exeProps.getProperty("listen", "0"));
            if (!isListen) {
                File configPath = fileConfigINI != null ? fileConfigINI.getParentFile() : new File(".");
                File fileRiwainterfaceEXE = ExeFinder.findExe(moduleKey, configPath, exeProps);
                if (fileRiwainterfaceEXE == null) {
                    File userProvidedRiwainterfaceEXE = GUISupport.chooseSingleFile(null, (String)"riwainterface.exe w\u00e4hlen", (FileFilter[])new FileFilter[]{GUISupport.createFileFilter((String)"EXE-Dateien", (String[])new String[]{"exe"})}, null, (boolean)true);
                    if (userProvidedRiwainterfaceEXE != null && userProvidedRiwainterfaceEXE.isFile()) {
                        ExeFinder.writeUserSelectedEXE(moduleKey, userProvidedRiwainterfaceEXE);
                        InterfaceAction.runRiwaInterface(userProvidedRiwainterfaceEXE);
                    }
                } else {
                    InterfaceAction.runRiwaInterface(fileRiwainterfaceEXE);
                }
            }
        }
    }

    public static void runRiwaInterface(final File riwaEXE) throws IOException {
        log.info("Starting '{}'", (Object)riwaEXE);
        CommandLine cl = new CommandLine(riwaEXE);
        DefaultExecutor defEX = new DefaultExecutor();
        defEX.setWatchdog(new ExecuteWatchdog(60000L));
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        defEX.setWorkingDirectory(riwaEXE.getParentFile());
        defEX.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new LogOutputStream(){

            protected void processLine(String line, int level) {
                log.info("[Output '{}'] {}", (Object)riwaEXE, (Object)line);
            }
        }));
        defEX.execute(cl, (ExecuteResultHandler)resultHandler);
    }

    public static void writeInterfaceFile(String strFile, String strText, String strModuleID) throws IOException {
        File outFile = new File(WebGisClient.INTERFACE_DIR, strFile);
        log.info("Writing interface-file '{}'", (Object)outFile);
        FileUtils.writeStringToFile((File)outFile, (String)strText, (Charset)StandardCharsets.ISO_8859_1);
    }
}

