/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import de.riwagis.gis.context.GisContext;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapAppContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.map.WMSLayerContext;
import de.riwagis.gis.context.map.selection.ColumnFilter;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.util.StringSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAction;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GisContextAction
extends AbstractAction {
    private final Gson gson = new Gson();
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_FILTER = "filter";
    public static final String PARAM_LAYER = "layer";
    public static final String PARAM_LAYER_MASK = "layermask";
    private static final Logger LOG = LoggerFactory.getLogger(GisContextAction.class);
    private static final Map<String, String> filter4LayerStore = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> name4LayerStore = Collections.synchronizedMap(new HashMap());
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public String getName() {
        return "GisContext";
    }

    private String executeContextAction(Map<String, Object[]> mapParam) throws SystemException {
        GisContext gctx = WebGisClient.GIS_CONTEXT;
        if (gctx == null) {
            return "";
        }
        try {
            MapContext mapctx = gctx.getMapApp().getActiveMap();
            if (mapctx == null) {
                throw new SystemException("No active map found.");
            }
            String strAction = GisContextAction.getParamString(mapParam, PARAM_ACTION);
            throw new Exception(String.format("action '%s' not found.", strAction));
        }
        catch (Exception e) {
            LOG.warn(String.format("Error on ContextAction: %s", e.getMessage()), (Throwable)e);
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String execute(Map<String, Object[]> mapParam) throws SystemException {
        GisContext gctx = WebGisClient.GIS_CONTEXT;
        if (gctx == null) {
            return "";
        }
        try {
            String strAction = GisContextAction.getParamString(mapParam, PARAM_ACTION);
            if (StringUtils.equals((String)strAction, (String)"isInitialized")) {
                if (WebGisClient.GIS_CONTEXT != null) {
                    MapAppContext mapApp = WebGisClient.GIS_CONTEXT.getMapApp();
                    if (mapApp == null) {
                        return "0";
                    }
                    MapContext ctxMap = mapApp.getActiveMap();
                    if (ctxMap == null || !ctxMap.isInitialized() || ctxMap.isRendering()) {
                        return "0";
                    }
                }
                return "1";
            }
            MapAppContext mapApp = gctx.getMapApp();
            if (mapApp == null) {
                throw new SystemException("No map context found.");
            }
            MapContext mapctx = mapApp.getActiveMap();
            if (mapctx == null) {
                throw new SystemException("No active map found.");
            }
            if (StringUtils.equals((String)strAction, (String)"getSelection")) {
                String strLayerKeys = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                String strLayerMask = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER_MASK), "");
                LinkedHashSet<String> layerSelections = new LinkedHashSet<String>();
                if (StringUtils.isNotBlank((String)strLayerKeys) || StringUtils.isNotBlank((String)strLayerMask)) {
                    LinkedHashSet<LayerContext> layers = new LinkedHashSet<LayerContext>();
                    layers.addAll(GisContextAction.findLayersByMask(mapctx, strLayerMask));
                    layers.addAll(GisContextAction.findLayersByKeys(mapctx, strLayerKeys));
                    for (LayerContext currLayer : layers) {
                        VectorLayerContext vlyctx;
                        if (!(currLayer instanceof VectorLayerContext) || (vlyctx = (VectorLayerContext)currLayer).getSelection().length <= 0) continue;
                        layerSelections.add(String.format("%s$%s", currLayer.getID(), StringUtils.join((Object[])vlyctx.getSelection(), (char)'$')));
                    }
                } else {
                    for (Map.Entry currLayer : mapctx.getSelection().entrySet()) {
                        if (((String[])currLayer.getValue()).length <= 0) continue;
                        layerSelections.add(String.format("%s$%s", currLayer.getKey(), StringUtils.join((Object[])((Object[])currLayer.getValue()), (char)'$')));
                    }
                }
                return StringUtils.join(layerSelections, (String)"|");
            }
            if (StringUtils.equals((String)strAction, (String)"getSelectionOnLayer")) {
                String[] arrID;
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                int intMethod = ActionParameterUtils.readFirstValueInteger(mapParam.get("method"), 0);
                double dblMinArea = ActionParameterUtils.readFirstValueDouble(mapParam.get("min_area"), 0.0);
                boolean bolUseTouch = ActionParameterUtils.readFirstValueBoolean(mapParam.get("use_touch"), false);
                String strFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                StringBuilder sbSel = new StringBuilder();
                for (String currID : arrID = vlyctx.getSelectionOnLayer(intMethod, dblMinArea, bolUseTouch, strFilter)) {
                    if (sbSel.length() > 0) {
                        sbSel.append("$");
                    }
                    sbSel.append(currID);
                }
                return sbSel.toString();
            }
            if (StringUtils.equals((String)strAction, (String)"setSelection")) {
                String strSelection = ActionParameterUtils.readFirstValueString(mapParam.get("selection"), "");
                if (StringUtils.isBlank((String)strSelection)) {
                    return "";
                }
                Map<String, String[]> mapSelection = GisContextAction.parseSelection(strSelection);
                int intScale = ActionParameterUtils.readFirstValueInteger(mapParam.get("scale"), 500);
                String zoomEnvelopeString = ActionParameterUtils.readFirstValueString(mapParam.get("zoomEnvelope"), "");
                ReferencedEnvelope zoomEnvelope = EnvelopeUtil.readReferencedEnvelope((String)zoomEnvelopeString);
                LOG.debug("new selection: {}", mapSelection);
                mapctx.setSelection(mapSelection, true, (double)intScale, (Envelope)zoomEnvelope);
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"setSelectionByFilter")) {
                String rawData = ActionParameterUtils.readFirstValueString(mapParam.get("data"), "");
                if (StringUtils.isBlank((String)rawData)) {
                    return "";
                }
                SelectionByFilterData data = (SelectionByFilterData)this.gson.fromJson(rawData, SelectionByFilterData.class);
                if (data == null) {
                    return "";
                }
                boolean activateLayers = Objects.requireNonNullElse(data.getActivateLayers(), true);
                boolean zoom = Objects.requireNonNullElse(data.getZoom(), true);
                double minScale = Objects.requireNonNullElse(data.getMinScale(), 500.0);
                boolean openFeatureInfo = Objects.requireNonNullElse(data.getOpenFeatureInfo(), false);
                mapctx.setSelectionByFilter(data.getSelection(), activateLayers, zoom, minScale, openFeatureInfo);
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"getFilter")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                String strFilter = vlyctx.getFilter();
                if (!filter4LayerStore.containsKey(vlyctx.getID())) {
                    filter4LayerStore.put(vlyctx.getID(), strFilter);
                }
                return ObjectUtils.toString((Object)strFilter);
            }
            if (StringUtils.equals((String)strAction, (String)"setFilter")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                String strFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                boolean bolSetVisible = ActionParameterUtils.readFirstValueBoolean(mapParam.get("setvisible"), true);
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                String strCurrentFilter = vlyctx.getFilter();
                if (!filter4LayerStore.containsKey(vlyctx.getID())) {
                    filter4LayerStore.put(vlyctx.getID(), strCurrentFilter);
                }
                vlyctx.setFilter(strFilter);
                if (!vlyctx.isVisible() && bolSetVisible) {
                    vlyctx.setVisible(true);
                }
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"resetFilter")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "0");
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                if (filter4LayerStore.containsKey(vlyctx.getID())) {
                    vlyctx.setFilter(filter4LayerStore.get(vlyctx.getID()));
                    return "1";
                }
                return "0";
            }
            if (StringUtils.equals((String)strAction, (String)"getFIDFilter")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                StringBuilder sbFIDFilter = new StringBuilder();
                String[] arrID = vlyctx.getFIDFilter();
                if (arrID != null) {
                    for (String currID : arrID) {
                        if (sbFIDFilter.length() > 0) {
                            sbFIDFilter.append("$");
                        }
                        sbFIDFilter.append(currID);
                    }
                }
                return sbFIDFilter.toString();
            }
            if (StringUtils.equals((String)strAction, (String)"setFIDFilter")) {
                String strFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                Map<String, String[]> mapFilter = GisContextAction.parseSelection(strFilter);
                boolean bolSetVisible = ActionParameterUtils.readFirstValueBoolean(mapParam.get("setvisible"), true);
                LOG.debug("new fid filter: {}", mapFilter);
                mapctx.setFIDFilter(mapFilter, bolSetVisible);
                mapctx.clearSelection();
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"addFIDFilter")) {
                String strFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                Map<String, String[]> mapFilter = GisContextAction.parseSelection(strFilter);
                boolean bolSetVisible = ActionParameterUtils.readFirstValueBoolean(mapParam.get("setvisible"), true);
                LOG.debug("new fid filter: {}", mapFilter);
                mapctx.addFIDFilter(mapFilter, bolSetVisible);
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"removeFIDFilter")) {
                String strFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                Map<String, String[]> mapFilter = GisContextAction.parseSelection(strFilter);
                boolean bolSetVisible = ActionParameterUtils.readFirstValueBoolean(mapParam.get("setvisible"), true);
                LOG.debug(String.format("new fid filter: %s", mapFilter));
                mapctx.removeFIDFilter(mapFilter, bolSetVisible);
                mapctx.clearSelection();
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"resetFIDFilter")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "0");
                String[] arrLayerKey = strLayerKey.split("\\$");
                mapctx.resetFIDFilter(arrLayerKey);
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"zoom")) {
                Double dblX = ActionParameterUtils.readFirstValueDouble(mapParam.get("x"), null);
                Double dblY = ActionParameterUtils.readFirstValueDouble(mapParam.get("y"), null);
                if (dblX == null || dblY == null) {
                    LOG.debug("no zoom center provided.");
                    return "0";
                }
                String crsCode = ActionParameterUtils.readFirstValueString(mapParam.get("crscode"), null);
                CoordinateReferenceSystem crs = StringUtils.isNotBlank((String)crsCode) ? CRS.decode((String)crsCode) : null;
                Double dblWidth = ActionParameterUtils.readFirstValueDouble(mapParam.get("width"), null);
                Integer intScale = ActionParameterUtils.readFirstValueInteger(mapParam.get("scale"), null);
                if (intScale == null && dblWidth == null) {
                    LOG.debug("neither scale nor width provided.");
                    return "0";
                }
                if (dblWidth != null) {
                    ReferencedEnvelope env = new ReferencedEnvelope(dblX - dblWidth / 2.0, dblX + dblWidth / 2.0, dblY - dblWidth / 100.0, dblY + dblWidth / 100.0, crs);
                    mapctx.zoomEnvelope((Envelope)env, null);
                } else {
                    ReferencedEnvelope env = new ReferencedEnvelope(dblX - 1.0E-10, dblX + 1.0E-10, dblY - 1.0E-10, dblY + 1.0E-10, crs);
                    mapctx.zoomEnvelope((Envelope)env, (double)intScale.intValue(), null);
                }
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"refresh")) {
                String[] arrLayerKey;
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "0";
                }
                for (String currLayerKey : arrLayerKey = strLayerKey.split("\\$")) {
                    LayerContext lyctx = mapctx.getMapLayer(currLayerKey);
                    if (lyctx == null) continue;
                    lyctx.refresh();
                }
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"setVisible")) {
                String[] arrLayerKey;
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "0";
                }
                Boolean bolVisi = ActionParameterUtils.readFirstValueBoolean(mapParam.get("visible"), null);
                if (bolVisi == null) {
                    return "0";
                }
                for (String currLayerKey : arrLayerKey = strLayerKey.split("\\$")) {
                    LayerContext lyctx = mapctx.getMapLayer(currLayerKey);
                    if (lyctx == null) continue;
                    lyctx.setVisible(bolVisi.booleanValue());
                }
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"isVisible")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                boolean ignoreScaleRange = ActionParameterUtils.readFirstValueBoolean(mapParam.get("ignorescalerange"), false);
                return "" + lyctx.isVisible(ignoreScaleRange);
            }
            if (StringUtils.equals((String)strAction, (String)"getScale")) {
                return "" + mapctx.getScale();
            }
            if (StringUtils.equals((String)strAction, (String)"getAllWmsLayers")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                WMSLayerContext lyctx = (WMSLayerContext)mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                Object[] arrWmsLy = lyctx.getAllServiceLayers();
                return StringSupport.toDelimitedString((Object[])arrWmsLy, (String)"$");
            }
            if (StringUtils.equals((String)strAction, (String)"getActiveWmsLayers")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                WMSLayerContext lyctx = (WMSLayerContext)mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                Object[] arrWmsLy = lyctx.getActiveServiceLayers();
                return StringSupport.toDelimitedString((Object[])arrWmsLy, (String)"$");
            }
            if (StringUtils.equals((String)strAction, (String)"getVisibleWmsLayers")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                WMSLayerContext lyctx = (WMSLayerContext)mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                Object[] arrWmsLy = lyctx.getVisibleServiceLayers();
                return StringSupport.toDelimitedString((Object[])arrWmsLy, (String)"$");
            }
            if (StringUtils.equals((String)strAction, (String)"setActiveWmsLayers")) {
                WMSLayerContext lyctx;
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "0";
                }
                String strWmsLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get("wmslayer"), "");
                String[] arrWmsLayer = new String[]{};
                if (strWmsLayerKey.length() > 0) {
                    arrWmsLayer = strWmsLayerKey.split("\\$");
                }
                if ((lyctx = (WMSLayerContext)mapctx.getMapLayer(strLayerKey)) == null) {
                    return "0";
                }
                lyctx.setActiveServiceLayers(arrWmsLayer);
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"getCoordinate")) {
                String strMessage = ActionParameterUtils.readFirstValueString(mapParam.get("message"), "");
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                Coordinate coord = mapctx.getCoordinate(strMessage);
                if (coord == null) {
                    return "";
                }
                return String.format("%s;%s", coord.x, coord.y);
            }
            if (StringUtils.equals((String)strAction, (String)"getRefCoordinate")) {
                String strMessage = ActionParameterUtils.readFirstValueString(mapParam.get("message"), "");
                gctx.getMapApp().getFrame().setVisible(true);
                gctx.getMapApp().getFrame().requestFocus();
                Coordinate coord = mapctx.getCoordinate(strMessage);
                if (coord == null) {
                    return "";
                }
                LinkedHashMap<String, Object> coordMap = new LinkedHashMap<String, Object>();
                coordMap.put("x", coord.x);
                coordMap.put("y", coord.y);
                coordMap.put("z", coord.z);
                coordMap.put("srs", gctx.getMapApp().getActiveMap().getCrsCode());
                return this.gson.toJson(coordMap);
            }
            if (StringUtils.equals((String)strAction, (String)"setLayerName")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "0";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "0";
                }
                String strLyName = ActionParameterUtils.readFirstValueString(mapParam.get("layername"), "");
                if (StringUtils.isBlank((String)strLyName)) {
                    return "0";
                }
                String currentName = lyctx.getName();
                if (!name4LayerStore.containsKey(lyctx.getID())) {
                    name4LayerStore.put(lyctx.getID(), currentName);
                }
                lyctx.setName(strLyName);
                return "1";
            }
            if (StringUtils.equals((String)strAction, (String)"getLayerName")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                String layerName = lyctx.getName();
                if (!name4LayerStore.containsKey(lyctx.getID())) {
                    name4LayerStore.put(lyctx.getID(), layerName);
                }
                return layerName;
            }
            if (StringUtils.equals((String)strAction, (String)"getLayerModuleInfo")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                ModuleAppContext modContext = gctx.getModuleApp();
                if (StringUtils.isBlank((String)strLayerKey) || lyctx == null) {
                    return "[]";
                }
                DialogContext[] arrDlg = modContext.getDialogs4Layer(strLayerKey);
                Map[] layerModuleInfoArray = new Map[arrDlg.length];
                for (int i = 0; i < arrDlg.length; ++i) {
                    layerModuleInfoArray[i] = new LinkedHashMap();
                    layerModuleInfoArray[i].put("dbparserid", arrDlg[i].getID());
                    layerModuleInfoArray[i].put("dbparsermodule", arrDlg[i].getModuleID());
                }
                return this.gson.toJson((Object)layerModuleInfoArray);
            }
            if (StringUtils.equals((String)strAction, (String)"getLayerType")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                return String.format("%d", lyctx.getType());
            }
            if (StringUtils.equals((String)strAction, (String)"getVisibleEnvelope")) {
                String crsCode = ActionParameterUtils.readFirstValueString(mapParam.get("crscode"), "");
                Envelope env = mapctx.getEnvelope();
                LinkedHashMap<String, Object> envelopeBoundaries = new LinkedHashMap<String, Object>();
                if (!crsCode.isEmpty() && mapctx.getCrsCode() != null) {
                    try {
                        Transformer trans = new Transformer(mapctx.getCrsCode(), crsCode);
                        trans.transform2d(env);
                    }
                    catch (Exception e) {
                        crsCode = "";
                    }
                }
                envelopeBoundaries.put("x_min", env.getMinX());
                envelopeBoundaries.put("x_max", env.getMaxX());
                envelopeBoundaries.put("y_min", env.getMinY());
                envelopeBoundaries.put("y_max", env.getMaxY());
                envelopeBoundaries.put("srs", !crsCode.isEmpty() && mapctx.getCrsCode() != null ? crsCode : mapctx.getCrsCode());
                return this.gson.toJson(envelopeBoundaries);
            }
            if (StringUtils.equals((String)strAction, (String)"resetLayerName")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                if (StringUtils.isBlank((String)strLayerKey)) {
                    return "";
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (lyctx == null) {
                    return "";
                }
                if (name4LayerStore.containsKey(lyctx.getID())) {
                    lyctx.setName(name4LayerStore.get(lyctx.getID()));
                    return "1";
                }
                return "0";
            }
            if (StringUtils.equals((String)strAction, (String)"bringToFront")) {
                Frame frame = gctx.getMapApp().getFrame();
                SwingUtilities.invokeLater(() -> {
                    if (frame.getState() != 0) {
                        frame.setState(0);
                    }
                    frame.setAlwaysOnTop(true);
                    frame.toFront();
                    frame.repaint();
                    frame.setAlwaysOnTop(false);
                });
                return "";
            }
            if (StringUtils.equals((String)strAction, (String)"getFIDs")) {
                String strLayerKey = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_LAYER), "");
                String cqlFilter = ActionParameterUtils.readFirstValueString(mapParam.get(PARAM_FILTER), "");
                if (StringUtils.isBlank((String)strLayerKey) || StringUtils.isBlank((String)cqlFilter)) {
                    throw new SystemException("Layer Key and CQL Query cannot be null.");
                }
                LayerContext lyctx = mapctx.getMapLayer(strLayerKey);
                if (!(lyctx instanceof VectorLayerContext)) {
                    throw new SystemException("Layer must be a vector layer.");
                }
                VectorLayerContext vLayer = (VectorLayerContext)lyctx;
                Set fids = vLayer.getFIDs(ECQL.toFilter((String)cqlFilter));
                return this.objectMapper.writeValueAsString((Object)fids);
            }
            Object[] arrReturn = new Object[1];
            SwingUtilities.invokeAndWait(() -> {
                try {
                    arrReturn[0] = this.executeContextAction(mapParam);
                }
                catch (SystemException e) {
                    arrReturn[0] = e;
                }
            });
            if (arrReturn[0] instanceof Exception) {
                throw (Exception)arrReturn[0];
            }
            return ObjectUtils.toString((Object)arrReturn[0]);
        }
        catch (Exception e) {
            LOG.warn(String.format("Error on ContextAction: %s", e.getMessage()), (Throwable)e);
            SwingUtilities.invokeLater(() -> ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli"));
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public static Map<String, String[]> parseSelection(String strSelection) {
        HashMap<String, String[]> mapSelection = new HashMap<String, String[]>();
        int idCount = 0;
        for (String currLySelection : strSelection.split("\\|")) {
            String[] arrSel = currLySelection.split("\\$");
            String[] arrIDs = Arrays.copyOfRange(arrSel, 1, arrSel.length);
            idCount += arrIDs.length;
            mapSelection.put(arrSel[0], arrIDs);
        }
        if (idCount == 0) {
            LOG.info(String.format("No ids in any layer selected: %s", strSelection));
        }
        return mapSelection;
    }

    public static final Collection<LayerContext> findLayersByKeys(MapContext mapctx, String layerKeys) throws Exception {
        LinkedHashSet<LayerContext> res = new LinkedHashSet<LayerContext>();
        for (String currLayerKey : StringUtils.split((String)layerKeys, (char)'$')) {
            LayerContext lyctx = mapctx.getMapLayer(currLayerKey);
            if (lyctx == null) continue;
            res.add(lyctx);
        }
        return res;
    }

    public static final Collection<LayerContext> findLayersByMask(MapContext mapctx, String layerMask) throws Exception {
        try {
            LinkedHashSet<LayerContext> res = new LinkedHashSet<LayerContext>();
            if (StringUtils.isNotBlank((String)layerMask)) {
                Pattern p = Pattern.compile(layerMask);
                for (LayerContext currLayerContext : mapctx.getMapLayers()) {
                    if (!p.matcher(currLayerContext.getID()).matches()) continue;
                    res.add(currLayerContext);
                }
            }
            return res;
        }
        catch (Exception ex) {
            throw new Exception(String.format("error reading layers by mask '%s': %s", layerMask, ex.getMessage()), ex);
        }
    }

    private static class SelectionByFilterData {
        Map<String, ColumnFilter> selection;
        Boolean activateLayers;
        Boolean zoom;
        Double minScale;
        Boolean openFeatureInfo;

        @Generated
        public SelectionByFilterData() {
        }

        @Generated
        public Map<String, ColumnFilter> getSelection() {
            return this.selection;
        }

        @Generated
        public Boolean getActivateLayers() {
            return this.activateLayers;
        }

        @Generated
        public Boolean getZoom() {
            return this.zoom;
        }

        @Generated
        public Double getMinScale() {
            return this.minScale;
        }

        @Generated
        public Boolean getOpenFeatureInfo() {
            return this.openFeatureInfo;
        }

        @Generated
        public void setSelection(Map<String, ColumnFilter> selection) {
            this.selection = selection;
        }

        @Generated
        public void setActivateLayers(Boolean activateLayers) {
            this.activateLayers = activateLayers;
        }

        @Generated
        public void setZoom(Boolean zoom) {
            this.zoom = zoom;
        }

        @Generated
        public void setMinScale(Double minScale) {
            this.minScale = minScale;
        }

        @Generated
        public void setOpenFeatureInfo(Boolean openFeatureInfo) {
            this.openFeatureInfo = openFeatureInfo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectionByFilterData)) {
                return false;
            }
            SelectionByFilterData other = (SelectionByFilterData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$activateLayers = this.getActivateLayers();
            Boolean other$activateLayers = other.getActivateLayers();
            if (this$activateLayers == null ? other$activateLayers != null : !((Object)this$activateLayers).equals(other$activateLayers)) {
                return false;
            }
            Boolean this$zoom = this.getZoom();
            Boolean other$zoom = other.getZoom();
            if (this$zoom == null ? other$zoom != null : !((Object)this$zoom).equals(other$zoom)) {
                return false;
            }
            Double this$minScale = this.getMinScale();
            Double other$minScale = other.getMinScale();
            if (this$minScale == null ? other$minScale != null : !((Object)this$minScale).equals(other$minScale)) {
                return false;
            }
            Boolean this$openFeatureInfo = this.getOpenFeatureInfo();
            Boolean other$openFeatureInfo = other.getOpenFeatureInfo();
            if (this$openFeatureInfo == null ? other$openFeatureInfo != null : !((Object)this$openFeatureInfo).equals(other$openFeatureInfo)) {
                return false;
            }
            Map<String, ColumnFilter> this$selection = this.getSelection();
            Map<String, ColumnFilter> other$selection = other.getSelection();
            return !(this$selection == null ? other$selection != null : !((Object)this$selection).equals(other$selection));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SelectionByFilterData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $activateLayers = this.getActivateLayers();
            result = result * 59 + ($activateLayers == null ? 43 : ((Object)$activateLayers).hashCode());
            Boolean $zoom = this.getZoom();
            result = result * 59 + ($zoom == null ? 43 : ((Object)$zoom).hashCode());
            Double $minScale = this.getMinScale();
            result = result * 59 + ($minScale == null ? 43 : ((Object)$minScale).hashCode());
            Boolean $openFeatureInfo = this.getOpenFeatureInfo();
            result = result * 59 + ($openFeatureInfo == null ? 43 : ((Object)$openFeatureInfo).hashCode());
            Map<String, ColumnFilter> $selection = this.getSelection();
            result = result * 59 + ($selection == null ? 43 : ((Object)$selection).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GisContextAction.SelectionByFilterData(selection=" + String.valueOf(this.getSelection()) + ", activateLayers=" + this.getActivateLayers() + ", zoom=" + this.getZoom() + ", minScale=" + this.getMinScale() + ", openFeatureInfo=" + this.getOpenFeatureInfo() + ")";
        }
    }
}

