/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.gis.context.GisContext;
import de.riwagis.gis.context.map.Gis3DContext;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAction;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gis3DContextAction
extends AbstractAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Gis3DContextAction.class);
    public static final String PARAM_ACTION = "action";
    private final Map<String, BiFunction<Gis3DContext, Map<String, Object[]>, String>> actions = Map.of("is_active", (context, params) -> context.is3DActive() ? "1" : "0", "send_message", (context, params) -> {
        String functionName = ActionParameterUtils.readFirstValueString((Object[])params.get("functionName"), "");
        String arguments = ActionParameterUtils.readFirstValueString((Object[])params.get("arguments"), "[]");
        boolean waitForResult = ActionParameterUtils.readFirstValueString((Object[])params.get("waitForResult"), "0").equals("1");
        if (waitForResult) {
            return context.sendMessage(functionName, arguments, waitForResult);
        }
        SwingUtilities.invokeLater(() -> context.sendMessage(functionName, arguments, waitForResult));
        return "";
    }, "signal_initialized", (context, params) -> {
        String[] layers = ActionParameterUtils.readFirstValueString((Object[])params.get("layer"), "").split(",");
        SwingUtilities.invokeLater(() -> {
            context.setAvailableLayers(Set.of(layers));
            context.signalInitialized();
        });
        return "";
    });

    @Override
    public String execute(Map<String, Object[]> mapParam) throws SystemException {
        GisContext gisContext = WebGisClient.GIS_CONTEXT;
        if (gisContext == null) {
            return "No GisContext!";
        }
        try {
            Gis3DContext giS3DContext = gisContext.getMapApp().getGIS3DContext();
            if (giS3DContext == null) {
                throw new SystemException("No gis 3d context found.");
            }
            String actionName = Gis3DContextAction.getParamString(mapParam, PARAM_ACTION);
            BiFunction<Gis3DContext, Map<String, Object[]>, String> action = this.actions.get(actionName);
            if (action == null) {
                throw new Exception(String.format("action '%s' not found.", actionName));
            }
            return action.apply(giS3DContext, mapParam);
        }
        catch (Exception e) {
            log.warn(String.format("Error on Gis3DContextAction: %s", e.getMessage()), (Throwable)e);
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "3d";
    }
}

