/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapAppContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.util.ActionSupport;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class GeometryAction
extends AbstractAsyncAction {
    public static final String PARAM_FILTER_TYPE = "filter_type";
    public static final String PARAM_LAYER_NAMES_TO_HIGHLIGHT = "layerstohighlight";
    public static final int FILTER_TYPE_CURRENT_FILTER = 1;
    public static final int FILTER_TYPE_ALL_OBJECTS = 2;
    public static final int FILTER_TYPE_CURRENT_OBJECT = 3;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final Map<String, GeometryActionFunction> actionMap = Map.ofEntries(Map.entry("dbparser_zoomsingle", this::dbparserZoomSingle), Map.entry("dbparser_zoomall", this::dbparserZoomAll), Map.entry("dbparser_reload", this::dbparserReload), Map.entry("dbparser_addgeom", this::dbParserAddGeometry), Map.entry("dbparser_setfidfilter", this::setFidFilter), Map.entry("dbparser_addfidfilter", this::addFidFilter), Map.entry("dbparser_removefidfilter", this::removeFidFilter), Map.entry("dbparser_resetfidfilter", this::resetFidFilter), Map.entry("layer_addgeom", this::layerAddGeometry), Map.entry("jumpTo", this::jumpTo), Map.entry("addPoint", this::addPoint));

    @Override
    public String getName() {
        return "Geometry";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String actionName = ActionParameterUtils.readFirstValueString(mapParam.get("action"), null);
            if (WebGisClient.GIS_CONTEXT == null) {
                JOptionPane.showMessageDialog(this.getWgContext().getWebGisClient().getFrame(), i18n.get("servlet.actions.GeometryAction.warning-no-gis-context"), i18n.get("common.warning"), 2);
                return;
            }
            MapAppContext mapApp = WebGisClient.GIS_CONTEXT.getMapApp();
            if (mapApp == null) {
                throw new SystemException("No map app context found.");
            }
            MapContext activeMap = mapApp.getActiveMap();
            if (activeMap == null) {
                JOptionPane.showMessageDialog(mapApp.getFrame(), i18n.get("servlet.actions.GeometryAction.warning-no-active-map"), i18n.get("common.warning"), 2);
                return;
            }
            GeometryActionFunction geometryAction = this.actionMap.get(actionName);
            if (geometryAction == null) {
                throw new Exception(String.format("action '%s' not found.", actionName));
            }
            geometryAction.run(mapParam, mapApp, activeMap);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private WebGisDialog getWebGisDialog(Map<String, Object[]> mapParam) throws Exception {
        Object[] objDialogId = mapParam.get("dbparserid");
        Object[] objModuleId = mapParam.get("dbparsermodule");
        if (objDialogId == null || objModuleId == null) {
            throw new Exception("Invalid Parameters");
        }
        int intDlgKey = Integer.parseInt(((String[])objDialogId)[0]);
        int intModKey = Integer.parseInt(((String[])objModuleId)[0]);
        WebGisContext wgContext = this.getWgContext();
        WebGisModule wgMod = wgContext.getModule(intModKey);
        WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(intDlgKey);
        if (!wgDlg.hasDialogMap()) {
            throw new Exception("Dialog has no connection to a map layer.");
        }
        return wgDlg;
    }

    private void clearSelectionIfSpecified(Map<String, Object[]> mapParam, MapContext activeMap) throws Exception {
        Object[] objClearSel = mapParam.get("clearselection");
        if (objClearSel != null) {
            activeMap.clearSelection();
        }
    }

    private void dbparserZoomSingle(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        this.dbparserZoom(mapParam, mapApp, activeMap, wgDlg, this.getFilter(mapParam, wgDlg, 3), 3);
    }

    private void dbparserZoomAll(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        this.dbparserZoom(mapParam, mapApp, activeMap, wgDlg, this.getFilter(mapParam, wgDlg, 1), 1);
    }

    private void dbparserZoom(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap, WebGisDialog wgDlg, String[] arrFilter, int filterType) throws Exception {
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        double dblMinScale = wgDlg.getDialogMap().getMinZoomScale();
        List<String> layerNamesToHighlight = this.getLayerNamesToHighlight(mapParam);
        HashMap<String, String[]> mapZoom = new HashMap<String, String[]>();
        for (String arrLayer : arrLayers) {
            LayerContext ly;
            if (layerNamesToHighlight != null && !layerNamesToHighlight.contains(arrLayer)) continue;
            mapZoom.put(arrLayer, arrFilter);
            if (!wgDlg.getDialogMap().setLayerVisibleOnZooming(arrLayer) || (ly = activeMap.getMapLayer(arrLayer)) == null || ly.isVisible()) continue;
            ly.setVisible(true);
        }
        this.handleZoom(mapParam, mapApp, activeMap, wgDlg, filterType, mapZoom, dblMinScale);
    }

    private List<String> getLayerNamesToHighlight(Map<String, Object[]> mapParams) {
        Object[] layerNamesToHighlight = mapParams.get(PARAM_LAYER_NAMES_TO_HIGHLIGHT);
        if (layerNamesToHighlight == null || layerNamesToHighlight[0] == null) {
            return null;
        }
        String layerNames = layerNamesToHighlight[0].toString();
        if (layerNames.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.asList(layerNames.split("\\|"));
    }

    private void handleZoom(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap, WebGisDialog wgDlg, int filterType, Map<String, String[]> mapZoom, double dblMinScale) throws Exception {
        Envelope env;
        int version = this.getWgContext().getVersion();
        if (version < 1022) {
            env = activeMap.setSelection(mapZoom, true, dblMinScale);
        } else {
            Envelope bounds = wgDlg.getBounds(filterType);
            bounds.expandBy(bounds.getWidth() * 0.2);
            env = activeMap.setSelection(mapZoom, true, dblMinScale, bounds);
        }
        this.requestFocusForLinux(mapApp);
        if (env == null || env.isNull()) {
            GUISupport.msgbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.no-geodata"), (String)i18n.get("common.message"));
        }
        mapApp.getGIS3DContext().syncPositionTo3D();
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private void dbparserReload(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        String[] arrLayers;
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        for (String arrLayer : arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs()) {
            LayerContext ly = activeMap.getMapLayer(arrLayer);
            if (ly == null) continue;
            ly.refresh();
        }
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private void dbParserAddGeometry(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        VectorLayerContext ly;
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        String strFID = GeometryAction.retrieveParameterString(mapParam, "filter", "");
        if (strFID.isEmpty()) {
            strFID = wgDlg.getSelectedInFilter();
        }
        if (arrLayers.length == 0) {
            GUISupport.msgbox((Component)mapApp.getFrame(), (String)"No layers for geometry creation found in dialog.xdlg", (String)i18n.get("common.message"));
            return;
        }
        boolean bolSuccess = false;
        boolean bolLayerFound = false;
        boolean resetFIDFilter = false;
        for (String arrLayer : arrLayers) {
            ly = (VectorLayerContext)activeMap.getMapLayer(arrLayer);
            if (ly == null || !ly.isEditable()) continue;
            String[] arrIDFilter = ly.getFIDFilter();
            if (arrIDFilter != null && !(resetFIDFilter = GUISupport.okcancelbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.error-dbparser-addgeometry-fidfilter"), (String)i18n.get("common.alert")))) {
                return;
            }
            bolLayerFound = true;
            if (!ly.addGeometry(strFID)) continue;
            bolSuccess = true;
            if (ly.isVisible()) break;
            ly.setVisible(true);
            break;
        }
        if (!bolLayerFound) {
            GUISupport.msgbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.error-dbparser-no-layer-found"), (String)i18n.get("common.error"));
            return;
        }
        if (!bolSuccess) {
            GUISupport.msgbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.error-dbparser-addgeometry"), (String)i18n.get("common.error"));
            return;
        }
        if (resetFIDFilter) {
            for (String arrLayer : arrLayers) {
                ly = (VectorLayerContext)activeMap.getMapLayer(arrLayer);
                if (ly == null) continue;
                ly.setFIDFilter(null);
            }
        }
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private void setFidFilter(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        String[] arrFilter = this.getFilter(mapParam, wgDlg);
        HashMap<String, String[]> mapFilter = new HashMap<String, String[]>();
        for (String arrLayer : arrLayers) {
            LayerContext ly;
            mapFilter.put(arrLayer, arrFilter);
            if (!wgDlg.getDialogMap().setLayerVisibleOnZooming(arrLayer) || (ly = activeMap.getMapLayer(arrLayer)) == null || ly.isVisible()) continue;
            ly.setVisible(true);
        }
        MapContext mapctx = activeMap;
        mapctx.setFIDFilter(mapFilter, false);
        mapctx.clearSelection();
        this.requestFocusForLinux(mapApp);
    }

    private void addFidFilter(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        String[] arrFilter = this.getFilter(mapParam, wgDlg);
        HashMap<String, String[]> mapFilter = new HashMap<String, String[]>();
        for (String layerKey : arrLayers) {
            LayerContext ly;
            mapFilter.put(layerKey, arrFilter);
            if (!wgDlg.getDialogMap().setLayerVisibleOnZooming(layerKey) || (ly = activeMap.getMapLayer(layerKey)) == null || ly.isVisible()) continue;
            ly.setVisible(true);
        }
        MapContext mapctx = activeMap;
        mapctx.addFIDFilter(mapFilter, false);
        this.requestFocusForLinux(mapApp);
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private void requestFocusForLinux(MapAppContext mapApp) throws Exception {
        mapApp.getFrame().setVisible(true);
        mapApp.getFrame().requestFocus();
    }

    private void removeFidFilter(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        String[] arrFilter = this.getFilter(mapParam, wgDlg);
        HashMap<String, String[]> mapFilter = new HashMap<String, String[]>();
        for (String arrLayer : arrLayers) {
            LayerContext ly;
            mapFilter.put(arrLayer, arrFilter);
            if (!wgDlg.getDialogMap().setLayerVisibleOnZooming(arrLayer) || (ly = activeMap.getMapLayer(arrLayer)) == null || ly.isVisible()) continue;
            ly.setVisible(true);
        }
        MapContext mapctx = activeMap;
        mapctx.removeFIDFilter(mapFilter, false);
        mapctx.clearSelection();
        this.requestFocusForLinux(mapApp);
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private String[] getFilter(Map<String, Object[]> mapParam, WebGisDialog wgDlg) throws Exception {
        int filterType = ActionParameterUtils.readFirstValueInteger(mapParam.get(PARAM_FILTER_TYPE), 1);
        return this.getFilter(mapParam, wgDlg, filterType);
    }

    private String[] getFilter(Map<String, Object[]> mapParam, WebGisDialog wgDlg, int filterType) throws Exception {
        String[] arrFilter = StringUtils.split((String)GeometryAction.retrieveParameterString(mapParam, "filter", ""), (String)"|");
        if (arrFilter.length == 0) {
            switch (filterType) {
                case 1: {
                    arrFilter = wgDlg.getFilter();
                    break;
                }
                case 3: {
                    arrFilter = new String[]{wgDlg.getSelectedInFilter()};
                    break;
                }
                default: {
                    throw new SystemException(GeometryAction.class, "invalid filter type (1,3)");
                }
            }
        }
        return arrFilter;
    }

    private void resetFidFilter(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        WebGisDialog wgDlg = this.getWebGisDialog(mapParam);
        String[] arrLayers = wgDlg.getDialogMap().getLinkedLayerIDs();
        MapContext mapctx = activeMap;
        mapctx.resetFIDFilter(arrLayers);
        this.requestFocusForLinux(mapApp);
        this.clearSelectionIfSpecified(mapParam, activeMap);
    }

    private void layerAddGeometry(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        Object[] objLayers = mapParam.get("layers");
        Object[] objFid = mapParam.get("fid");
        String[] arrLayers = (String[])objLayers;
        String strFID = ((String[])objFid)[0];
        if (arrLayers.length == 0) {
            GUISupport.msgbox((Component)mapApp.getFrame(), (String)"No layers for geometry creation found in dialog.xdlg", (String)i18n.get("common.message"));
        } else {
            boolean bolLayerFound = false;
            boolean bolSuccess = false;
            for (String arrLayer : arrLayers) {
                VectorLayerContext ly = (VectorLayerContext)activeMap.getMapLayer(arrLayer);
                if (ly == null || !ly.isEditable()) continue;
                bolLayerFound = true;
                boolean isGeometryAdded = ly.addGeometry(strFID);
                if (!isGeometryAdded) continue;
                bolSuccess = true;
                if (ly.isVisible()) break;
                ly.setVisible(true);
                break;
            }
            if (!bolLayerFound) {
                GUISupport.msgbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.error-dbparser-no-layer-found"), (String)i18n.get("common.error"));
            } else if (!bolSuccess) {
                GUISupport.msgbox((Component)mapApp.getFrame(), (String)i18n.get("servlet.actions.GeometryAction.error-dbparser-addgeometry"), (String)i18n.get("common.error"));
            }
        }
    }

    private void jumpTo(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        String wkt;
        Integer epsg = ActionParameterUtils.readFirstValueInteger(mapParam.get("epsg"), ActionSupport.getProjectEPSG());
        Geometry geom = ActionSupport.readWKT(epsg, wkt = ActionParameterUtils.readFirstValueString(mapParam.get("wkt"), null));
        if (geom != null) {
            Double minScale = ActionParameterUtils.readFirstValueDouble(mapParam.get("scale"), activeMap.getScale());
            activeMap.zoomGeometry(geom, minScale.doubleValue(), null, "EPSG:" + epsg);
        }
    }

    private void addPoint(Map<String, Object[]> mapParam, MapAppContext mapApp, MapContext activeMap) throws Exception {
        String wkt;
        Integer epsg = ActionParameterUtils.readFirstValueInteger(mapParam.get("epsg"), ActionSupport.getProjectEPSG());
        Geometry geom = ActionSupport.readWKT(epsg, wkt = ActionParameterUtils.readFirstValueString(mapParam.get("wkt"), null));
        if (geom != null) {
            activeMap.addGeometry(geom, epsg);
        }
    }

    @FunctionalInterface
    private static interface GeometryActionFunction {
        public void run(Map<String, Object[]> var1, MapAppContext var2, MapContext var3) throws Exception;
    }
}

