/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.OverlayFeatureDef;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.util.ActionSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;

public class GenericOverlayAction
extends AbstractAsyncAction {
    protected static final BasicStroke DEFAULT_STROKE = new BasicStroke();

    @Override
    public String getName() {
        return "GenericOverlay";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strAction = ActionParameterUtils.readFirstValueString(mapParam.get("action"), "open");
            String featureID = ActionParameterUtils.readFirstValueString(mapParam.get("overlayID"), null);
            Integer epsg = ActionParameterUtils.readFirstValueInteger(mapParam.get("epsg"), ActionSupport.getProjectEPSG());
            String wkt = ActionParameterUtils.readFirstValueString(mapParam.get("wkt"), null);
            Geometry geom = ActionSupport.readWKT(epsg, wkt);
            switch (Objects.requireNonNull(strAction)) {
                case "setVisible": {
                    Boolean isVisible = ActionParameterUtils.readFirstValueBoolean(mapParam.get("visibility"), true);
                    if (isVisible != null) {
                        WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().setOverlayFeatureVisible(featureID, isVisible.booleanValue());
                        this.updateGraphics();
                    }
                    break;
                }
                case "addFeature": {
                    String symbol = ActionParameterUtils.readFirstValueString(mapParam.get("symbol"), null);
                    Integer symbolSize = ActionParameterUtils.readFirstValueInteger(mapParam.get("symbolsize"), 20);
                    Double orientation = ActionParameterUtils.readFirstValueDouble(mapParam.get("orientation"), 0.0);
                    String lineColorStr = ActionParameterUtils.readFirstValueString(mapParam.get("lineColor"), "#404040");
                    String fillColorStr = ActionParameterUtils.readFirstValueString(mapParam.get("fillColor"), "#404040");
                    Integer transparentPercent = ActionParameterUtils.readFirstValueInteger(mapParam.get("transparent"), 100);
                    Color lineColor = GenericOverlayAction.transparent(Color.decode(lineColorStr), transparentPercent);
                    Color fillColor = GenericOverlayAction.transparent(Color.decode(fillColorStr), transparentPercent);
                    OverlayFeatureDef newFt = new OverlayFeatureDef(geom, (Stroke)DEFAULT_STROKE, lineColor, (Stroke)DEFAULT_STROKE, fillColor, epsg, symbol, symbolSize, orientation);
                    WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().addOverlayFeature(featureID, newFt);
                    this.updateGraphics();
                    break;
                }
                case "removeFeature": {
                    WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().removeOverlayFeature(featureID);
                    this.updateGraphics();
                    break;
                }
                default: {
                    throw new Exception(String.format("action '%s' not found.", strAction));
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
        }
    }

    protected void updateGraphics() throws Exception {
        MapContext activeMap = WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap();
        if (activeMap != null) {
            activeMap.refreshLayerViewPanel();
        }
    }

    public static final Color transparent(Color color, float transparency) {
        if (transparency < 0.0f) {
            throw new IllegalArgumentException("transparency must be 0.0 or greater.");
        }
        float[] x = color.getRGBComponents(new float[4]);
        return new Color(x[0], x[1], x[2], Math.min(1.0f, x[3] * transparency));
    }

    public static final Color transparent(Color color, int transparency) {
        return GenericOverlayAction.transparent(color, (float)transparency / 100.0f);
    }
}

