/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSDocumentDesc;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DMSSupport;
import de.riwagis.dms.ui.DMSDocumentEditorDialog;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserInsertUploadDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserUploadDialog;
import de.riwagis.webgiscli.module.dialog.gui.DMSEventType;
import de.riwagis.webgiscli.module.dialog.gui.FileSavedDialog;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOnServerAction
extends AbstractAsyncAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileOnServerAction.class);
    private static final String ACTION_DBPARSER = "dbparser";
    private static final String ACTION_SHOW = "dbparser_show";
    private static final String ACTION_INSERT = "dbparser_insert";
    private static final String ACTION_UPDATE = "dbparser_upload";
    private static final String ACTION_SAVE = "dbparser_save";
    private static final String ACTION_SERVERFILE = "serverfile";
    private static final String ACTION_SERVERFILE_SHOW = "serverfile_show";
    private static final String ACTION_SERVERFILE_SAVE = "serverfile_save";
    private static final String KEY_LASTSAVEFILE = String.valueOf(FileOnServerAction.class) + "_LastSaveFileDir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "FileOnServer";
    }

    private File getExportFile(String strName, int intCount) {
        File expFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), (String)(intCount == 0 ? "" : intCount + "_") + strName);
        if (expFile.exists()) {
            return this.getExportFile(strName, intCount + 1);
        }
        return expFile;
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strAction = FileOnServerAction.retrieveParameterString(mapParam, "action");
            WebGisContext wgContext = this.getWgContext();
            if (strAction.startsWith(ACTION_DBPARSER)) {
                this.handleDbparserActions(mapParam, strAction, wgContext);
            } else if (strAction.startsWith(ACTION_SERVERFILE)) {
                this.handleServerFileActions(mapParam, strAction, wgContext);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getFocusedOrMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private void handleServerFileActions(Map<String, Object[]> mapParam, String strAction, WebGisContext wgContext) {
        Object[] objUrl = mapParam.get("url");
        if (objUrl == null) {
            return;
        }
        String strUrl = ((String[])objUrl)[0];
        if (StringUtils.isBlank((String)strUrl)) {
            return;
        }
        Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
        File lastSaveFileDir = new File(wb.getAttribute(KEY_LASTSAVEFILE, (Object)"").toString());
        HttpServiceProvider svcProv = (HttpServiceProvider)wgContext.getServiceProvider();
        HttpGet htmlGet = new HttpGet(svcProv.getURL() + strUrl);
        String strFilename = FilenameUtils.getName((String)strUrl.split("\\?")[0]);
        File selFile = this.getExportFile(strFilename, 0);
        Window parent = this.getFocusedOrMainWindow();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)i18n.get("servlet.actions.FileOpenAction.wait"), () -> {});
        switch (strAction) {
            case "serverfile_save": {
                this.executeServerFileSave(svcProv, htmlGet, selFile, lastSaveFileDir, strFilename, wb, dlgWait);
                break;
            }
            case "serverfile_show": {
                this.executeServerFileShow(svcProv, htmlGet, selFile, dlgWait);
                break;
            }
            default: {
                log.error("FileOnServerAction - invalid action: " + strAction);
                ExceptionDialog.handleGuiException((Component)parent, (Throwable)new Exception("Error - invalid action: " + strAction), (String)"webgiscli");
            }
        }
        dlgWait.setVisible(true);
        htmlGet.releaseConnection();
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parent, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void handleDbparserActions(Map<String, Object[]> mapParam, String strAction, WebGisContext wgContext) throws Exception {
        String objDialogId = FileOnServerAction.retrieveParameterString(mapParam, "dbparserid");
        String objModuleId = FileOnServerAction.retrieveParameterString(mapParam, "dbparsermodule");
        String objFieldId = FileOnServerAction.retrieveParameterString(mapParam, "dbparserfield");
        String strID = FileOnServerAction.retrieveParameterString(mapParam, "filterid", null);
        String linkTarget = FileOnServerAction.retrieveParameterString(mapParam, "link_target", null);
        String linkValue = FileOnServerAction.retrieveParameterString(mapParam, "link_value", null);
        String strUploadInfo = FileOnServerAction.retrieveParameterString(mapParam, "uploadinfo", null);
        if (StringUtils.isBlank((String)objDialogId) || StringUtils.isBlank((String)objModuleId) || StringUtils.isBlank((String)objFieldId)) {
            throw new Exception("Invalid Parameters");
        }
        int intDlgKey = Integer.parseInt(objDialogId);
        int intModKey = Integer.parseInt(objModuleId);
        int intFieldKey = Integer.parseInt(objFieldId);
        WebGisModule wgMod = wgContext.getModule(intModKey);
        WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(intDlgKey);
        Map<String, ?> mapInfo = strUploadInfo != null ? FileOnServerAction.parseUploadInfo(strUploadInfo) : wgDlg.getUploadInfo(intFieldKey, strID);
        switch (strAction) {
            case "dbparser_upload": {
                this.executeUpdate(wgContext, wgDlg, intDlgKey, intFieldKey, mapInfo);
                break;
            }
            case "dbparser_insert": {
                this.executeInsert(wgContext, wgDlg, intDlgKey, intFieldKey, mapInfo, linkTarget, linkValue);
                break;
            }
            case "dbparser_show": {
                this.executeShow(mapInfo, wgContext, wgDlg, strID);
                break;
            }
            case "dbparser_save": {
                this.executeSave(mapInfo, wgContext, wgDlg, strID);
                break;
            }
        }
    }

    public static Map<String, ?> parseUploadInfo(String strUploadInfo) throws JsonSyntaxException {
        Map mapInfoTmp = (Map)new Gson().fromJson(strUploadInfo, Object.class);
        for (String key : mapInfoTmp.keySet()) {
            Object v = mapInfoTmp.get(key);
            if (!(v instanceof Double)) continue;
            Double aDouble = (Double)v;
            mapInfoTmp.put(key, aDouble.intValue());
        }
        return mapInfoTmp;
    }

    private void executeServerFileShow(HttpServiceProvider svcProv, HttpGet htmlGet, File selFile, WaitDialog dlgWait) {
        Runnable work = () -> {
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = svcProv.execMethod((HttpUriRequest)htmlGet);
                int intStatus = httpResponse.getStatusLine().getStatusCode();
                if (intStatus != 200) {
                    String strError = HttpServiceProvider.retrieveErrorMessage(httpResponse);
                    throw new Exception("Error status: " + intStatus + " " + strError);
                }
                FileStreamProcessor fproc = new FileStreamProcessor(selFile);
                File expFile = (File)fproc.processStream(httpResponse.getEntity().getContent());
                OSFile.showFile((File)expFile, (boolean)true);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
            finally {
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    IOUtils.closeQuietly((Closeable)httpResponse);
                }
            }
        };
        dlgWait.addWorkToDo(work);
    }

    private void executeServerFileSave(HttpServiceProvider svcProv, HttpGet htmlGet, File selFile, File lastSaveFileDir, String strFilename, Whiteboard wb, WaitDialog dlgWait) {
        Runnable work = () -> {
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = svcProv.execMethod((HttpUriRequest)htmlGet);
                int intStatus = httpResponse.getStatusLine().getStatusCode();
                if (intStatus != 200) {
                    String strError = HttpServiceProvider.retrieveErrorMessage(httpResponse);
                    throw new Exception("Error status: " + intStatus + " " + strError);
                }
                FileStreamProcessor fproc = new FileStreamProcessor(selFile);
                File expFile = (File)fproc.processStream(httpResponse.getEntity().getContent());
                JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
                FileFilter ff = GUISupport.createFileFilter((String)"File", (String[])new String[]{FilenameUtils.getExtension((String)expFile.toString())});
                fChoose.setFileFilter(ff);
                File preSelFile = lastSaveFileDir;
                if (!preSelFile.isDirectory()) {
                    preSelFile = preSelFile.getParentFile();
                }
                fChoose.setSelectedFile(new File(preSelFile, strFilename));
                int intOption = fChoose.showSaveDialog(null);
                if (intOption == 1) {
                    return;
                }
                File newFile = fChoose.getSelectedFile();
                try {
                    FileSupport.moveFile((File)expFile, (File)newFile);
                }
                catch (Exception e1) {
                    log.error(e1.getLocalizedMessage(), (Throwable)e1);
                }
                wb.setAttribute(KEY_LASTSAVEFILE, (Object)newFile.getParent());
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
            finally {
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    IOUtils.closeQuietly((Closeable)httpResponse);
                }
            }
        };
        dlgWait.addWorkToDo(work);
    }

    private void executeSave(Map<String, ?> mapInfo, WebGisContext wgContext, WebGisDialog wgDlg, String strID) throws Exception {
        boolean bolExists = (Boolean)mapInfo.get("existing_file");
        if (!bolExists) {
            throw new Exception("There is no existing file on the server");
        }
        String strFileOnServer = (String)mapInfo.get("filename");
        String strFileName = FilenameUtils.getName((String)strFileOnServer);
        Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
        File lastSaveFileDir = new File(wb.getAttribute(KEY_LASTSAVEFILE, (Object)"").toString());
        File selFile = this.getExportFile(strFileName, 0);
        Window parent = this.getFocusedOrMainWindow();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)i18n.get("servlet.actions.FileOpenAction.wait"), () -> {});
        Runnable work = () -> {
            try {
                ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("module_key", wgDlg.getModuleKey());
                params.put("dialog_key", wgDlg.getKey());
                params.put("field_key", mapInfo.get("key"));
                params.put("filter_id", strID);
                ServiceRequest req = dlgFileService.createRequest("get_file", params);
                req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(selFile));
                File expFile = (File)wgContext.getServiceProvider().execRequest(req).getResult();
                String extension = FilenameUtils.getExtension((String)expFile.toString());
                File preSelDirectory = lastSaveFileDir.isDirectory() ? lastSaveFileDir : lastSaveFileDir.getParentFile();
                File newFile = GUISupport.saveFile((Component)dlgWait, (String)"Datei speichern unter ...", (String)extension, (File)new File(preSelDirectory, strFileName), (boolean)false);
                if (newFile != null) {
                    try {
                        FileSupport.moveFile((File)expFile, (File)newFile);
                        wb.setAttribute(KEY_LASTSAVEFILE, (Object)newFile.getParent());
                        FileSavedDialog.notifyFileSaved((Window)dlgWait, newFile);
                    }
                    catch (Exception e1) {
                        JOptionPane.showConfirmDialog((Component)dlgWait, String.format("Fehler beim Speichern der Datei '%s'.\nFehlermeldung: '%s'", newFile, e1.getMessage()), "Datei gepeichert", 0, 3);
                        log.error(e1.getLocalizedMessage(), (Throwable)e1);
                    }
                }
            }
            catch (ServiceException | HeadlessException e) {
                dlgWait.setError((Exception)e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parent, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void executeShow(Map<String, ?> mapInfo, WebGisContext wgContext, WebGisDialog wgDlg, String strID) throws Exception {
        String strFileOnServer = (String)mapInfo.get("filename");
        String strFileName = FilenameUtils.getName((String)strFileOnServer);
        if (strFileOnServer.startsWith("file://")) {
            boolean bolExists = (Boolean)mapInfo.get("existing_file");
            if (!bolExists) {
                throw new Exception("There is no link saved.");
            }
            String strFile = StringUtils.removeStart((String)strFileOnServer, (String)"file://");
            if (DBParserUploadDialog.isExternalLink(strFile)) {
                BrowserSupport.openBrowser((String)strFile);
            } else {
                File linkFile = new File(strFile);
                if (!linkFile.exists()) {
                    throw new Exception(String.format("the linked file '%s' does not exist any more.", strFile));
                }
                OSFile.showFile((File)linkFile, (boolean)false);
            }
        } else {
            Window parent = this.getFocusedOrMainWindow();
            if (DMSSupport.isLinkedToDMS((String)strFileOnServer)) {
                WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)i18n.get("servlet.actions.FileOpenAction.wait"));
                dlgWait.addWorkToDo(() -> {
                    try {
                        DMSInterface dMSInterface = FileOnServerAction.createDmsInterface(wgContext);
                        DMSDocument d = DMSDocument.parseURI((String)strFileOnServer);
                        if (dMSInterface != null && d != null) {
                            dMSInterface.showByID(d, mapInfo, wgDlg.getModuleKey());
                        }
                    }
                    catch (DMSException ex) {
                        dlgWait.setError((Exception)((Object)ex));
                    }
                });
                dlgWait.setVisible(true);
                if (dlgWait.getError() != null) {
                    ExceptionDialog.handleGuiException((Component)parent, (Throwable)dlgWait.getError(), (String)"webgiscli");
                }
            } else {
                boolean bolExists = (Boolean)mapInfo.get("existing_file");
                if (!bolExists) {
                    throw new Exception("There is no existing file on the server");
                }
                File selFile = this.getExportFile(strFileName, 0);
                WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)i18n.get("servlet.actions.FileOpenAction.wait"));
                Runnable work = () -> {
                    try {
                        ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("module_key", wgDlg.getModuleKey());
                        params.put("dialog_key", wgDlg.getKey());
                        params.put("field_key", mapInfo.get("key"));
                        params.put("filter_id", strID);
                        ServiceRequest req = dlgFileService.createRequest("get_file", params);
                        req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(selFile));
                        File expFile = (File)wgContext.getServiceProvider().execRequest(req).getResult();
                        OSFile.showFile((File)expFile, (boolean)true);
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                };
                dlgWait.addWorkToDo(work);
                dlgWait.setVisible(true);
                if (dlgWait.getError() != null) {
                    ExceptionDialog.handleGuiException((Component)parent, (Throwable)dlgWait.getError(), (String)"webgiscli");
                }
            }
        }
    }

    private void executeInsert(WebGisContext wgContext, WebGisDialog wgDlg, int intDlgKey, int intFieldKey, Map<String, ?> mapInfo, String linkTarget, String linkValue) throws SystemException, HeadlessException, IOException, DMSException {
        Window parentWindow = this.getFocusedOrMainWindow();
        DBParserInsertUploadDialog clientInsertWithFileDialog = new DBParserInsertUploadDialog(parentWindow);
        clientInsertWithFileDialog.addActionListener(e -> {
            try {
                DMSDocumentDesc newDMSDocumentDesc;
                Map<String, ?> currMapInfo = clientInsertWithFileDialog.getMapInfo();
                Map<String, String> metaDataDMS = FileOnServerAction.readDMSMetaData(currMapInfo, "dmsmetadata.parent", "dmsmetadata.static");
                DMSInterface dMSInterface = FileOnServerAction.createDmsInterface(wgContext);
                if (dMSInterface == null) {
                    return;
                }
                String originKey = FileOnServerAction.computeOriginKey(dMSInterface, wgDlg.getModuleKey(), intDlgKey, intFieldKey);
                if (StringUtils.equalsIgnoreCase((String)DMSEventType.INSERT.getCommand(), (String)e.getActionCommand())) {
                    File prevFileStr = wgContext.getPermWhiteboard().getFileAttribute("prevDMSFile", null);
                    FileFilter[] ff = new FileFilter[]{DBParserUploadDialog.createFileFilter(clientInsertWithFileDialog.getMapInfo())};
                    File[] newFiles = GUISupport.chooseFile((Component)clientInsertWithFileDialog, (String)"Datei w\u00e4hlen", (FileFilter[])ff, (File)prevFileStr, (boolean)true, (boolean)true);
                    if (newFiles != null && newFiles.length > 0) {
                        wgContext.getPermWhiteboard().setFileAttribute("prevDMSFile", newFiles[0]);
                        clientInsertWithFileDialog.setDeferredInsertAction(file -> dMSInterface.insertToDMS(originKey, file, metaDataDMS, currMapInfo, wgDlg.getModuleKey()));
                        for (File newFile : newFiles) {
                            clientInsertWithFileDialog.addDeferredLink(newFile);
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase((String)DMSEventType.SELECT.getCommand(), (String)e.getActionCommand())) {
                    DMSDocument newDMSDocument = dMSInterface.attachFromDMS(originKey, metaDataDMS);
                    clientInsertWithFileDialog.addLink(newDMSDocument);
                } else if (StringUtils.equalsIgnoreCase((String)DMSEventType.INPUT.getCommand(), (String)e.getActionCommand()) && (newDMSDocumentDesc = DMSDocumentEditorDialog.inputDocumentDesc((Window)clientInsertWithFileDialog)) != null) {
                    DMSDocument newDMSDocument = new DMSDocument(dMSInterface.getDMSInterface(), newDMSDocumentDesc, originKey);
                    clientInsertWithFileDialog.addLink(newDMSDocument);
                }
            }
            catch (DMSException ex) {
                ExceptionDialog.handleGuiException((Component)clientInsertWithFileDialog, (Exception)((Object)ex), this.getClass());
            }
        });
        DMSInterface dmsInterface = FileOnServerAction.createDmsInterface(wgContext);
        clientInsertWithFileDialog.setLink(linkTarget, linkValue);
        clientInsertWithFileDialog.setDialog(wgDlg, mapInfo);
        clientInsertWithFileDialog.setDMSSystem(dmsInterface);
        clientInsertWithFileDialog.setLocationRelativeTo(parentWindow);
        clientInsertWithFileDialog.setVisible(true);
    }

    public void executeUpdate(WebGisContext wgContext, WebGisDialog wgDlg, int intDlgKey, int intFieldKey, Map<String, ?> mapInfo) throws SystemException, IOException, DMSException {
        Window parentWindow = this.getFocusedOrMainWindow();
        DBParserUploadDialog clientFileDialog = new DBParserUploadDialog(parentWindow);
        clientFileDialog.addActionListener(e -> {
            try {
                DMSDocumentDesc newDMSDocumentDesc;
                Map<String, ?> currMapInfo = clientFileDialog.getMapInfo();
                Map<String, String> metaDataDMS = FileOnServerAction.readDMSMetaData(currMapInfo, "dmsmetadata", "dmsmetadata.parent", "dmsmetadata.static");
                DMSInterface dMSInterface = FileOnServerAction.createDmsInterface(wgContext);
                if (dMSInterface == null) {
                    return;
                }
                String originKey = FileOnServerAction.computeOriginKey(dMSInterface, wgDlg.getModuleKey(), intDlgKey, intFieldKey);
                if (StringUtils.equalsIgnoreCase((String)DMSEventType.INSERT.getCommand(), (String)e.getActionCommand())) {
                    File prevFileStr = wgContext.getPermWhiteboard().getFileAttribute("prevDMSFile", null);
                    FileFilter[] ff = new FileFilter[]{DBParserUploadDialog.createFileFilter(currMapInfo)};
                    File newFile = GUISupport.chooseSingleFile((Component)clientFileDialog, (String)"Datei w\u00e4hlen", (FileFilter[])ff, (File)prevFileStr, (boolean)true);
                    if (newFile != null) {
                        wgContext.getPermWhiteboard().setFileAttribute("prevDMSFile", newFile);
                        clientFileDialog.setDmsTemporaryDocumentLabel(newFile);
                        clientFileDialog.setDeferredSaveAction(() -> dMSInterface.insertToDMS(originKey, newFile, metaDataDMS, currMapInfo, wgDlg.getModuleKey()));
                    }
                } else if (StringUtils.equalsIgnoreCase((String)DMSEventType.SELECT.getCommand(), (String)e.getActionCommand())) {
                    DMSDocument newDMSDocument = dMSInterface.attachFromDMS(originKey, metaDataDMS);
                    clientFileDialog.setDMSID(newDMSDocument);
                } else if (StringUtils.equalsIgnoreCase((String)DMSEventType.INPUT.getCommand(), (String)e.getActionCommand()) && (newDMSDocumentDesc = DMSDocumentEditorDialog.inputDocumentDesc((Window)clientFileDialog)) != null) {
                    DMSDocument newDMSDocument = new DMSDocument(dMSInterface.getDMSInterface(), newDMSDocumentDesc, originKey);
                    clientFileDialog.setDMSID(newDMSDocument);
                }
            }
            catch (DMSException ex) {
                ExceptionDialog.handleGuiException((Component)clientFileDialog, (Exception)((Object)ex), this.getClass());
            }
        });
        clientFileDialog.setDialog(wgDlg, mapInfo);
        DMSInterface dmsInterface = FileOnServerAction.createDmsInterface(wgContext);
        clientFileDialog.setDMSSystem(dmsInterface);
        clientFileDialog.setLocationRelativeTo(parentWindow);
        clientFileDialog.setVisible(true);
    }

    public static Map<String, String> readDMSMetaData(Map<String, ?> currMapInfo, String ... metadataKeys) {
        LinkedHashMap<String, String> metaDataDMS = new LinkedHashMap<String, String>();
        for (String currMetadataKey : metadataKeys) {
            if (!currMapInfo.containsKey(currMetadataKey)) continue;
            Map currEntry = (Map)currMapInfo.get(currMetadataKey);
            metaDataDMS.putAll(currEntry);
        }
        return metaDataDMS;
    }

    public static String computeOriginKey(DMSInterface dMSInterface, int moduleKey, int dialogKey, int fieldKey) {
        return dMSInterface.computeOriginKey(moduleKey, dialogKey, Integer.valueOf(fieldKey));
    }

    public static DMSInterface createDmsInterface(WebGisContext wgContext) throws DMSException {
        File configFileDir = wgContext.getWebGisClient().getConfigFile().getParentFile();
        File wgClientDir = DirectoryService.getInstance().getProjectDirectory(ProjectType.WG_CLIENT);
        return DMSSupport.createCurrentDMS((File)configFileDir, (File)wgClientDir);
    }
}

