/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.browser.WindowManager;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DMSSupport;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.OSFile;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserInsertLinkDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserLinkDialog;
import de.riwagis.webgiscli.module.gui.FileLinkDialog;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.net.URLEncoder;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileLinkAction
extends AbstractAsyncAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileLinkAction.class);
    private static final String ACTION_SHOW = "dbparser_showlink";
    private static final String ACTION_INSERT = "dbparser_insertlink";
    private static final String ACTION_UPDATE = "dbparser_link";

    @Override
    public String getName() {
        return "FileLink";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strFile;
            String strAction = FileLinkAction.retrieveParameterString(mapParam, "action");
            WebGisContext wgContext = this.getWgContext();
            if (strAction.startsWith("dbparser")) {
                String objDialogId = FileLinkAction.retrieveParameterString(mapParam, "dbparserid");
                String objModuleId = FileLinkAction.retrieveParameterString(mapParam, "dbparsermodule");
                String objFieldId = FileLinkAction.retrieveParameterString(mapParam, "dbparserfield");
                String strID = FileLinkAction.retrieveParameterString(mapParam, "filterid", "");
                if (StringUtils.isBlank((String)objDialogId) || StringUtils.isBlank((String)objModuleId) || StringUtils.isBlank((String)objFieldId)) {
                    throw new Exception("Invalid Parameters");
                }
                int intDlgKey = Integer.parseInt(objDialogId);
                int intModKey = Integer.parseInt(objModuleId);
                int intFieldKey = Integer.parseInt(objFieldId);
                WebGisModule wgMod = wgContext.getModule(intModKey);
                WebGisDialog wgDlg = (WebGisDialog)wgMod.getDialog(intDlgKey);
                Map<String, ?> mapInfo = wgDlg.getLinkInfo(intFieldKey, strID);
                switch (strAction) {
                    case "dbparser_link": {
                        Window parentWindow = this.getFocusedOrMainWindow();
                        DBParserLinkDialog clientFileDialog = new DBParserLinkDialog(parentWindow);
                        clientFileDialog.setDialog(wgDlg, mapInfo);
                        clientFileDialog.setLocationRelativeTo(parentWindow);
                        clientFileDialog.setVisible(true);
                        break;
                    }
                    case "dbparser_insertlink": {
                        Window parentWindow = this.getFocusedOrMainWindow();
                        DBParserInsertLinkDialog dlgInsert = new DBParserInsertLinkDialog(parentWindow);
                        dlgInsert.setDialog(wgDlg, mapInfo);
                        dlgInsert.setLocationRelativeTo(parentWindow);
                        dlgInsert.setVisible(true);
                        break;
                    }
                    case "dbparser_showlink": {
                        if (!((Boolean)mapInfo.get("existing_link")).booleanValue()) {
                            throw new Exception("There is no link saved.");
                        }
                        String strFile2 = (String)mapInfo.get("filename");
                        if (!StringUtils.isNotBlank((String)strFile2)) break;
                        this.openFile(strFile2);
                    }
                }
            } else if (strAction.equals("jsp_link")) {
                String strURL = FileLinkAction.retrieveParameterString(mapParam, "url");
                if (StringUtils.isBlank((String)strURL)) {
                    throw new Exception("Invalid Parameters");
                }
                String strLink = FileLinkAction.retrieveParameterString(mapParam, "link");
                String[] arrFilter = StringUtils.split((String)FileLinkAction.retrieveParameterString(mapParam, "filter", ""));
                int intWidth = Integer.parseInt(FileLinkAction.retrieveParameterString(mapParam, "width", "10"));
                int intHeight = Integer.parseInt(FileLinkAction.retrieveParameterString(mapParam, "height", "10"));
                Window parentWindow = this.getFocusedOrMainWindow();
                FileLinkDialog dlgFileLink = new FileLinkDialog(parentWindow, wgContext);
                dlgFileLink.setLink(strLink, arrFilter);
                dlgFileLink.setLocationRelativeTo(parentWindow);
                dlgFileLink.setVisible(true);
                if (dlgFileLink.wasOKPressed()) {
                    String tmpLink = dlgFileLink.getLink();
                    String resURL = strURL.indexOf(63) != -1 ? strURL + "&link=" + URLEncoder.encode(tmpLink, "UTF-8") : strURL + "?link=" + URLEncoder.encode(tmpLink, "UTF-8");
                    WindowManager.getInstance().openWindow(resURL, "win_filelink", intWidth, intHeight);
                }
            } else if (strAction.equals("jsp_showlink") && StringUtils.isNotBlank((String)(strFile = FileLinkAction.retrieveParameterString(mapParam, "link", "")))) {
                this.openFile(strFile);
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openFile(String strFile) throws Exception {
        if (strFile.toLowerCase().startsWith("http")) {
            BrowserSupport.openBrowser((String)strFile);
            return;
        } else if (DMSSupport.isLinkedToDMS((String)strFile)) {
            File configFileDir = this.getWgContext().getWebGisClient().getConfigFile().getParentFile();
            try (DMSInterface dMSInterface = DMSSupport.createCurrentDMS((File)configFileDir, (File)DirectoryService.getInstance().getProjectDirectory(ProjectType.WG_CLIENT));){
                DMSDocument d = DMSDocument.parseURI((String)strFile);
                if (dMSInterface == null || d == null) return;
                dMSInterface.showByID(d, null, -1);
                return;
            }
        } else {
            File linkFile = new File(strFile);
            if (!linkFile.exists()) {
                throw new Exception(String.format("the linked file '%s' does not exist any more.", strFile));
            }
            OSFile.showFile((File)linkFile, (boolean)false);
        }
    }
}

