/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import com.google.gson.Gson;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.AbstractHtmlSPWG;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import de.riwagis.webgiscli.module.gui.FileLinkDialog;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandlingAction
extends AbstractAsyncAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileHandlingAction.class);
    private static final String ACTION_UPLOAD = "dbparser_uploadfile";
    private static final String ACTION_DOWNLOAD = "dbparser_downloadfile";
    private static final String ACTION_MODIFY = "dbparser_modifyfile";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_LASTSAVEFILE = String.valueOf(FileHandlingAction.class) + "_LastSaveFileDir";

    @Override
    public String getName() {
        return "FileHandling";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            String strAction = FileHandlingAction.retrieveParameterString(mapParam, "action");
            WebGisContext wgContext = this.getWgContext();
            String objModuleId = FileHandlingAction.retrieveParameterString(mapParam, "dbparsermodule");
            String objDialogId = FileHandlingAction.retrieveParameterString(mapParam, "dialogId");
            String objMethod = FileHandlingAction.retrieveParameterString(mapParam, "method");
            String objParameters = FileHandlingAction.retrieveParameterString(mapParam, "parameters");
            String objFileFilter = FileHandlingAction.retrieveParameterString(mapParam, "filefilter");
            String objUrl = FileHandlingAction.retrieveParameterString(mapParam, "url");
            if (StringUtils.isBlank((CharSequence)objModuleId) || StringUtils.isBlank((CharSequence)objDialogId) || StringUtils.isBlank((CharSequence)objMethod) || StringUtils.isBlank((CharSequence)objParameters) || StringUtils.isBlank((CharSequence)objUrl)) {
                throw new IllegalArgumentException("Parameters are not allowed to be null");
            }
            int intModKey = Integer.parseInt(objModuleId);
            int intDlgKey = Integer.parseInt(objDialogId);
            String[] fileFilter = StringUtils.isNotBlank((CharSequence)objFileFilter) ? objFileFilter.split(",") : null;
            WebGisModule wgMod = wgContext.getModule(intModKey);
            DialogContext wgDlg = wgMod.getDialog(intDlgKey);
            if (!(wgDlg instanceof AbstractHtmlSPWG)) {
                throw new IllegalArgumentException("Only HtmlSPWG Dialogs are supported!");
            }
            AbstractHtmlSPWG dialog = (AbstractHtmlSPWG)wgDlg;
            switch (strAction) {
                case "dbparser_uploadfile": {
                    this.doUpload(wgContext, objDialogId, objParameters, objUrl, dialog, fileFilter);
                    break;
                }
                case "dbparser_downloadfile": {
                    this.doDownload(mapParam, wgContext, objDialogId, dialog, objMethod, objParameters, objUrl);
                    break;
                }
                case "dbparser_modifyfile": {
                    this.doModify(mapParam, wgContext, objMethod, objParameters, objUrl, fileFilter);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown file action '" + strAction + "'");
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private void doUpload(WebGisContext wgContext, String objDialogId, String objParameters, String objDestination, AbstractHtmlSPWG dialog, String[] fileFilter) throws SystemException, IOException {
        String selectedFile = this.selectFile(wgContext, fileFilter);
        HashMap<String, Object> messageContent = new HashMap<String, Object>();
        if (selectedFile == null || StringUtils.isBlank((CharSequence)selectedFile)) {
            log.warn("File selection canceled (FileHandlingAction).");
            messageContent.put("success", false);
            messageContent.put("message", i18n.get("servlet.actions.FileHandlingAction.file-upload-cancel"));
            dialog.sendMessage(new SPMessage(objDialogId, "onAfterUploadFile", String.format("[%s]", new Gson().toJson(messageContent))));
            return;
        }
        CloseableHttpResponse response = this.uploadFile(wgContext, objDestination, objParameters, selectedFile);
        messageContent.put("success", true);
        messageContent.put("message", EntityUtils.toString((HttpEntity)response.getEntity()));
        dialog.sendMessage(new SPMessage(objDialogId, "onAfterUploadFile", String.format("[%s]", new Gson().toJson(messageContent))));
    }

    private void doDownload(Map<String, Object[]> mapParam, WebGisContext wgContext, String objDialogId, AbstractHtmlSPWG dialog, String objMethod, String objParameters, String objUrl) throws SystemException, IOException {
        CloseableHttpResponse response;
        String filename = FileHandlingAction.retrieveParameterString(mapParam, "filename");
        Boolean showFile = Boolean.parseBoolean(FileHandlingAction.retrieveParameterString(mapParam, "showfile"));
        if (filename == null || StringUtils.isBlank((CharSequence)filename)) {
            filename = objMethod;
        }
        boolean success = (response = this.downloadFile(wgContext, objUrl, objParameters)).getStatusLine().getStatusCode() == 200;
        HashMap<String, Object> messageContent = new HashMap<String, Object>();
        messageContent.put("success", success);
        if (!success) {
            messageContent.put("message", EntityUtils.toString((HttpEntity)response.getEntity()));
        } else {
            this.saveFile(response, filename, showFile);
        }
        dialog.sendMessage(new SPMessage(objDialogId, "onAfterDownloadFile", String.format("[%s]", new Gson().toJson(messageContent))));
    }

    private void doModify(Map<String, Object[]> mapParam, WebGisContext wgContext, String objMethod, String objParameters, String objUrl, String[] fileFilter) throws SystemException, IOException {
        String selectedFile = this.selectFile(wgContext, fileFilter);
        if (selectedFile == null || StringUtils.isBlank((CharSequence)selectedFile)) {
            log.warn("File selection canceled (FileHandlingAction).");
            return;
        }
        String filename = FileHandlingAction.retrieveParameterString(mapParam, "filename");
        Boolean showFile = Boolean.parseBoolean(FileHandlingAction.retrieveParameterString(mapParam, "showfile"));
        if (filename == null || StringUtils.isBlank((CharSequence)filename)) {
            filename = objMethod;
        }
        CloseableHttpResponse response = this.uploadFile(wgContext, objUrl, objParameters, selectedFile);
        this.saveFile(response, filename, showFile);
    }

    private String selectFile(WebGisContext wgContext, String[] fileFilter) {
        Window parentWindow = this.getFocusedOrMainWindow();
        FileLinkDialog dlgFileLink = new FileLinkDialog(parentWindow, wgContext);
        dlgFileLink.setLocationRelativeTo(parentWindow);
        dlgFileLink.setSaveText(i18n.get("common.upload"));
        dlgFileLink.toggleDeleteButton(false);
        if (fileFilter != null) {
            dlgFileLink.setLink("", fileFilter);
        }
        dlgFileLink.setDialogTitle(i18n.get("module.gui.FileLinkDialog.titleUpload"));
        dlgFileLink.setVisible(true);
        if (dlgFileLink.wasOKPressed()) {
            return dlgFileLink.getLink();
        }
        return null;
    }

    private CloseableHttpResponse uploadFile(WebGisContext wgContext, String url, String parameters, String file) throws IOException, SystemException {
        HttpServiceProvider provider = (HttpServiceProvider)wgContext.getServiceProvider();
        HttpPost uploadFile = new HttpPost(String.format("%s%s", provider.getURL(), url));
        File f = new File(file);
        try (FileInputStream fis = new FileInputStream(f);){
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).addTextBody("customMethodParameters", parameters, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)).addTextBody("fileName", f.getName(), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)).addBinaryBody("file", (InputStream)fis, ContentType.APPLICATION_OCTET_STREAM, f.getName());
            HttpEntity multipart = builder.build();
            uploadFile.setEntity(multipart);
            CloseableHttpResponse closeableHttpResponse = provider.execMethod((HttpUriRequest)uploadFile);
            return closeableHttpResponse;
        }
    }

    private CloseableHttpResponse downloadFile(WebGisContext wgContext, String url, String parameters) throws SystemException {
        HttpServiceProvider provider = (HttpServiceProvider)wgContext.getServiceProvider();
        HttpPost downloadFile = new HttpPost(String.format("%s%s", provider.getURL(), url));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).addTextBody("customMethodParameters", parameters, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
        downloadFile.setEntity(builder.build());
        return provider.execMethod((HttpUriRequest)downloadFile);
    }

    private void saveFile(CloseableHttpResponse response, String filename, boolean showFile) throws IOException {
        Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
        File selectedFile = this.getExportFile(filename, 0);
        FileStreamProcessor fproc = new FileStreamProcessor(selectedFile);
        File expFile = (File)fproc.processStream(response.getEntity().getContent());
        JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
        fChoose.setDialogTitle(i18n.get("module.gui.FileLinkDialog.titleDownload"));
        fChoose.setApproveButtonText(i18n.get("common.save"));
        File lastSaveFileDir = new File(wb.getAttribute(KEY_LASTSAVEFILE, (Object)"").toString());
        FileFilter ff = GUISupport.createFileFilter((String)"File", (String[])new String[]{FilenameUtils.getExtension((String)expFile.toString())});
        fChoose.setFileFilter(ff);
        File preSelFile = lastSaveFileDir;
        if (!preSelFile.isDirectory()) {
            preSelFile = preSelFile.getParentFile();
        }
        fChoose.setSelectedFile(new File(preSelFile, filename));
        int intOption = fChoose.showSaveDialog(null);
        if (intOption == 1) {
            return;
        }
        File newFile = fChoose.getSelectedFile();
        try {
            FileSupport.moveFile((File)expFile, (File)newFile);
            if (showFile) {
                OSFile.showFile((File)newFile, (boolean)false);
            }
        }
        catch (Exception e1) {
            log.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        wb.setAttribute(KEY_LASTSAVEFILE, (Object)newFile.getParent());
    }

    private File getExportFile(String strName, int intCount) {
        File expFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), (String)(intCount == 0 ? "" : intCount + "_") + strName);
        if (expFile.exists()) {
            return this.getExportFile(strName, intCount + 1);
        }
        return expFile;
    }
}

