/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportServiceAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExportServiceAction.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_LASTSAVEFILE = String.valueOf(ExportServiceAction.class) + "_LastExportFileDir";

    private File getExportFile(String strName, int intCount) {
        File expFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), (String)(intCount == 0 ? "" : intCount + "_") + strName);
        if (expFile.exists()) {
            return this.getExportFile(strName, intCount + 1);
        }
        return expFile;
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        block8: {
            try {
                Object[] objAction = mapParam.get("action");
                String strAction = ((String[])objAction)[0];
                WebGisContext wgContext = this.getWgContext();
                if (strAction.startsWith("export_file")) {
                    Object[] objSave = mapParam.get("save");
                    boolean bolSave = Boolean.parseBoolean(((String[])objSave)[0]);
                    Object[] objModuleKey = mapParam.get("modulekey");
                    int intModKey = Integer.parseInt(((String[])objModuleKey)[0]);
                    Object[] objFilename = mapParam.get("filename");
                    String strFilename = ((String[])objFilename)[0];
                    WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getMainWindow(), (String)i18n.get("servlet.actions.FileOpenAction.wait"));
                    File[] expFile = new File[1];
                    Runnable work = () -> {
                        try {
                            ServiceMData exportService = ServiceRegistry.getService((String)"export", (int)0);
                            HashMap<String, Integer> params = new HashMap<String, Integer>();
                            params.put("module_key", intModKey);
                            ServiceRequest req = exportService.createRequest("get_export_file", params);
                            expFile[0] = this.getExportFile(strFilename, 0);
                            req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(expFile[0]));
                            expFile[0] = (File)wgContext.getServiceProvider().execRequest(req).getResult();
                        }
                        catch (Exception e) {
                            dlgWait.setError(e);
                        }
                    };
                    dlgWait.addWorkToDo(work);
                    dlgWait.setVisible(true);
                    if (bolSave) {
                        Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
                        File lastSaveFileDir = new File(wb.getAttribute(KEY_LASTSAVEFILE, (Object)"").toString());
                        JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
                        FileFilter ff = GUISupport.createFileFilter((String)"File", (String[])new String[]{FilenameUtils.getExtension((String)expFile[0].toString())});
                        fChoose.setFileFilter(ff);
                        File preSelFile = lastSaveFileDir;
                        if (!preSelFile.isDirectory()) {
                            preSelFile = preSelFile.getParentFile();
                        }
                        fChoose.setSelectedFile(new File(preSelFile, strFilename));
                        int intOption = fChoose.showSaveDialog(null);
                        if (intOption == 1) {
                            return;
                        }
                        File newFile = fChoose.getSelectedFile();
                        try {
                            FileSupport.moveFile((File)expFile[0], (File)newFile);
                        }
                        catch (Exception e1) {
                            LOG.error(e1.getLocalizedMessage(), (Throwable)e1);
                        }
                        wb.setAttribute(KEY_LASTSAVEFILE, (Object)newFile.getParent());
                        break block8;
                    }
                    OSFile.showFile((File)expFile[0], (boolean)true);
                    break block8;
                }
                LOG.error(String.format("ExportServiceAction - invalid action: %s", strAction));
                ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)new Exception(String.format("Error - invalid action: %s", strAction)), (String)"webgiscli");
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
                throw new SystemException(this.getClass(), (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return "ExportService";
    }
}

