/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.gui.FileSavedDialog;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpTextToFileAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExpTextToFileAction.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_TEXTEXPORTFILE = ExpTextToFileAction.class.getName() + "_File";

    @Override
    public String getName() {
        return "exp_texttofile";
    }

    public static File determineExportFile(String strReportName, String fname, Map<String, File> lastDirs) {
        File res = null;
        File lastDir = lastDirs.get(strReportName);
        if (lastDir != null) {
            res = fname == null ? lastDir : new File(lastDir, fname);
        }
        if (fname != null && res == null) {
            res = new File(fname);
        }
        return res;
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            WebGisContext wgContext = this.getWgContext();
            Whiteboard wb = wgContext.getPermWhiteboard();
            ServiceMData dlgService = ServiceRegistry.getService((String)"text_export", (int)0);
            HashMap params = new HashMap();
            ServiceRequest req = dlgService.createRequest("get_text_export", params);
            Map mapLastDirs = (Map)wb.getAttribute(KEY_TEXTEXPORTFILE, new HashMap());
            Map mapData = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
            String text = StringUtils.defaultIfEmpty((String)((String)mapData.get("text")), (String)"");
            String strReportName = StringUtils.defaultIfEmpty((String)((String)mapData.get("report_name")), (String)"_default");
            String strFileName = StringUtils.defaultIfEmpty((String)((String)mapData.get("fname")), (String)"riwaexport.txt");
            String encoding = StringUtils.defaultIfEmpty((String)((String)mapData.get("encoding")), (String)"US-ASCII");
            String[] arrFormat = new String[]{StringUtils.defaultIfEmpty((String)((String)mapData.get("fileExtension")), (String)"txt")};
            boolean autoSave = BooleanUtils.toBoolean((String)StringUtils.defaultIfEmpty((String)((String)mapData.get("autoSave")), (String)"false"));
            File defaultSaveDir = mapData.get("defaultSaveDir") == null ? null : new File((String)mapData.get("defaultSaveDir"));
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getMainWindow(), (String)i18n.get("servlet.actions.ExpJReportAction.wait"));
            Runnable work = () -> {
                try {
                    File saveFile = ExpTextToFileAction.determineExportFile(strReportName, strFileName, mapLastDirs);
                    if (autoSave && defaultSaveDir != null && defaultSaveDir.exists()) {
                        saveFile = new File(defaultSaveDir, strFileName);
                    } else {
                        JFileChooser fileChoose = GUISupport.createJFileChooser();
                        FileFilter filt = GUISupport.createFileFilter((String)"TXT-File", (String[])arrFormat);
                        fileChoose.setAcceptAllFileFilterUsed(false);
                        fileChoose.setFileFilter(filt);
                        fileChoose.setMultiSelectionEnabled(false);
                        if (saveFile != null) {
                            fileChoose.setSelectedFile(saveFile);
                        }
                        GUISupport.centreOnScreen((Component)fileChoose);
                        fileChoose.setDialogTitle(i18n.get("servlet.actions.ExpTextToFileAction.save-file"));
                        int intOption = fileChoose.showSaveDialog((Component)dlgWait);
                        if (intOption == 1) {
                            return;
                        }
                        saveFile = fileChoose.getSelectedFile();
                    }
                    mapLastDirs.put(strReportName, saveFile.getParentFile());
                    try (FileOutputStream fw = new FileOutputStream(saveFile);){
                        ((OutputStream)fw).write(text.getBytes(encoding));
                    }
                    FileSavedDialog.notifyFileSaved((Window)dlgWait, saveFile);
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(true);
            GUISupport.centreOnScreen((Component)dlgWait);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)dlgWait.getError(), (String)"webgiscli");
            }
            wb.setAttribute(KEY_TEXTEXPORTFILE, (Object)mapLastDirs);
            wgContext.writePermWhiteboard();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }
}

