/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.browser.WindowManager;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DMSSupport;
import de.riwagis.renderinterface.data.PrintDataRow;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.CollectionSupport;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.gui.FileExistsDialog;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.util.ExpSupport;
import de.riwagis.webgiscli.util.WhiteboardHelper;
import de.riwagis.webgiscli.util.print.ClientPrintExporter;
import de.riwagis.webgiscli.util.print.ClientPrintSupportJR;
import de.riwagis.webgiscli.util.print.ClientPrintSupportJRLocalDB;
import de.riwagis.webgiscli.util.print.ClientPrintSupportOffice;
import de.riwagis.webgiscli.util.print.ClientPrintSupportRTF;
import de.riwagis.webgiscli.util.print.ExpFileType;
import java.awt.Component;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpRTFTemplateAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExpRTFTemplateAction.class);
    public static final String PARAM_CALLBACK = "callback";
    public static final String PARAM_REPORT_NAME = "report_name";
    public static final String PARAM_EXPFILE = "expfile";
    public static final String PARAM_EXPTEMPLATE = "exptemplate";
    public static final String PARAM_MULTI_REPORT = "multi_report";
    public static final String PARAM_ORIGINKEYDMS = "originKeyDMS";
    public static final String KEY_REPORT_DATA = "report_data";
    private static final String KEY_RTFTEMPLATE = ExpRTFTemplateAction.class.getName() + "_File";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "exp_rtftemplate";
    }

    @Override
    public void executeInternal(final Map<String, Object[]> mapParam) throws SystemException {
        try {
            final WebGisContext wgContext = this.getWgContext();
            Window parentWindow = this.getMainWindow();
            final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get("servlet.actions.ExpJReportAction.wait"));
            final String originKeyDMS = ExpRTFTemplateAction.readStringParameter(mapParam, PARAM_ORIGINKEYDMS, "");
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    block24: {
                        try {
                            String strCallBack;
                            File expFile;
                            boolean multiReport;
                            File templateFileFinal;
                            Whiteboard wb = wgContext.getPermWhiteboard();
                            boolean canProvideFieldsXMLforDOCXorODT = ExpRTFTemplateAction.checkServerVersion(wgContext, 1, 0, 21, 3);
                            ServiceMData dlgService = ServiceRegistry.getService((String)"rtftemplate_report", (int)0);
                            ServiceRequest req = dlgService.createRequest("get_report_data", new HashMap());
                            Map rtfexp_parameter_data = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
                            String strReportName = rtfexp_parameter_data.containsKey(ExpRTFTemplateAction.PARAM_REPORT_NAME) ? rtfexp_parameter_data.get(ExpRTFTemplateAction.PARAM_REPORT_NAME).toString() : "_default";
                            boolean multiParameterValue = ExpRTFTemplateAction.readBooleanParameter(mapParam, ExpRTFTemplateAction.PARAM_MULTI_REPORT, false);
                            LinkedHashMap dmsmetadata = new LinkedHashMap();
                            Map dmsMeta = (Map)rtfexp_parameter_data.get("dmsmetadata");
                            if (dmsMeta != null) {
                                dmsmetadata.putAll(dmsMeta);
                            }
                            if ((templateFileFinal = this.determineReportTemplate(wb, strReportName)) == null || !templateFileFinal.exists() || !templateFileFinal.isFile()) break block24;
                            ExpFileType expFileType = ExpFileType.getExpFileType4TemplateFile(templateFileFinal);
                            Collection<Map<String, Object>> reportDatas = ExpRTFTemplateAction.buildReportDatas(expFileType, multiParameterValue, rtfexp_parameter_data);
                            boolean bl = multiReport = multiParameterValue || expFileType.isDetermineMultiByReportData() && reportDatas.size() > 1;
                            if (mapParam.containsKey(ExpRTFTemplateAction.PARAM_EXPFILE)) {
                                expFile = new File(((String[])mapParam.get(ExpRTFTemplateAction.PARAM_EXPFILE))[0]);
                                if (multiReport) {
                                    ExpRTFTemplateAction.ensureFolder(expFile);
                                } else {
                                    for (ExpFileType type : ExpFileType.values()) {
                                        File expFileExt4Check = ExpSupport.getFileWithOtherExtension(expFile, type.getTemplateExtension());
                                        File expFileExt = FileExistsDialog.checkFileExists(ExpRTFTemplateAction.this.getMainWindow(), expFileExt4Check);
                                        if (expFileExt != null) continue;
                                        JOptionPane.showMessageDialog(ExpRTFTemplateAction.this.getMainWindow(), i18n.fmt("servlet.actions.ExpRTFTemplateAction.fileNotSaved", new Object[]{expFileExt4Check.toString()}), i18n.get("servlet.actions.ExpRTFTemplateAction.fileNotSavedTitle"), 1);
                                        return;
                                    }
                                }
                            } else if (multiReport) {
                                expFile = ExpRTFTemplateAction.chooseOutputDirectory(ExpRTFTemplateAction.this.getMainWindow());
                                if (expFile == null) {
                                    return;
                                }
                            } else {
                                expFile = null;
                            }
                            File expFileFinal = expFile;
                            ClientPrintExporter exporter = this.buildExporter(expFileType, dlgService, templateFileFinal, reportDatas, canProvideFieldsXMLforDOCXorODT);
                            Collection<File> exportedFiles = this.generateReports(reportDatas, expFileType, exporter, templateFileFinal, expFileFinal);
                            if (exportedFiles.isEmpty()) break block24;
                            boolean takeToDMS = false;
                            LinkedHashSet<String> fileLinks = new LinkedHashSet<String>();
                            if (StringUtils.isNotBlank((String)originKeyDMS)) {
                                File configFileDir = wgContext.getWebGisClient().getConfigFile().getParentFile();
                                try (DMSInterface dMSInterface = DMSSupport.createCurrentDMS((File)configFileDir, (File)DirectoryService.getInstance().getProjectDirectory(ProjectType.WG_CLIENT));){
                                    if (dMSInterface != null) {
                                        boolean bl2 = takeToDMS = JOptionPane.showConfirmDialog(ExpRTFTemplateAction.this.getMainWindow(), String.format("Folgende Dateien wurden erzeugt.%n%s%n%nDiese k\u00f6nnen nun ins DMS '%s' \u00fcbernommen werden oder nur angezeigt werden.%n%nSollen die Dateien ins DMS \u00fcbernommen werden?", StringUtils.join(exportedFiles, (String)"\n"), dMSInterface.getName()), "Dokumente ins DMS \u00fcbernehmen", 0) == 0;
                                        if (takeToDMS) {
                                            for (File currExportedFile : exportedFiles) {
                                                DMSDocument ddoc = dMSInterface.insertToDMS(originKeyDMS, currExportedFile, dmsmetadata, null, -1);
                                                fileLinks.add(ddoc.buildURI());
                                            }
                                        }
                                    }
                                }
                            }
                            if (!takeToDMS) {
                                for (File currFile : exportedFiles) {
                                    fileLinks.add(currFile.toString());
                                }
                                this.showReport(exportedFiles);
                            }
                            String string = strCallBack = mapParam.containsKey(ExpRTFTemplateAction.PARAM_CALLBACK) ? ((String[])mapParam.get(ExpRTFTemplateAction.PARAM_CALLBACK))[0] : null;
                            if (StringUtils.isNotBlank(strCallBack)) {
                                this.executeCallback(multiParameterValue, strCallBack, fileLinks);
                            }
                        }
                        catch (Exception e) {
                            dlgWait.setError(e);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void executeCallback(boolean multiParameterValue, String strCallBack, Collection<String> exportedFiles) throws Exception {
                    block10: {
                        block9: {
                            int intStatus;
                            block8: {
                                if (!multiParameterValue) break block9;
                                WebGisContext wgContext2 = ExpRTFTemplateAction.this.getWgContext();
                                HttpServiceProvider svcProv = (HttpServiceProvider)wgContext2.getServiceProvider();
                                RequestBuilder requestBuilder = RequestBuilder.post();
                                requestBuilder.setCharset(Charset.forName("UTF-8"));
                                String urlCallBack = strCallBack;
                                int posQuestionMark = strCallBack.indexOf(63);
                                if (posQuestionMark > 0) {
                                    urlCallBack = strCallBack.substring(0, posQuestionMark);
                                    String callbackGetRequest = strCallBack.substring(posQuestionMark + 1);
                                    if (StringUtils.isNotEmpty((String)callbackGetRequest)) {
                                        String[] getParameters;
                                        for (String parameterPair : getParameters = callbackGetRequest.split("&")) {
                                            String[] parameter = parameterPair.split("=");
                                            requestBuilder.addParameter(parameter[0], parameter[1]);
                                        }
                                    }
                                }
                                requestBuilder.setUri(svcProv.getURL() + urlCallBack);
                                for (String exportedFile : exportedFiles) {
                                    requestBuilder.addParameter(ExpRTFTemplateAction.PARAM_EXPFILE, exportedFile);
                                }
                                CloseableHttpResponse httpResponse = null;
                                intStatus = 500;
                                try {
                                    HttpUriRequest httpUriRequest = requestBuilder.build();
                                    httpResponse = svcProv.execMethod(httpUriRequest);
                                    intStatus = httpResponse.getStatusLine().getStatusCode();
                                    if (intStatus != 200) {
                                        String strError = HttpServiceProvider.retrieveErrorMessage(httpResponse);
                                        throw new Exception(i18n.fmt("servlet.actions.ExpRTFTemplateAction.error-callback", new Object[]{intStatus, strError}));
                                    }
                                    if (httpResponse == null) break block8;
                                }
                                catch (Throwable throwable) {
                                    if (httpResponse != null) {
                                        IOUtils.closeQuietly(httpResponse);
                                        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                                    }
                                    String strLink = strCallBack.indexOf(63) > 0 ? "&" : "?";
                                    WindowManager.getInstance().callServer(strCallBack + strLink + "finished=true&status=" + intStatus);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((Closeable)httpResponse);
                                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                            }
                            String strLink = strCallBack.indexOf(63) > 0 ? "&" : "?";
                            WindowManager.getInstance().callServer(strCallBack + strLink + "finished=true&status=" + intStatus);
                            break block10;
                        }
                        String firstFile = (String)CollectionSupport.getEntry(exportedFiles);
                        String strLink = strCallBack.indexOf(63) > 0 ? "&" : "?";
                        WindowManager.getInstance().callServer(strCallBack + strLink + "expfile=" + URLEncoder.encode(firstFile, "UTF-8"));
                    }
                }

                public void showReport(Collection<File> exportedFiles) {
                    File firstFile = (File)CollectionSupport.getEntry(exportedFiles);
                    if (exportedFiles.size() == 1) {
                        OSFile.showFile((File)firstFile, (boolean)false);
                    } else {
                        OSFile.showFile((File)firstFile.getParentFile(), (boolean)false);
                    }
                }

                public Collection<File> generateReports(final Collection<Map<String, Object>> reportDatas, ExpFileType expFileType, ClientPrintExporter exporter, File templateFile, File expFileFinal) throws Exception {
                    dlgWait.setCancelable(reportDatas.size() > 1);
                    LinkedHashSet<File> exportedFiles = new LinkedHashSet<File>();
                    final AtomicInteger i = new AtomicInteger(0);
                    for (Map<String, Object> currentReportData : reportDatas) {
                        if (dlgWait.isCanceled()) break;
                        String reportName = ObjectUtils.toString((Object)currentReportData.get(ExpRTFTemplateAction.PARAM_REPORT_NAME));
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                dlgWait.setMessage(i18n.fmt("servlet.actions.ExpRTFTemplateAction.progress-multi-report", new Object[]{i.addAndGet(1), reportDatas.size()}));
                            }
                        });
                        File exportedFile = this.exportReport(expFileType, exporter, templateFile, currentReportData, StringUtils.isEmpty((String)reportName) ? expFileFinal : new File(expFileFinal, reportName + "." + expFileType.getExportExtension()));
                        if (exportedFile == null) continue;
                        exportedFiles.add(exportedFile);
                    }
                    return exportedFiles;
                }

                public File determineReportTemplate(Whiteboard wb, String strReportName) throws Exception {
                    File expTemplateFile = this.retrieveServerTemplate(mapParam.get(ExpRTFTemplateAction.PARAM_EXPTEMPLATE));
                    File templateFileFinal = expTemplateFile == null ? ExpRTFTemplateAction.selectTemplateFile((Component)dlgWait, wb, strReportName) : expTemplateFile;
                    return templateFileFinal;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public File retrieveServerTemplate(Object objExpTemplate) throws SystemException, IOException, DecoderException {
                    File expTemplateFile;
                    String strExpTemplateURL;
                    String string = strExpTemplateURL = objExpTemplate != null ? ((String[])objExpTemplate)[0] : "";
                    if (StringUtils.isNotBlank((String)strExpTemplateURL)) {
                        WebGisContext wgContext2 = ExpRTFTemplateAction.this.getWgContext();
                        HttpServiceProvider svcProv = (HttpServiceProvider)wgContext2.getServiceProvider();
                        HttpGet htmlGet = new HttpGet(svcProv.getURL() + strExpTemplateURL);
                        CloseableHttpResponse httpResponse = null;
                        try {
                            httpResponse = svcProv.execMethod((HttpUriRequest)htmlGet);
                            int intStatus = httpResponse.getStatusLine().getStatusCode();
                            if (intStatus != 200) {
                                String strError = HttpServiceProvider.retrieveErrorMessage(httpResponse);
                                throw new SystemException(String.format("Error at loading server template: %s (Status: %d)", strError, intStatus));
                            }
                            String strExpTemplateFileName = FilenameUtils.getName((String)strExpTemplateURL);
                            expTemplateFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), strExpTemplateFileName);
                            FileStreamProcessor fproc = new FileStreamProcessor(expTemplateFile);
                            fproc.processStream(httpResponse.getEntity().getContent());
                        }
                        finally {
                            if (httpResponse != null) {
                                IOUtils.closeQuietly((Closeable)httpResponse);
                                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                            }
                        }
                    } else {
                        expTemplateFile = null;
                    }
                    return expTemplateFile;
                }

                private File exportReport(ExpFileType expFileType, ClientPrintExporter exporter, File templateFileFinal, Map<String, Object> reportData, File expFile) throws Exception {
                    if (exporter == null) {
                        return null;
                    }
                    File exportedFile = exporter.exportFile(reportData, templateFileFinal);
                    if (exportedFile == null) {
                        return null;
                    }
                    if (expFile == null) {
                        return exportedFile;
                    }
                    if (expFile.isDirectory()) {
                        expFile = ExpSupport.getExportFile(expFile, "export_", "." + FilenameUtils.getExtension((String)exportedFile.getName()));
                    }
                    if ((expFile = ExpSupport.getFileWithOtherExtension(expFile, expFileType.getExportExtension())).getParentFile() == null) {
                        expFile = new File(exportedFile.getParentFile(), expFile.getName());
                    }
                    Path source = exportedFile.toPath();
                    Path destination = expFile.toPath();
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                    return expFile;
                }

                public ClientPrintExporter buildExporter(ExpFileType expFileType, ServiceMData dlgService, File templateFileFinal, Collection<Map<String, Object>> reportData, boolean fieldsXMLforODTDOCX) throws ServiceException {
                    return switch (expFileType) {
                        case ExpFileType.RTF -> {
                            ClientPrintSupportRTF.saveRTFXML(wgContext, dlgService, templateFileFinal, false);
                            yield new ClientPrintSupportRTF();
                        }
                        case ExpFileType.JASPER -> {
                            boolean isNewReportData = ExpRTFTemplateAction.checkNewReportData(reportData, templateFileFinal);
                            yield isNewReportData ? new ClientPrintSupportJRLocalDB() : new ClientPrintSupportJR();
                        }
                        case ExpFileType.DOCX -> {
                            if (fieldsXMLforODTDOCX) {
                                ClientPrintSupportRTF.saveRTFXML(wgContext, dlgService, templateFileFinal, true);
                            }
                            yield ClientPrintSupportOffice.buildExporterDOCX(fieldsXMLforODTDOCX);
                        }
                        case ExpFileType.ODT -> {
                            if (fieldsXMLforODTDOCX) {
                                ClientPrintSupportRTF.saveRTFXML(wgContext, dlgService, templateFileFinal, true);
                            }
                            yield ClientPrintSupportOffice.buildExporterODT(fieldsXMLforODTDOCX);
                        }
                        default -> null;
                    };
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(true);
            dlgWait.setLocationRelativeTo((Component)parentWindow);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ExceptionDialog.handleGuiException((Component)parentWindow, (Throwable)dlgWait.getError(), (String)"webgiscli");
            }
            wgContext.writePermWhiteboard();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public static boolean checkNewReportData(Collection<Map<String, Object>> reportDatas, File templateFileFinal) {
        boolean isNewReportData = false;
        for (Map<String, Object> reportData : reportDatas) {
            isNewReportData |= !reportData.containsKey("geom") || reportData.containsKey(PrintDataRow.class.getCanonicalName());
        }
        return isNewReportData |= ExpRTFTemplateAction.jrHasParameter(templateFileFinal, "localdb");
    }

    public static boolean checkServerVersion(WebGisContext wgContext, int minimalMajor, int minimalMinor, int minimalRelease, int minimalBuild) {
        try {
            ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
            ServiceRequest req = svc.createRequest("server_info");
            Map serverInfo = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
            if (serverInfo != null) {
                String serverVersion = ObjectUtils.toString(serverInfo.get("version"));
                return ExpRTFTemplateAction.checkVersion(serverVersion, minimalMajor, minimalMinor, minimalRelease, minimalBuild);
            }
        }
        catch (ServiceException ex) {
            LOG.warn(String.format("failed to obtain server version from server: %s", ex.getMessage()), (Throwable)ex);
        }
        return false;
    }

    public static boolean checkVersion(String serverVersion, int minimalMajor, int minimalMinor, int minimalRelease, int minimalBuild) throws NumberFormatException {
        Matcher versionMatch;
        Pattern versionPattern = Pattern.compile("\\s*([0-9]+)\\s*\\.\\s*([0-9]+)\\s*\\.\\s*([0-9]+)\\s*(\\.\\s*([0-9]+)?\\s*)?");
        if (StringUtils.isNotBlank((String)serverVersion) && (versionMatch = versionPattern.matcher(serverVersion)).matches()) {
            int currMajor = Integer.valueOf(StringUtils.defaultIfBlank((String)versionMatch.group(1), (String)"0"));
            int currMinor = Integer.valueOf(StringUtils.defaultIfBlank((String)versionMatch.group(2), (String)"0"));
            int currRelease = Integer.valueOf(StringUtils.defaultIfBlank((String)versionMatch.group(3), (String)"0"));
            int currBuild = Integer.valueOf(StringUtils.defaultIfBlank((String)versionMatch.group(5), (String)"0"));
            return currMajor > minimalMajor || currMajor == minimalMajor && (currMinor > minimalMinor || currMinor == minimalMinor && (currRelease > minimalRelease || currRelease == minimalRelease && (currBuild > minimalBuild || currBuild == minimalBuild)));
        }
        return false;
    }

    public static final File selectTemplateFile(Component parent, Whiteboard wb, String strReportName) throws SystemException {
        try {
            File templateFileTmp = WhiteboardHelper.determineLastFile(wb, strReportName, KEY_RTFTEMPLATE);
            File[] choosenFile = new File[1];
            SwingUtilities.invokeAndWait(() -> {
                choosenFile[0] = GUISupport.chooseSingleFile((Component)parent, (String)i18n.get("servlet.actions.ExpRTFTemplateAction.open-template"), (FileFilter[])ExpFileType.getAllFileFilters(), (File)templateFileTmp, (boolean)true);
            });
            File templateFileFinal = choosenFile[0];
            if (templateFileFinal != null) {
                WhiteboardHelper.storeLastFile(wb, strReportName, KEY_RTFTEMPLATE, templateFileFinal);
            }
            return templateFileFinal;
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new SystemException(String.format("error selecting file: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public static final File chooseOutputDirectory(Component parent) {
        JFileChooser fChoose = new JFileChooser();
        fChoose.setDialogTitle(i18n.get("servlet.actions.ExpRTFTemplateAction.output-directory-chooser-title"));
        fChoose.setFileSelectionMode(1);
        fChoose.setAcceptAllFileFilterUsed(false);
        fChoose.setMultiSelectionEnabled(false);
        int intRetVal = fChoose.showSaveDialog(parent);
        File expFile = intRetVal == 1 ? null : fChoose.getSelectedFile();
        return expFile;
    }

    public static final boolean jrHasParameter(File jasperFile, String parametername) {
        if (jasperFile.isFile()) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((File)jasperFile);
                for (JRParameter currParam : jr.getParameters()) {
                    if (!StringUtils.equalsIgnoreCase((String)parametername, (String)currParam.getName())) continue;
                    return true;
                }
            }
            catch (JRException ex) {
                LOG.warn(String.format("unable to get parameter '%s' from '%s': %s", parametername, jasperFile, ex.getMessage()), (Throwable)ex);
            }
        }
        return false;
    }

    public static final boolean isSameFile(File file1, File file2) throws IOException {
        return file1.getCanonicalFile().equals(file2.getCanonicalFile());
    }

    public static String readStringParameter(Map<String, Object[]> mapParam, String paramName, String defaultValue) {
        if (mapParam.containsKey(paramName)) {
            return ((String[])mapParam.get(paramName))[0];
        }
        return defaultValue;
    }

    public static Boolean readBooleanParameter(Map<String, Object[]> mapParam, String paramName, Boolean defaultValue) {
        String paramValue;
        if (mapParam.containsKey(paramName) && StringUtils.equalsIgnoreCase((String)(paramValue = ((String[])mapParam.get(paramName))[0]), (String)"true")) {
            return Boolean.TRUE;
        }
        return defaultValue;
    }

    public static Collection<Map<String, Object>> buildReportDatas(ExpFileType expFileType, boolean multiParameterValue, Map<String, Object> rtfexp_parameter_data) {
        ArrayList<Map<String, Object>> reportDatas = new ArrayList<Map<String, Object>>();
        if ((multiParameterValue || expFileType.isDetermineMultiByReportData()) && rtfexp_parameter_data.containsKey(KEY_REPORT_DATA)) {
            Collection reportDataList = (Collection)rtfexp_parameter_data.get(KEY_REPORT_DATA);
            reportDatas.addAll(reportDataList);
        } else {
            reportDatas.add(rtfexp_parameter_data);
        }
        return reportDatas;
    }

    private static void ensureFolder(File expFile) throws IOException {
        if (!expFile.exists()) {
            expFile.mkdirs();
        }
        if (!expFile.isDirectory()) {
            throw new IOException(String.format("export file '%s' is not a directory!", expFile));
        }
    }
}

