/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpJasperTextAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExpJasperTextAction.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_JASPERTEXT = ExpJasperTextAction.class.getName() + "_File";

    @Override
    public String getName() {
        return "exp_jaspertext";
    }

    public static File determineExportFile(String strReportName, Map<?, ?> mapData, Map<String, File> lastDirs) {
        File res = null;
        String fname = mapData.containsKey("fname") ? (String)mapData.get("fname") : null;
        File lastDir = lastDirs.get(strReportName);
        if (lastDir != null) {
            res = fname == null ? lastDir : new File(lastDir, fname);
        }
        if (fname != null && res == null) {
            res = new File(fname);
        }
        return res;
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        try {
            WebGisContext wgContext = this.getWgContext();
            Whiteboard wb = wgContext.getPermWhiteboard();
            Map mapLastDirs = (Map)wb.getAttribute(KEY_JASPERTEXT, new HashMap());
            ServiceMData dlgService = ServiceRegistry.getService((String)"jasper_report", (int)0);
            HashMap params = new HashMap();
            ServiceRequest req = dlgService.createRequest("get_jasper_text", params);
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.getMainWindow(), (String)i18n.get("servlet.actions.ExpJReportAction.wait"));
            Runnable work = () -> {
                try {
                    Map mapData = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
                    String strReportName = mapData.containsKey("report_name") ? (String)mapData.get("report_name") : "_default";
                    String encoding = ObjectUtils.toString(mapData.get("encoding"));
                    if (StringUtils.isBlank((String)encoding)) {
                        encoding = ObjectUtils.toString((Object)JOptionPane.showInputDialog((Component)dlgWait, "Bitte Ausgabeencoding w\u00e4hlen", "Encoding w\u00e4hlen", 3, null, new String[]{"UTF-8", "ISO-8859-15", "US-ASCII"}, "UTF-8"), (String)"UTF-8");
                    }
                    File saveFile = ExpJasperTextAction.determineExportFile(strReportName, mapData, mapLastDirs);
                    File templateFileFin = GUISupport.saveFile((Component)dlgWait, (String)i18n.get("servlet.actions.ExpTextToFileAction.save-file"), (String)"txt", (File)saveFile, (boolean)true);
                    if (templateFileFin != null) {
                        mapLastDirs.put(strReportName, saveFile.getParentFile());
                        PrintWriter fw = new PrintWriter(templateFileFin, encoding);
                        ((Writer)fw).write((String)mapData.get("jaspertext"));
                        ((Writer)fw).close();
                        int mr = JOptionPane.showConfirmDialog((Component)dlgWait, String.format("Datei '%s' gespeichert.\nSoll diese ge\u00f6ffnet werden?", templateFileFin.getName()), "Datei gespeichert", 0, 1);
                        if (mr == 0) {
                            OSFile.showFile((File)templateFileFin, (boolean)true);
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)dlgWait, "Keine Datei gespeichert.", "Datei gespeichert", 1);
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(true);
            GUISupport.centreOnScreen((Component)dlgWait);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)dlgWait.getError(), (String)"webgiscli");
            }
            wb.setAttribute(KEY_JASPERTEXT, (Object)mapLastDirs);
            wgContext.writePermWhiteboard();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }
}

