/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.gui.ExpJReportDialog;
import de.riwagis.webgiscli.module.gui.ExportFormat;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import de.riwagis.webgiscli.servlet.actions.NoConcurrentActionLock;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpJReportAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExpJReportAction.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String KEY_LASTUSEDLOGO = ExpJReportAction.class.getSimpleName() + "_LastUsedLogo";
    private final NoConcurrentActionLock noConcurrentActionLock = new NoConcurrentActionLock();

    @Override
    public String getName() {
        return "exp_jreport";
    }

    private static File getExportFile(String strSuffix) {
        return ExpJReportAction.getExportFile(strSuffix, 1);
    }

    private static File getExportFile(String strSuffix, int intCount) {
        File expFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), "export_" + intCount + "." + strSuffix);
        if (expFile.exists()) {
            return ExpJReportAction.getExportFile(strSuffix, intCount + 1);
        }
        return expFile;
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        this.noConcurrentActionLock.execute(() -> this.executeInternalNonBlocking(mapParam));
    }

    public void executeInternalNonBlocking(Map<String, Object[]> mapParam) throws SystemException {
        try {
            File expFile;
            WebGisContext wgContext = this.getWgContext();
            ServiceMData dlgService = ServiceRegistry.getService((String)"jasper_report", (int)0);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            ServiceRequest reqLogo = dlgService.createRequest("get_report_logos", params);
            Map mapLogo = (Map)wgContext.getServiceProvider().execRequest(reqLogo).getResult();
            ArrayList<ExportFormat> formats = new ArrayList<ExportFormat>(Arrays.asList(ExportFormat.PDF, ExportFormat.RTF));
            try {
                Collection serverProvidedReportFormats;
                ServiceRequest reqReportInfo = dlgService.createRequest("get_report_info", params);
                Map mapReportInfo = (Map)wgContext.getServiceProvider().execRequest(reqReportInfo).getResult();
                if (!reqReportInfo.hasError() && mapReportInfo != null && mapReportInfo instanceof Map && (serverProvidedReportFormats = (Collection)mapReportInfo.get("report_formats")) != null) {
                    formats.clear();
                    for (Integer currFormatKey : serverProvidedReportFormats) {
                        formats.add(ExportFormat.valueOf(currFormatKey));
                    }
                }
            }
            catch (ServiceException ex) {
                LOG.warn(String.format("Unable to access report info ('%s'). Maybe Client is to old.", ex.getMessage()), (Throwable)ex);
            }
            ExportFormat exportFormat = null;
            int intLogo = -1;
            if (mapParam.containsKey("format")) {
                exportFormat = ExportFormat.valueOf(Integer.parseInt(((String[])mapParam.get("format"))[0]));
            }
            Window parentWindow = this.getMainWindow();
            if (exportFormat == null || !mapLogo.isEmpty()) {
                ExpJReportDialog dlgFormat = new ExpJReportDialog(parentWindow);
                dlgFormat.setVisibleFormats(formats);
                if (exportFormat == null) {
                    exportFormat = ExportFormat.PDF;
                }
                dlgFormat.setFormat(exportFormat);
                dlgFormat.setLogo(mapLogo);
                dlgFormat.setSelectedLogo(this.getLastUsedLogo());
                dlgFormat.pack();
                dlgFormat.setLocationRelativeTo(parentWindow);
                dlgFormat.setVisible(true);
                exportFormat = dlgFormat.getFormat();
                intLogo = dlgFormat.getLogo();
                if (!dlgFormat.wasOkPressed()) {
                    return;
                }
                this.saveLastUsedLogo(intLogo);
            }
            params.put("report_format", exportFormat.getId());
            params.put("report_logo", intLogo);
            boolean chooseDestinationFile = ActionParameterUtils.readFirstValueBoolean(mapParam.get("chooseDestinationFile"), false);
            ServiceRequest req = dlgService.createRequest("get_report", params);
            List<FileFilter> filter = Arrays.asList(GUISupport.createFileFilter((String)exportFormat.name(), (String[])new String[]{exportFormat.getExtension()}));
            File file = expFile = chooseDestinationFile ? GUISupport.saveFile((Component)parentWindow, (String)i18n.get("gui.fileexistsdialog.saveAs"), filter, (File)ExpJReportAction.getExportFile(exportFormat.getExtension()), (boolean)true) : ExpJReportAction.getExportFile(exportFormat.getExtension());
            if (expFile == null) {
                return;
            }
            req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(expFile));
            Runnable work = () -> {
                try {
                    wgContext.getServiceProvider().execRequest(req).getResult();
                }
                catch (Exception e) {
                    ExceptionDialog.handleGuiException((Component)parentWindow, (Throwable)e, (String)"webgiscli");
                }
            };
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentWindow, (String)i18n.get("servlet.actions.ExpJReportAction.wait"), (Runnable)work);
            dlgWait.setCancelable(false);
            dlgWait.setLocationRelativeTo((Component)parentWindow);
            dlgWait.setVisible(true);
            OSFile.showFile((File)expFile, (boolean)true);
        }
        catch (ServiceException | NumberFormatException e) {
            ExceptionDialog.handleGuiException((Component)this.getMainWindow(), (Throwable)e, (String)"webgiscli");
            throw new SystemException(this.getClass(), e);
        }
    }

    private int getLastUsedLogo() {
        return this.getWgContext().getPermWhiteboard().getAttribute(KEY_LASTUSEDLOGO, -1);
    }

    private void saveLastUsedLogo(int lastUsedLogo) {
        this.getWgContext().getPermWhiteboard().setAttribute(KEY_LASTUSEDLOGO, lastUsedLogo);
        this.getWgContext().writePermWhiteboard();
    }
}

