/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessageHandler;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAction;
import java.awt.Component;
import java.util.Map;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;

public class DialogContextAction
extends AbstractAction {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    public static final String PARAM_ACTION = "action";
    private final Map<String, BiFunction<DialogContext, Map<String, Object[]>, String>> actions = Map.of("sendMessage", (context, params) -> this.sendMessageAction((DialogContext)context, (Map<String, Object[]>)params));

    @Override
    public String getName() {
        return "DialogContext";
    }

    @Override
    public String execute(Map<String, Object[]> mapParam) throws SystemException {
        Boolean waitForResult = Boolean.valueOf(ActionParameterUtils.readFirstValueString(mapParam.get("waitForResult"), "false"));
        try {
            String actionName = DialogContextAction.getParamString(mapParam, PARAM_ACTION);
            BiFunction<DialogContext, Map<String, Object[]>, String> action = this.actions.get(actionName);
            if (action == null) {
                throw new Exception(String.format("action '%s' not found.", actionName));
            }
            String moduleId = ActionParameterUtils.readFirstValueString(mapParam.get("moduleId"), "");
            String dialogId = ActionParameterUtils.readFirstValueString(mapParam.get("dialogId"), "");
            DialogContext dialog = this.getWgContext().getModule(moduleId).getDialog(dialogId);
            if (dialog == null) {
                throw new SystemException(i18n.get("servlet.actions.DialogContextAction.notFound"));
            }
            if (!(dialog instanceof SPMessageHandler)) {
                throw new SystemException(i18n.get("servlet.actions.DialogContextAction.notSupported"));
            }
            return action.apply(dialog, mapParam);
        }
        catch (Exception e) {
            if (!waitForResult.booleanValue()) {
                ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
            }
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private String sendMessageAction(DialogContext dialog, Map<String, Object[]> mapParam) {
        String function = ActionParameterUtils.readFirstValueString(mapParam.get("func"), "");
        String args = ActionParameterUtils.readFirstValueString(mapParam.get("args"), "[]");
        Boolean waitForResult = Boolean.valueOf(ActionParameterUtils.readFirstValueString(mapParam.get("waitForResult"), "false"));
        String targetDialogId = ActionParameterUtils.readFirstValueString(mapParam.get("detailsId"), dialog.getID());
        if (waitForResult.booleanValue()) {
            return ((SPMessageHandler)dialog).sendMessage(new SPMessage(targetDialogId, function, args, waitForResult));
        }
        SwingUtilities.invokeLater(() -> ((SPMessageHandler)dialog).sendMessage(new SPMessage(targetDialogId, function, args, waitForResult)));
        return "";
    }
}

