/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.ActionParameterUtils;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserWindowAction
extends AbstractAsyncAction {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserWindowAction.class);
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    @Override
    public String getName() {
        return "BrowserWindow";
    }

    @Override
    public void executeInternal(Map<String, Object[]> mapParam) {
        try {
            String strAction = ActionParameterUtils.readFirstValueString(mapParam.get("action"), "open");
            String strName = ActionParameterUtils.readFirstValueString(mapParam.get("name"), null);
            if (null == strAction) {
                return;
            }
            switch (strAction) {
                case "open": {
                    BrowserFrame brFrame;
                    this.bugfixForKeepOnTopDeadLock();
                    String strURL = ActionParameterUtils.readFirstValueString(mapParam.get("url"), null);
                    int intWidth = ActionParameterUtils.readFirstValueInteger(mapParam.get("width"), 500);
                    int intHeight = ActionParameterUtils.readFirstValueInteger(mapParam.get("height"), 500);
                    Boolean objToolbar = ActionParameterUtils.readFirstValueBoolean(mapParam.get("toolbar"), Boolean.FALSE);
                    Boolean showOnly = ActionParameterUtils.readFirstValueBoolean(mapParam.get("showOnly"), Boolean.FALSE);
                    String addressType = ActionParameterUtils.readFirstValueString(mapParam.get("addressType"), "webgis");
                    if (StringUtils.isBlank((String)strURL)) {
                        throw new Exception("Invalid Parameters");
                    }
                    BrowserFrame existingBrowserFrame = WindowManager.getInstance().getWindow(strName);
                    if (!showOnly.booleanValue() || existingBrowserFrame == null) {
                        OpenWindowConfiguration.Builder builder = WindowManager.getInstance().window().name(strName).size(intWidth, intHeight);
                        switch (addressType) {
                            case "proxy": {
                                builder.proxyAddress(strURL);
                                break;
                            }
                            case "absolute": {
                                builder.absoluteAddress(strURL);
                                break;
                            }
                            default: {
                                builder.webgisAddress(strURL);
                            }
                        }
                        brFrame = builder.open();
                    } else {
                        brFrame = existingBrowserFrame;
                    }
                    brFrame.setVisible(true);
                    if (!objToolbar.booleanValue()) break;
                    SwingUtilities.invokeLater(() -> ((BrowserFrame)brFrame).showToolbar());
                    break;
                }
                case "close": {
                    WindowManager.getInstance().closeWindow(strName);
                    break;
                }
                case "call_server": {
                    String strURL = ActionParameterUtils.readFirstValueString(mapParam.get("url"), null);
                    String rawPostData = ActionParameterUtils.readFirstValueString(mapParam.get("post_data"), null);
                    if (StringUtils.isBlank((String)strURL)) {
                        throw new Exception("Invalid Parameters");
                    }
                    if (rawPostData == null) {
                        WindowManager.getInstance().callServer(strURL);
                        break;
                    }
                    Map<String, String> postData = this.splitParametersToMap(rawPostData);
                    CountDownLatch latch = new CountDownLatch(1);
                    WindowManager.getInstance().callServer(strURL, postData, () -> latch.countDown());
                    WaitDialog waitDialog = new WaitDialog((Window)WebGisContext.getWebGisClientFrame(), i18n.get("common.wait"), () -> {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    });
                    waitDialog.setVisible(200L);
                    break;
                }
                case "execjs": {
                    String windowName = ActionParameterUtils.readFirstValueString(mapParam.get("window"), "");
                    String jsscript = ActionParameterUtils.readFirstValueString(mapParam.get("jsscript"), "");
                    if (StringUtils.isNotBlank((String)windowName) && StringUtils.isNotBlank((String)jsscript)) {
                        BrowserFrame brFrame = WindowManager.getInstance().getWindow(windowName);
                        if (brFrame != null) {
                            brFrame.execJS(jsscript);
                            break;
                        }
                        LOG.warn(String.format("window '%s' not available", windowName));
                        break;
                    }
                    LOG.warn(String.format("illegal windowname ('%s') or empty javascript ('%s')", windowName, jsscript));
                    break;
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this.getWgContext().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
        }
    }
}

