/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet.actions;

import de.riwagis.browser.jcef.JCEFBrowserFrame;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.actions.LocalAction;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncAction
implements LocalAction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncAction.class);
    private final WebGisContext wgContext = WebGisConfiguration.getWebGisContext();

    public final WebGisContext getWgContext() {
        return this.wgContext;
    }

    public abstract void executeInternal(Map<String, Object[]> var1) throws SystemException;

    public static final Object retrieveFirstParameterValue(Map<String, Object[]> mapParam, String paramName) {
        return AbstractAsyncAction.retrieveFirstParameterValue(mapParam, paramName, null);
    }

    public static final Object retrieveFirstParameterValue(Map<String, Object[]> mapParam, String paramName, Object defaultValue) {
        Object res = defaultValue;
        Object[] x = mapParam.get(paramName);
        if (x != null) {
            res = x[0];
        }
        return res;
    }

    public static final String retrieveParameterString(Map<String, Object[]> mapParam, String paramName) {
        return AbstractAsyncAction.retrieveParameterString(mapParam, paramName, null);
    }

    public static final String retrieveParameterString(Map<String, Object[]> mapParam, String paramName, String defaultValue) {
        Object[] x = mapParam.get(paramName);
        String res = x != null ? StringUtils.join((Object[])x) : defaultValue;
        return res;
    }

    @Override
    public String execute(Map<String, Object[]> mapParam) {
        SwingUtilities.invokeLater(() -> {
            try {
                this.executeInternal(mapParam);
            }
            catch (Exception e) {
                LOG.error("Error executing action", (Throwable)e);
            }
        });
        return "";
    }

    protected Window getFocusedOrMainWindow() {
        Window focusedWindow;
        Frame fallback = WebGisContext.getWebGisClientFrame();
        for (focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow(); focusedWindow != null && !focusedWindow.isVisible(); focusedWindow = focusedWindow.getOwner()) {
        }
        if (focusedWindow == null) {
            this.restoreStateIfNecessary(fallback);
            return fallback;
        }
        return focusedWindow;
    }

    protected Window getMainWindow() {
        Frame mainWindow = WebGisContext.getWebGisClientFrame();
        this.bugfixForKeepOnTopDeadLock();
        this.restoreStateIfNecessary(mainWindow);
        return mainWindow;
    }

    protected void bugfixForKeepOnTopDeadLock() {
        Arrays.stream(Frame.getFrames()).filter(frame -> frame instanceof JCEFBrowserFrame).filter(frame -> frame.isAlwaysOnTop()).forEach(frame -> {
            LOG.warn("openWindow invoked. Disabling always-on-top for module dialog to prevent deadlocks.");
            frame.setAlwaysOnTop(false);
        });
    }

    private void restoreStateIfNecessary(Frame frame) {
        if (frame != null && frame.getState() != 0) {
            frame.setState(0);
        }
    }

    protected Map<String, String> splitParametersToMap(String parameters) {
        return Arrays.stream(parameters.split("&")).map(p -> p.split("=")).collect(Collectors.toMap(p -> p[0], p -> ((String[])p).length == 2 ? p[1] : ""));
    }
}

