/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Token {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Token.class);
    private static final Lock lockGetToken = new ReentrantLock();
    private final String tokenType;
    private String rawToken = "";
    private Instant tokenValidUntil = null;

    public Token(String tokenType) {
        this.tokenType = tokenType;
    }

    public String get() {
        return this.rawToken;
    }

    public void invalidate() {
        this.rawToken = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(HttpServiceProvider httpProv) {
        lockGetToken.lock();
        try {
            if (this.isValid()) {
                return;
            }
            HttpGet httpRequest = new HttpGet(new URI(httpProv.getURL() + "api/token/create/" + this.tokenType));
            try (CloseableHttpResponse response = httpProv.execMethod((HttpUriRequest)httpRequest);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.rawToken = EntityUtils.toString((HttpEntity)response.getEntity());
                    long lifeTime = Token.getLifetimeInMinutes(this.rawToken);
                    this.tokenValidUntil = LocalDateTime.now().plus(Duration.ofMinutes(lifeTime > 5L ? lifeTime - 5L : lifeTime)).atZone(ZoneId.systemDefault()).toInstant();
                } else {
                    this.rawToken = "";
                    this.tokenValidUntil = null;
                    log.error("Error retrieving {} token. StatusCode: {}", (Object)this.tokenType, (Object)response.getStatusLine().getStatusCode());
                }
            }
        }
        catch (Exception e) {
            log.error("Error creating request for retrieving token.", (Throwable)e);
        }
        finally {
            lockGetToken.unlock();
        }
    }

    public boolean isValid() {
        if (this.rawToken.isBlank()) {
            return false;
        }
        if (this.tokenValidUntil == null) {
            return false;
        }
        return this.tokenValidUntil.compareTo(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()) > 0;
    }

    private static long getLifetimeInMinutes(String token) {
        try {
            DecodedJWT decJwt = JWT.decode((String)token);
            Date iat = decJwt.getIssuedAt();
            Date exp = decJwt.getExpiresAt();
            return TimeUnit.MINUTES.convert(exp.getTime() - iat.getTime(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error(String.format("Error parsing token %s", token), (Throwable)e);
            return 0L;
        }
    }
}

