/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.mitre.dsmiley.httpproxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaProxyServlet
extends ProxyServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiwaProxyServlet.class);
    protected HttpServiceProvider httpProv;

    public void init() throws ServletException {
        super.init();
        WebGisContext wgContext = WebGisConfiguration.getWebGisContext();
        this.httpProv = (HttpServiceProvider)wgContext.getServiceProvider();
    }

    protected void initTarget() throws ServletException {
        this.doPreserveCookies = true;
    }

    protected HttpClient createHttpClient(RequestConfig requestConfig) {
        WebGisContext wgContext = WebGisConfiguration.getWebGisContext();
        HttpServiceProvider httpProv = (HttpServiceProvider)wgContext.getServiceProvider();
        return httpProv.getHttpClientInternal();
    }

    protected HttpResponse doExecute(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpRequest proxyRequest) throws IOException {
        if (this.doLog) {
            this.log("forwarding " + servletRequest.getMethod() + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
        }
        try {
            return this.httpProv.execMethod(this.getTargetHost(servletRequest), proxyRequest);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

