/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.module.special.system.ShowSystemDialogAction;
import de.riwagis.webgiscli.servlet.actions.BrowserWindowAction;
import de.riwagis.webgiscli.servlet.actions.ChangePasswordAction;
import de.riwagis.webgiscli.servlet.actions.DialogContextAction;
import de.riwagis.webgiscli.servlet.actions.ExpJReportAction;
import de.riwagis.webgiscli.servlet.actions.ExpJasperTextAction;
import de.riwagis.webgiscli.servlet.actions.ExpRTFTemplateAction;
import de.riwagis.webgiscli.servlet.actions.ExpTextToFileAction;
import de.riwagis.webgiscli.servlet.actions.ExportServiceAction;
import de.riwagis.webgiscli.servlet.actions.FileHandlingAction;
import de.riwagis.webgiscli.servlet.actions.FileLinkAction;
import de.riwagis.webgiscli.servlet.actions.FileOnServerAction;
import de.riwagis.webgiscli.servlet.actions.GenericOverlayAction;
import de.riwagis.webgiscli.servlet.actions.GeometryAction;
import de.riwagis.webgiscli.servlet.actions.Gis3DContextAction;
import de.riwagis.webgiscli.servlet.actions.GisContextAction;
import de.riwagis.webgiscli.servlet.actions.ImportAction;
import de.riwagis.webgiscli.servlet.actions.InterfaceAction;
import de.riwagis.webgiscli.servlet.actions.LocalAction;
import de.riwagis.webgiscli.servlet.actions.ModuleContextAction;
import de.riwagis.webgiscli.servlet.actions.ModuleInfoAction;
import de.riwagis.webgiscli.servlet.actions.OpenMailerAction;
import de.riwagis.webgiscli.servlet.actions.OpenURLAction;
import de.riwagis.webgiscli.servlet.actions.ReportFileHandlingAction;
import de.riwagis.webgiscli.servlet.actions.SaveServerStreamAction;
import de.riwagis.webgiscli.servlet.actions.SetLocalPasswordAction;
import de.riwagis.webgiscli.servlet.actions.ShowDialogAction;
import de.riwagis.webgiscli.servlet.actions.UserReloginAction;
import de.riwagis.webgiscli.servlet.actions.XlsExportAction;
import de.riwagis.webutil.http.HttpSupport;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalActionServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(LocalActionServlet.class);
    private static final Map<String, LocalAction> lstActions = new LinkedHashMap<String, LocalAction>();

    public static final void addAction(LocalAction locac) {
        String lcName = locac.getName().toLowerCase();
        if (lstActions.containsKey(lcName)) {
            throw new IllegalArgumentException("Action already registered: " + String.valueOf(locac));
        }
        lstActions.put(lcName, locac);
    }

    public static LocalAction getActionByName(String strName) throws SystemException {
        String lcName = strName.toLowerCase();
        LocalAction res = lstActions.get(lcName);
        if (res == null) {
            throw new SystemException(LocalActionServlet.class, "No LocalAction found for " + strName);
        }
        return res;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSupport.addDefaultHeaders((HttpServletResponse)response);
        response.addHeader("Access-Control-Allow-Methods", "GET, OPTIONS, HEAD, PUT, POST");
        PrintWriter resout = response.getWriter();
        try {
            LocalAction action;
            String strReturn;
            String strAction = request.getParameter("localaction");
            Map mapParam = request.getParameterMap();
            if (strAction != null && (strReturn = (action = LocalActionServlet.getActionByName(strAction)).execute(mapParam)) != null) {
                resout.print(strReturn);
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Error processing LocalAction: %s", e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "LocalActionServlet executes specific local actions.";
    }

    static {
        LocalActionServlet.addAction(new XlsExportAction());
        LocalActionServlet.addAction(new ExpRTFTemplateAction());
        LocalActionServlet.addAction(new FileLinkAction());
        LocalActionServlet.addAction(new FileOnServerAction());
        LocalActionServlet.addAction(new BrowserWindowAction());
        LocalActionServlet.addAction(new ExpJReportAction());
        LocalActionServlet.addAction(new ExpJasperTextAction());
        LocalActionServlet.addAction(new OpenURLAction());
        LocalActionServlet.addAction(new ShowDialogAction());
        LocalActionServlet.addAction(new GeometryAction());
        LocalActionServlet.addAction(new GisContextAction());
        LocalActionServlet.addAction(new InterfaceAction());
        LocalActionServlet.addAction(new ImportAction());
        LocalActionServlet.addAction(new OpenMailerAction());
        LocalActionServlet.addAction(new ModuleContextAction());
        LocalActionServlet.addAction(new ExpTextToFileAction());
        LocalActionServlet.addAction(new ExportServiceAction());
        LocalActionServlet.addAction(new ChangePasswordAction());
        LocalActionServlet.addAction(new UserReloginAction());
        LocalActionServlet.addAction(new GenericOverlayAction());
        LocalActionServlet.addAction(new Gis3DContextAction());
        LocalActionServlet.addAction(new SaveServerStreamAction());
        LocalActionServlet.addAction(new DialogContextAction());
        LocalActionServlet.addAction(new FileHandlingAction());
        LocalActionServlet.addAction(new ReportFileHandlingAction());
        LocalActionServlet.addAction(new SetLocalPasswordAction());
        LocalActionServlet.addAction(new ModuleInfoAction());
        LocalActionServlet.addAction(new ShowSystemDialogAction());
    }
}

