/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import de.riwagis.icons.IconLoader;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.network.NetworkSupport;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.RiwaProxyServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBridgeServlet
extends RiwaProxyServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpBridgeServlet.class);
    public static final Map<String, String> mapRedirectLocal = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        HttpHost serverHost;
        if (StringUtils.equalsIgnoreCase((String)servletRequest.getMethod(), (String)"GET") && mapRedirectLocal.containsKey(servletRequest.getRequestURI())) {
            String strRessource = mapRedirectLocal.get(servletRequest.getRequestURI());
            InputStream inRsc = IconLoader.class.getResourceAsStream(strRessource);
            ServletOutputStream resout = servletResponse.getOutputStream();
            try {
                servletResponse.setContentType("image/svg+xml");
                IOUtils.copy((InputStream)inRsc, (OutputStream)resout);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inRsc);
            }
            return;
        }
        try {
            if (!StringUtils.equalsIgnoreCase((String)WebGisConfiguration.getHttpBridgeIP(), (String)servletRequest.getRemoteAddr())) {
                throw new Exception(String.format("Invalid IP-Adress tried to connect to application. Remote:%s Local:%s", servletRequest.getRemoteAddr(), NetworkSupport.getIPAdress()));
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)new SystemException(((Object)((Object)this)).getClass(), (Throwable)e), (String)"webgiscli");
            if (!servletResponse.isCommitted()) {
                this.resetResponseQuietly(servletResponse);
                int status = 500;
                servletResponse.sendError(status, e.getMessage());
            }
            return;
        }
        WebGisContext wgContext = WebGisConfiguration.getWebGisContext();
        HttpServiceProvider httpProv = (HttpServiceProvider)wgContext.getServiceProvider();
        String strServer = httpProv.getURL();
        try {
            URI uri = new URI(strServer);
            serverHost = URIUtils.extractHost((URI)uri);
        }
        catch (Exception e) {
            throw new ServletException("Error trying to process Server-URL in HttpBridgeServlet: " + String.valueOf(e), (Throwable)e);
        }
        servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)serverHost);
        servletRequest.setAttribute(ATTR_TARGET_URI, (Object)"");
        try {
            super.service(servletRequest, servletResponse);
        }
        finally {
            if (servletResponse.getStatus() == 401) {
                httpProv.relogonOnUnauthorizedStatusCode();
            }
        }
    }

    protected void copyRequestHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest, String headerName) {
        if (headerName.equalsIgnoreCase("Cookie")) {
            return;
        }
        super.copyRequestHeader(servletRequest, proxyRequest, headerName);
    }

    protected void copyResponseHeader(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Header header) {
        String headerName = header.getName();
        if (headerName.equalsIgnoreCase("Set-Cookie") || headerName.equalsIgnoreCase("Set-Cookie2")) {
            return;
        }
        super.copyResponseHeader(servletRequest, servletResponse, header);
    }

    public final void resetResponseQuietly(HttpServletResponse response) {
        try {
            response.reset();
        }
        catch (Exception e1) {
            log.trace(String.format("Error resetting response: %s", e1.getMessage()), (Throwable)e1);
        }
    }

    static {
        String serverURI = ((HttpServiceProvider)WebGisContext.getInstance().getServiceProvider()).getURI();
        mapRedirectLocal.put(serverURI + "pics/common_actions.svg", "common_action_undefined.svg");
        mapRedirectLocal.put(serverURI + "pics/common_actions.svg", "common_actions.svg");
        mapRedirectLocal.put(serverURI + "pics/common_add.svg", "common_add.svg");
        mapRedirectLocal.put(serverURI + "pics/common_add_detail.svg", "common_add_detail.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_down.svg", "common_arrow_down.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_left.svg", "common_arrow_left.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_right.svg", "common_arrow_right.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_up.svg", "common_arrow_up.svg");
        mapRedirectLocal.put(serverURI + "pics/common_attention.svg", "common_attention.svg");
        mapRedirectLocal.put(serverURI + "pics/common_attribute.svg", "common_attribute.svg");
        mapRedirectLocal.put(serverURI + "pics/common_back.svg", "common_back.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_blue.svg", "common_box_blue.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_gray.svg", "common_box_gray.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_green.svg", "common_box_green.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_red.svg", "common_box_red.svg");
        mapRedirectLocal.put(serverURI + "pics/common_calculator.svg", "common_calculator.svg");
        mapRedirectLocal.put(serverURI + "pics/common_calendar.svg", "common_calendar.svg");
        mapRedirectLocal.put(serverURI + "pics/common_close.svg", "common_close.svg");
        mapRedirectLocal.put(serverURI + "pics/common_copy.svg", "common_copy.svg");
        mapRedirectLocal.put(serverURI + "pics/common_copy_style.svg", "common_copy_style.svg");
        mapRedirectLocal.put(serverURI + "pics/common_dashboard.svg", "common_dashboard.svg");
        mapRedirectLocal.put(serverURI + "pics/common_default.svg", "common_default.svg");
        mapRedirectLocal.put(serverURI + "pics/common_delete.svg", "common_delete.svg");
        mapRedirectLocal.put(serverURI + "pics/common_delete2.svg", "common_delete2.svg");
        mapRedirectLocal.put(serverURI + "pics/common_delete2_fill.svg", "common_delete2_fill.svg");
        mapRedirectLocal.put(serverURI + "pics/common_delete_all.svg", "common_delete_all.svg");
        mapRedirectLocal.put(serverURI + "pics/common_duplicate.svg", "common_duplicate.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit.svg", "common_edit.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_all.svg", "common_edit_all.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_paper.svg", "common_edit_paper.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_redo.svg", "common_edit_redo.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_rollback.svg", "common_edit_rollback.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_tools.svg", "common_edit_tools.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_undo.svg", "common_edit_undo.svg");
        mapRedirectLocal.put(serverURI + "pics/common_empty.svg", "common_empty.svg");
        mapRedirectLocal.put(serverURI + "pics/common_eye_off.svg", "common_eye_off.svg");
        mapRedirectLocal.put(serverURI + "pics/common_eye_off_gray.svg", "common_eye_off_gray.svg");
        mapRedirectLocal.put(serverURI + "pics/common_eye_on.svg", "common_eye_on.svg");
        mapRedirectLocal.put(serverURI + "pics/common_hand.svg", "common_hand.svg");
        mapRedirectLocal.put(serverURI + "pics/common_help.svg", "common_help.svg");
        mapRedirectLocal.put(serverURI + "pics/common_highlight.svg", "common_highlight.svg");
        mapRedirectLocal.put(serverURI + "pics/common_history_alt.svg", "common_history_alt.svg");
        mapRedirectLocal.put(serverURI + "pics/common_history_ist.svg", "common_history_ist.svg");
        mapRedirectLocal.put(serverURI + "pics/common_info.svg", "common_info.svg");
        mapRedirectLocal.put(serverURI + "pics/common_info_url.svg", "common_info_url.svg");
        mapRedirectLocal.put(serverURI + "pics/common_less.svg", "common_less.svg");
        mapRedirectLocal.put(serverURI + "pics/common_lock.svg", "common_lock.svg");
        mapRedirectLocal.put(serverURI + "pics/common_logout.svg", "common_logout.svg");
        mapRedirectLocal.put(serverURI + "pics/common_map.svg", "common_map.svg");
        mapRedirectLocal.put(serverURI + "pics/common_measure.svg", "common_measure.svg");
        mapRedirectLocal.put(serverURI + "pics/common_measure_object.svg", "common_measure_object.svg");
        mapRedirectLocal.put(serverURI + "pics/common_minus.svg", "common_minus.svg");
        mapRedirectLocal.put(serverURI + "pics/common_more.svg", "common_more.svg");
        mapRedirectLocal.put(serverURI + "pics/common_noimage.svg", "common_noimage.svg");
        mapRedirectLocal.put(serverURI + "pics/common_number.svg", "common_number.svg");
        mapRedirectLocal.put(serverURI + "pics/common_ok.svg", "common_ok.svg");
        mapRedirectLocal.put(serverURI + "pics/common_ok_blue.svg", "common_ok_blue.svg");
        mapRedirectLocal.put(serverURI + "pics/common_options.svg", "common_options.svg");
        mapRedirectLocal.put(serverURI + "pics/common_palette.svg", "common_palette.svg");
        mapRedirectLocal.put(serverURI + "pics/common_palette2.svg", "common_palette2.svg");
        mapRedirectLocal.put(serverURI + "pics/common_plan_deactivate.svg", "common_plan_deactivate.svg");
        mapRedirectLocal.put(serverURI + "pics/common_plan_load.svg", "common_plan_load.svg");
        mapRedirectLocal.put(serverURI + "pics/common_plan_load_with_edits.svg", "common_plan_load_with_edits.svg");
        mapRedirectLocal.put(serverURI + "pics/common_plus.svg", "common_plus.svg");
        mapRedirectLocal.put(serverURI + "pics/common_print.svg", "common_print.svg");
        mapRedirectLocal.put(serverURI + "pics/common_project_detail.svg", "common_project_detail.svg");
        mapRedirectLocal.put(serverURI + "pics/common_project_master.svg", "common_project_master.svg");
        mapRedirectLocal.put(serverURI + "pics/common_reload.svg", "common_reload.svg");
        mapRedirectLocal.put(serverURI + "pics/common_reload_small.svg", "common_reload_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_reload_green.svg", "common_reload_green.svg");
        mapRedirectLocal.put(serverURI + "pics/common_reload_red.svg", "common_reload_red.svg");
        mapRedirectLocal.put(serverURI + "pics/common_remove.svg", "common_remove.svg");
        mapRedirectLocal.put(serverURI + "pics/common_reset_default.svg", "common_reset_default.svg");
        mapRedirectLocal.put(serverURI + "pics/common_save.svg", "common_save.svg");
        mapRedirectLocal.put(serverURI + "pics/common_search.svg", "common_search.svg");
        mapRedirectLocal.put(serverURI + "pics/common_select.svg", "common_select.svg");
        mapRedirectLocal.put(serverURI + "pics/common_select_red.svg", "common_select_red.svg");
        mapRedirectLocal.put(serverURI + "pics/common_select_small.svg", "common_select_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_set_default.svg", "common_set_default.svg");
        mapRedirectLocal.put(serverURI + "pics/common_show.svg", "common_show.svg");
        mapRedirectLocal.put(serverURI + "pics/common_show_detail.svg", "common_show_detail.svg");
        mapRedirectLocal.put(serverURI + "pics/common_show_master.svg", "common_show_master.svg");
        mapRedirectLocal.put(serverURI + "pics/common_stop.svg", "common_stop.svg");
        mapRedirectLocal.put(serverURI + "pics/common_style_get.svg", "common_style_get.svg");
        mapRedirectLocal.put(serverURI + "pics/common_tooltip.svg", "common_tooltip.svg");
        mapRedirectLocal.put(serverURI + "pics/common_tooltip_off.svg", "common_tooltip_off.svg");
        mapRedirectLocal.put(serverURI + "pics/common_tooltip_on.svg", "common_tooltip_on.svg");
        mapRedirectLocal.put(serverURI + "pics/common_triangle_down.svg", "common_triangle_down.svg");
        mapRedirectLocal.put(serverURI + "pics/common_triangle_up.svg", "common_triangle_up.svg");
        mapRedirectLocal.put(serverURI + "pics/common_unlock.svg", "common_unlock.svg");
        mapRedirectLocal.put(serverURI + "pics/common_unselect.svg", "common_unselect.svg");
        mapRedirectLocal.put(serverURI + "pics/common_unselect_small.svg", "common_unselect_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_view_html.svg", "common_view_html.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_chain.svg", "dimension_chain.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_edit_text.svg", "dimension_edit_text.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_object.svg", "dimension_object.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_orthogonal.svg", "dimension_orthogonal.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_positioning.svg", "dimension_positioning.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_range.svg", "dimension_range.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_reset.svg", "dimension_reset.svg");
        mapRedirectLocal.put(serverURI + "pics/dimension_text.svg", "dimension_text.svg");
        mapRedirectLocal.put(serverURI + "pics/export_data.svg", "export_data.svg");
        mapRedirectLocal.put(serverURI + "pics/export_excel.svg", "export_excel.svg");
        mapRedirectLocal.put(serverURI + "pics/export_excel2.svg", "export_excel2.svg");
        mapRedirectLocal.put(serverURI + "pics/export_html.svg", "export_html.svg");
        mapRedirectLocal.put(serverURI + "pics/export_pdf.svg", "export_pdf.svg");
        mapRedirectLocal.put(serverURI + "pics/export_report.svg", "export_report.svg");
        mapRedirectLocal.put(serverURI + "pics/export_report2.svg", "export_report2.svg");
        mapRedirectLocal.put(serverURI + "pics/export_rtf.svg", "export_rtf.svg");
        mapRedirectLocal.put(serverURI + "pics/export_word.svg", "export_word.svg");
        mapRedirectLocal.put(serverURI + "pics/fibu_export.svg", "fibu_export.svg");
        mapRedirectLocal.put(serverURI + "pics/fibu_export_filter.svg", "fibu_export_filter.svg");
        mapRedirectLocal.put(serverURI + "pics/fibu_recreate.svg", "fibu_recreate.svg");
        mapRedirectLocal.put(serverURI + "pics/fibu_storno.svg", "fibu_storno.svg");
        mapRedirectLocal.put(serverURI + "pics/file_folder_closed.svg", "file_folder_closed.svg");
        mapRedirectLocal.put(serverURI + "pics/file_folder_open.svg", "file_folder_open.svg");
        mapRedirectLocal.put(serverURI + "pics/file_import.svg", "file_import.svg");
        mapRedirectLocal.put(serverURI + "pics/file_new.svg", "file_new.svg");
        mapRedirectLocal.put(serverURI + "pics/file_open.svg", "file_open.svg");
        mapRedirectLocal.put(serverURI + "pics/file_options.svg", "file_options.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_add.svg", "filter_add.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_add_all.svg", "filter_add_all.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_exchange.svg", "filter_exchange.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_exchange_all.svg", "filter_exchange_all.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_execute.svg", "filter_execute.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_remove.svg", "filter_remove.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_remove_all.svg", "filter_remove_all.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_reset.svg", "filter_reset.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_show.svg", "filter_show.svg");
        mapRedirectLocal.put(serverURI + "pics/filter_update.svg", "filter_update.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add.svg", "geometry_add.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_circle.svg", "geometry_add_circle.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_line.svg", "geometry_add_line.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_parallel.svg", "geometry_add_parallel.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_point.svg", "geometry_add_point.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_point_coordinates.svg", "geometry_add_point_coordinates.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_polygon.svg", "geometry_add_polygon.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_rectangle.svg", "geometry_add_rectangle.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_add_vertex.svg", "geometry_add_vertex.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_align.svg", "geometry_align.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_arc_section.svg", "geometry_arc_section.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_auto_complete.svg", "geometry_auto_complete.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_buffer.svg", "geometry_buffer.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_catch_points.svg", "geometry_catch_points.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_cross_bearing.svg", "geometry_cross_bearing.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_cut_line.svg", "geometry_cut_line.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_delete_vertex.svg", "geometry_delete_vertex.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_edit.svg", "geometry_edit.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_edit_line.svg", "geometry_edit_line.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_info.svg", "geometry_info.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_intersection.svg", "geometry_intersection.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_label.svg", "geometry_label.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_limit.svg", "geometry_limit.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_line_to_polygon.svg", "geometry_line_to_polygon.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_link.svg", "geometry_link.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_move.svg", "geometry_move.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_move_vertex.svg", "geometry_move_vertex.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_orthogonal.svg", "geometry_orthogonal.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_remove.svg", "geometry_remove.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_rotate.svg", "geometry_rotate.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_scale.svg", "geometry_scale.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_split.svg", "geometry_split.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_union.svg", "geometry_union.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_use_selection.svg", "geometry_use_selection.svg");
        mapRedirectLocal.put(serverURI + "pics/geometry_vertical_section.svg", "geometry_vertical_section.svg");
        mapRedirectLocal.put(serverURI + "pics/label_get_attributes.svg", "label_get_attributes.svg");
        mapRedirectLocal.put(serverURI + "pics/label_move.svg", "label_move.svg");
        mapRedirectLocal.put(serverURI + "pics/label_object.svg", "label_object.svg");
        mapRedirectLocal.put(serverURI + "pics/label_rotate.svg", "label_rotate.svg");
        mapRedirectLocal.put(serverURI + "pics/label_set_attributes.svg", "label_set_attributes.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_above.svg", "layer_above.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_add.svg", "layer_add.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_add_dataset.svg", "layer_add_dataset.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_add_themes.svg", "layer_add_themes.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_below.svg", "layer_below.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_cad.svg", "layer_cad.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_default.svg", "layer_default.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_delete_theme.svg", "layer_delete_theme.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_dimension.svg", "layer_dimension.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_error.svg", "layer_error.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_fill.svg", "layer_fill.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_geometry.svg", "layer_geometry.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_info.svg", "layer_info.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_number.svg", "layer_number.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_options.svg", "layer_options.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_raster.svg", "layer_raster.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_redline.svg", "layer_redline.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_select.svg", "layer_select.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_theme.svg", "layer_theme.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_themes.svg", "layer_themes.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_transparency.svg", "layer_transparency.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_undo.svg", "layer_undo.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_undo_all.svg", "layer_undo_all.svg");
        mapRedirectLocal.put(serverURI + "pics/legend_export.svg", "legend_export.svg");
        mapRedirectLocal.put(serverURI + "pics/legend_import.svg", "legend_import.svg");
        mapRedirectLocal.put(serverURI + "pics/module_subvis.svg", "module_subvis.svg");
        mapRedirectLocal.put(serverURI + "pics/point_number.svg", "point_number.svg");
        mapRedirectLocal.put(serverURI + "pics/selection_clear.svg", "selection_clear.svg");
        mapRedirectLocal.put(serverURI + "pics/selection_invert.svg", "selection_invert.svg");
        mapRedirectLocal.put(serverURI + "pics/selection_select.svg", "selection_select.svg");
        mapRedirectLocal.put(serverURI + "pics/selection_select_line.svg", "selection_select_line.svg");
        mapRedirectLocal.put(serverURI + "pics/selection_select_part.svg", "selection_select_part.svg");
        mapRedirectLocal.put(serverURI + "pics/show_attributes.svg", "show_attributes.svg");
        mapRedirectLocal.put(serverURI + "pics/show_backward.svg", "show_backward.svg");
        mapRedirectLocal.put(serverURI + "pics/show_data.svg", "show_data.svg");
        mapRedirectLocal.put(serverURI + "pics/show_data_active.svg", "show_data_active.svg");
        mapRedirectLocal.put(serverURI + "pics/show_downward.svg", "show_downward.svg");
        mapRedirectLocal.put(serverURI + "pics/show_filter.svg", "show_filter.svg");
        mapRedirectLocal.put(serverURI + "pics/show_first.svg", "show_first.svg");
        mapRedirectLocal.put(serverURI + "pics/show_first_red.svg", "show_first_red.svg");
        mapRedirectLocal.put(serverURI + "pics/show_forward.svg", "show_forward.svg");
        mapRedirectLocal.put(serverURI + "pics/show_grid_info.svg", "show_grid_info.svg");
        mapRedirectLocal.put(serverURI + "pics/show_last.svg", "show_last.svg");
        mapRedirectLocal.put(serverURI + "pics/show_last_red.svg", "show_last_red.svg");
        mapRedirectLocal.put(serverURI + "pics/show_link.svg", "show_link.svg");
        mapRedirectLocal.put(serverURI + "pics/show_next.svg", "show_next.svg");
        mapRedirectLocal.put(serverURI + "pics/show_next_gray.svg", "show_next_gray.svg");
        mapRedirectLocal.put(serverURI + "pics/show_next_red.svg", "show_next_red.svg");
        mapRedirectLocal.put(serverURI + "pics/show_previous.svg", "show_previous.svg");
        mapRedirectLocal.put(serverURI + "pics/show_previous_gray.svg", "show_previous_gray.svg");
        mapRedirectLocal.put(serverURI + "pics/show_previous_red.svg", "show_previous_red.svg");
        mapRedirectLocal.put(serverURI + "pics/show_profile.svg", "show_profile.svg");
        mapRedirectLocal.put(serverURI + "pics/show_search.svg", "show_search.svg");
        mapRedirectLocal.put(serverURI + "pics/show_sum.svg", "show_sum.svg");
        mapRedirectLocal.put(serverURI + "pics/show_tree_expanded.svg", "show_tree_expanded.svg");
        mapRedirectLocal.put(serverURI + "pics/show_upward.svg", "show_upward.svg");
        mapRedirectLocal.put(serverURI + "pics/show_wms_legend.svg", "show_wms_legend.svg");
        mapRedirectLocal.put(serverURI + "pics/table_delete_row.svg", "table_delete_row.svg");
        mapRedirectLocal.put(serverURI + "pics/table_filter_add.svg", "table_filter_add.svg");
        mapRedirectLocal.put(serverURI + "pics/table_filter_remove.svg", "table_filter_remove.svg");
        mapRedirectLocal.put(serverURI + "pics/table_selection_invert.svg", "table_selection_invert.svg");
        mapRedirectLocal.put(serverURI + "pics/table_select_all.svg", "table_select_all.svg");
        mapRedirectLocal.put(serverURI + "pics/table_show.svg", "table_show.svg");
        mapRedirectLocal.put(serverURI + "pics/template_add.svg", "template_add.svg");
        mapRedirectLocal.put(serverURI + "pics/template_delete.svg", "template_delete.svg");
        mapRedirectLocal.put(serverURI + "pics/template_edit.svg", "template_edit.svg");
        mapRedirectLocal.put(serverURI + "pics/template_search.svg", "template_search.svg");
        mapRedirectLocal.put(serverURI + "pics/template_show.svg", "template_show.svg");
        mapRedirectLocal.put(serverURI + "pics/test.txt", "test.txt");
        mapRedirectLocal.put(serverURI + "pics/zoom_bounds.svg", "zoom_bounds.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_geometry.svg", "zoom_geometry.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_geometry_all.svg", "zoom_geometry_all.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_in.svg", "zoom_in.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_next_row.svg", "zoom_next_row.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_out.svg", "zoom_out.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_previous_row.svg", "zoom_previous_row.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_row.svg", "zoom_row.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_selected.svg", "zoom_selected.svg");
        mapRedirectLocal.put(serverURI + "pics/common_add_small.svg", "common_add_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_down_small.svg", "common_arrow_down_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_left_small.svg", "common_arrow_left_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_right_small.svg", "common_arrow_right_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_arrow_up_small.svg", "common_arrow_up_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_attention_small.svg", "common_attention_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_calculator_small.svg", "common_calculator_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_calendar_small.svg", "common_calendar_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_copy_small.svg", "common_copy_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_delete_small.svg", "common_delete_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_blue.svg", "common_edit_blue.svg");
        mapRedirectLocal.put(serverURI + "pics/common_edit_small.svg", "common_edit_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_eye_on_small.svg", "common_eye_on_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_lock_small.svg", "common_lock_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_remove_small.svg", "common_remove_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_save_small.svg", "common_save_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_unlock_small.svg", "common_unlock_small.svg");
        mapRedirectLocal.put(serverURI + "pics/file_new_small.svg", "file_new_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_data_active_small.svg", "show_data_active_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_data_small.svg", "show_data_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_forward_small.svg", "show_forward_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_link_small.svg", "show_link_small.svg");
        mapRedirectLocal.put(serverURI + "pics/wait.svg", "wait.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_geometry_all_small.svg", "zoom_geometry_all_small.svg");
        mapRedirectLocal.put(serverURI + "pics/zoom_geometry_small.svg", "zoom_geometry_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_gray_small.svg", "common_box_gray_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_green_small.svg", "common_box_green_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_box_red_small.svg", "common_box_red_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_minus_small.svg", "common_minus_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_ok_small.svg", "common_ok_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_plus_small.svg", "common_plus_small.svg");
        mapRedirectLocal.put(serverURI + "pics/file_folder_closed_small.svg", "file_folder_closed_small.svg");
        mapRedirectLocal.put(serverURI + "pics/file_folder_open_small.svg", "file_folder_open_small.svg");
        mapRedirectLocal.put(serverURI + "pics/layer_error_small.svg", "layer_error_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_backward_small.svg", "show_backward_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_first_small.svg", "show_first_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_last_small.svg", "show_last_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_next_small.svg", "show_next_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_previous_small.svg", "show_previous_small.svg");
        mapRedirectLocal.put(serverURI + "pics/show_search_small.svg", "show_search_small.svg");
        mapRedirectLocal.put(serverURI + "pics/template_show_small.svg", "template_show_small.svg");
        mapRedirectLocal.put(serverURI + "pics/export_report2_small.svg", "export_report2_small.svg");
        mapRedirectLocal.put(serverURI + "pics/common_lock_green.svg", "common_lock_green.svg");
        mapRedirectLocal.put(serverURI + "pics/common_unlock_red.svg", "common_unlock_red.svg");
        mapRedirectLocal.put(serverURI + "pics/export_report_print_excel.svg", "export_report_print_excel.svg");
    }
}

